#ifndef __XTOOLS_H
#define __XTOOLS_H

#include <X11/Xlib.h>

#include "LinkedList.h"

class XTools
{
	private:
		static Display *_dpy;

        static int _damage_event_base;
        static int _damage_error_base;

        typedef int (*ErrorHandler)(Display *display, XErrorEvent *event);
        static ErrorHandler _prevErrorHandler;

	public:
		static Atom _NET_CLIENT_LIST;
		static Atom _NET_WM_WINDOW_TYPE;
		static Atom _NET_WM_WINDOW_TYPE_NORMAL;
		static Atom _NET_WM_NAME;
		static Atom _NET_WM_STATE;
		static Atom _NET_WM_STATE_FULLSCREEN;
		static Atom _NET_WM_STATE_HIDDEN;
        static Atom _NET_ACTIVE_WINDOW;
        static Atom _NET_SHOWING_DESKTOP;
        static Atom _NET_CLOSE_WINDOW;
        static Atom WM_STATE;

		static void init(Display *dpy);

		static LinkedList<Window> windowList(Window rootWindow);

		static char* windowTitle_alloc(Window window);

        static bool checkCompositeExtension();
        static bool checkDamageExtension();


        static void enableCompositeRedirect();
        static void disableCompositeRedirect();


        static int damageEventBase();
        static int damageErrorBase();


        static void switchToWindow(Window window);
        static void closeWindow(Window window);

        static int errorHandler(Display *display, XErrorEvent *event);

        static void showDesktop();

        static bool checkIfWindowMinimized(Window window);

        static Window activeWindow();
};

#endif
