#ifndef __THUMBNAIL_H
#define __THUMBNAIL_H

#include <X11/Xlib.h>
#include <X11/extensions/Xdamage.h>
#include <X11/extensions/Xrender.h>


class TeleWindow;

class Thumbnail
{
    private:
        Display *_dpy;

        TeleWindow *_teleWindow;
        Window _clientWindow;
        char *_title;

//        Window _win;

        Damage _damage;

        Picture _clientPict;
        Picture _pict;

        int _depth;
        Pixmap _cachePixmap;
        Picture _cachePicture;
        bool _cacheValid;

        int _x, _y;
        int _width, _height;

        int _clientWidth, _clientHeight;
        int _clientScaledWidth, _clientScaledHeight;

        int _clientDecoX, _clientDecoY;
        int _clientDecoXScaled, _clientDecoYScaled;

        int _clientOffsetX, _clientOffsetY;

        bool _clientDestroyed;

        bool _minimized;


        void onResize();
        void onClientResize(XEvent *event);

    public:
        Thumbnail(TeleWindow *teleWindow, Window clientWindow);
        ~Thumbnail();

//        Window window();
        Window clientWindow();

        char* title();

        void setGeometry(int x, int y, int w, int h);
        int x() { return _x; }
        int y() { return _y; }
        int width() { return _width; }
        int height() { return _height; }

        int realWidth() { return _clientScaledWidth; }
        int realHeight() { return _clientScaledHeight; }

        Picture clientPicture() { return _clientPict; }

        int clientDecoX() { return _clientDecoX; }
        int clientDecoY() { return _clientDecoY; }

        bool inside(int x, int y);

        void onClientEvent(XEvent *event);

        void paint();

        void switchToClient();
        void closeClient();
};


#endif
