#ifndef __TELEWINDOW_H
#define __TELEWINDOW_H

#include <X11/Xlib.h>
#include <X11/extensions/Xrender.h>
#include <X11/Xft/Xft.h>

#include <Imlib2.h>

#include "LinkedList.h"
#include "Mappings.h"

class Thumbnail;

class TeleWindow
{
    private:
        friend class Thumbnail;

        static const int XMargin;
        static const int YMargin;

        Display *_dpy;
        Window _rootWindow;
        Window _win;
        Picture _picture;
        Picture _bufferPicture;

        XRenderPictFormat *_xrenderFormat;
        XRenderPictFormat *_xrenderRGBAFormat;

        bool _breakEventLoop;

        LinkedList<Thumbnail*> _thumbnails;
        bool _thumbnailsListDirty;

        int _width;
        int _height;
        bool _shown;

        KeyCode _hotKeyCode;
        bool _hotKeyPressed;
        KeyCode _selectKeyCode;

        Pixmap _bgPixmap;
        GC _gc;

        XftFont *_xftFont;
        XftDraw *_xftDraw;
        Pixmap _bufferPix;


        Pixmap _headerLeftPix;
        Pixmap _headerMiddlePix;
        Pixmap _headerRightPix;
        Pixmap _headerLeftSelectedPix;
        Pixmap _headerMiddleSelectedPix;
        Pixmap _headerRightSelectedPix;
        Picture _headerLeftPict;
        Picture _headerMiddlePict;
        Picture _headerRightPict;
        Picture _headerLeftSelectedPict;
        Picture _headerMiddleSelectedPict;
        Picture _headerRightSelectedPict;

        XRenderColor _borderColor;
        XRenderColor _borderActiveColor;

        int _borderWidth;
        int _headerHeight;
        int _headerLeftWidth;
        int _headerRightWidth;
        int _textLeftMargin;
        int _textRightMargin;
        int _closeButtonXSpan;
        int _closeButtonYSpan;


        int _scrollBaseX, _scrollBaseY;
        int _scrollX, _scrollY;
        bool _buttonPressed;
        bool _wasScrolling;
        int _buttonPressX, _buttonPressY;
        bool _repaintOnIdle;


        Thumbnail *_activeThumbnail;


        Mappings _mappings;


        void onHotKeyPress();
        void onHotKeyRelease();


        void onButtonPress(XButtonEvent *event);
        void onButtonRelease(XButtonEvent *event);
        void onButtonMotion(XMotionEvent *event);

        void onIdle();

        void setNewSize(int width, int height);
        void reloadBackground();
        void recreateBufferPixmap();

        bool loadARGBImage(
            const char *filename,
            Drawable parent,
            Pixmap *pixmap,
            Picture *picture,
            int *width,
            int *height);

        void animate(Thumbnail *thumb, bool toSmall);

    public:
        TeleWindow(Display *dpy);
        ~TeleWindow();

        Display* display();
        Window window();
        Picture picture();

        void show();
        void hide();
        bool shown();

        int scrollX()
        { return _scrollX; }
        int scrollY()
        { return _scrollY; }

        void updateThumbnailsList();
        void layoutThumbnails();

        void removeThumbnail(Thumbnail *thumb);

        void eventLoop();

        void onRootEvent(XEvent *event);
        void onEvent(XEvent *event);

        void paint();

        void onThumbRedrawed(Thumbnail *thumb);

        void internalCommand(const char *action);

        void markThumbnailsListDirty();
};


#endif
