#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "TeleWindow.h"
#include "XTools.h"
#include "Settings.h"

int main(int argc, char *argv[])
{
    Settings settings;

    Display *dpy = XOpenDisplay(0);

    if (! dpy)
    {
        fprintf(stderr, "Cannot open display\n");
        return 1;
    }

    XTools::init(dpy);

    if (! XTools::checkCompositeExtension())
    {
        fprintf(stderr, "XServer doesn't support Composite\n");
        return 1;
    }

    if (! XTools::checkDamageExtension())
    {
        fprintf(stderr, "XServer doesn't support Damage\n");
        return 1;
    }

    XTools::enableCompositeRedirect();

    TeleWindow *window = new TeleWindow(dpy);
    //window->show();

    window->eventLoop();

    delete window;

    XCloseDisplay(dpy);
}
