#ifndef __SETTINGS_H
#define __SETTINGS_H

class Settings
{
    private:
        static Settings *_instance;

        bool _scrollingEnabled;
        char *_backgroundFilename;

        char *_headerLeftFilename;
        char *_headerRightFilename;
        char *_headerMiddleFilename;
        char *_borderColor;

        int _borderWidth;
        int _textLeftMargin;
        int _textRightMargin;
        int _closeButtonXSpan;
        int _closeButtonYSpan;

        int _fontSize;
        int _textYOffset;


        void parseLine(const char *line);
        void parseOpt(const char *key, const char *value);

        bool parseBool(const char *value);

    public:
        Settings();
        ~Settings();

        static Settings* instance();

        bool scrollingEnabled() { return _scrollingEnabled; }
        const char* backgroundFilename() { return _backgroundFilename; }

        const char* headerLeftFilename() { return _headerLeftFilename; }
        const char* headerRightFilename() { return _headerRightFilename; }
        const char* headerMiddleFilename() { return _headerMiddleFilename; }
        char* borderColor() { return _borderColor; }

        int borderWidth() { return _borderWidth; }
        int textLeftMargin() { return _textLeftMargin; }
        int textRightMargin() { return _textRightMargin; }
        int closeButtonXSpan() { return _closeButtonXSpan; }
        int closeButtonYSpan() { return _closeButtonYSpan; }

        int fontSize() { return _fontSize; }
        int textYOffset() { return _textYOffset; }
};

#endif
