import dbus.service


class ChannelInterfaceMessages(dbus.service.Interface):

    @dbus.service.method('org.freedesktop.Telepathy.Channel.Interface.Messages', in_signature='aa{sv}u', out_signature='s')
    def SendMessage(self, Message, Flags):
        raise NotImplementedError

    @dbus.service.method('org.freedesktop.Telepathy.Channel.Interface.Messages', in_signature='uau', out_signature='a{uv}')
    def GetPendingMessageContent(self, Message_ID, Parts):
        raise NotImplementedError

    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Interface.Messages', signature='aa{sv}us')
    def MessageSent(self, Content, Flags, Message_Token):
        pass

    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Interface.Messages', signature='au')
    def PendingMessagesRemoved(self, Message_IDs):
        pass

    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Interface.Messages', signature='aa{sv}')
    def MessageReveived(self, Message):
        pass
