import gtk
import hildondesktop
import sqlite3
import gobject
import osso
#import dbus
import os
import pango

class statusbar_applet(hildondesktop.TaskNavigatorItem):
    def __init__(self):
       hildondesktop.TaskNavigatorItem.__init__(self)
       
       #Set up icon
       self.icon_theme = gtk.icon_theme_get_default()

       #osso
       self.ossoc = osso.Context("tearbookmarks","0.3.1",False)

       #rpc
       self.rpc = osso.Rpc(self.ossoc)

       #dbus, perhaps? -- crashes tear
       #self.session_bus = dbus.SessionBus()
       
       self.mtime = 0

       self.create_menu()
       
       self.button = hildondesktop.ToggleButton()
       self.button.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("tear",64,0)))
       self.button.set_name("hildon-navigator-button-tear")
       self.button.set_size_request(64,64)
       self.button.connect("toggled",self.popup_menu)

       self.add(self.button)
       self.show_all()
    
    def create_menu(self):
       ntime = os.path.getmtime("/home/user/.tear/tear.db")
       if self.mtime == ntime:
           return False
       self.mtime = ntime
       self.conn = sqlite3.connect("/home/user/.tear/tear.db")
       self.c = self.conn.cursor()

       self.create_sub()
       self.menu.set_size_request(494,-1)

       self.menu.set_name("menu_from_navigator")
       self.menu.connect('hide',self.menu_off)
       hildondesktop.hildon_menu_set_thumb_mode(self.menu,True)
       self.menu.show_all()
       
       self.c.close()
       self.conn.close()

    def html_escape(self,text):
       text = text.replace('&', '&amp;')
       text = text.replace('"', '&quot;')
       text = text.replace("'", '&#39;')
       text = text.replace(">", '&gt;')
       text = text.replace("<", '&lt;')
       return text

    def menu_off(self,widget):
        self.c.close()
        self.conn.close()
        self.button.set_active(False)
        self.menu.popdown()
        
    def popup_menu(self,widget,data=None):
        #self.create_menu()
        if(self.button.get_active() == True):
             self.create_menu() # TODO: Do I really want to do this?  create_menu is "smarter" now, but this could still cause some slowness
             self.conn = sqlite3.connect("/home/user/.tear/tear.db")
             self.c = self.conn.cursor()
             self.menu.popup(None,None,self.menu_position,0,gtk.get_current_event_time())

    def open_tear(self,widget):
        self.rpc.rpc_run_with_defaults("tear","OpenAddress")

    def open_bookmarks(self,widget):
        (pid,stdin,stdout,stderr) = gobject.spawn_async(["python /usr/bin/tear-bookmarks/tear-bookmarks.py"])

    def open_url(self,widget,data):
        # DBus will only respond if tear is running...
        if os.system("ps -ef | grep -v grep | grep tear") == 0:
            #service = self.session_bus.get_object("com.nokia.tear","/com/nokia/tear")
            #service.OpenAddress(data)
            
            #self.rpc.rpc_run_with_defaults("tear","OpenAddress",(data,),False)
            
            os.system("dbus-send --session --type=method_call --dest=com.nokia.Tear /com/nokia/tear com.nokia.Tear.OpenAddress string:\"%s\"" % data)
            #I hate doing things like this... but whenever I get_object, tear crashes
        else:
            (pid,stdin,stdout,stderr) = gobject.spawn_async(["/usr/bin/tear", str(data)])
            #mdlg = gtk.MessageDialog(None,0,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,"Opening %s" % data)
            #mdlg.run()
            #mdlg.destroy()
    
    def create_sub(self):
        self.menu = gtk.Menu()
        #self.menu.set_size_request(500,0)
        menu_item = gtk.ImageMenuItem("Open New Window")
        menu_item.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("tear",64,0)))
        menu_item.connect('activate',self.open_tear)
        self.menu.append(menu_item)
        menu_item = gtk.ImageMenuItem("Bookmarks")
        menu_item.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("qgn_gene_bookmark_manager",64,0)))
        menu_item.connect('activate',self.open_bookmarks)
        self.menu.append(menu_item)

        menu_item = gtk.SeparatorMenuItem()
        self.menu.append(menu_item)

        self.c.execute("select * from quickdata where type='bookmark' and path='/'")
        for row in self.c:
            menuitem = hildondesktop.hildon_thumb_menu_item_new_with_labels(row[1],row[1],row[2])
            menuitem.get_child().set_ellipsize(pango.ELLIPSIZE_END)
            menuitem.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("qgn_list_gene_bookmark",64,0)))
            self.menu.append(menuitem)
            menuitem.connect('activate',self.open_url,row[2])
            
        self.c.execute("select * from quickdata where type='bookmark_folder' and path='/'")
        for row in self.c:
            subm = gtk.Menu()
            menuitem = gtk.ImageMenuItem(row[1])
            menuitem.get_child().set_ellipsize(pango.ELLIPSIZE_END)
            menuitem.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("qgn_list_fldr_mybookmarks_cls",64,0)))
            menuitem.set_submenu(subm)
            subm.set_size_request(494,-1)
            self.menu.append(menuitem)
            menuitem.connect('activate',self.gen_sub,subm,row[3]+row[1]+"/",menuitem)

    def gen_sub(self,widget,menu,folder,parent):
        menu = gtk.Menu()
        empty = True

        self.c.execute("select * from quickdata where type='bookmark' and path=?", (folder,))
        for row in self.c:
            menuitem = hildondesktop.hildon_thumb_menu_item_new_with_labels(row[1],row[1],row[2])
            menuitem.get_child().set_ellipsize(pango.ELLIPSIZE_END)
            menuitem.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("qgn_list_gene_bookmark",64,0)))
            menu.append(menuitem)
            menuitem.connect('activate',self.open_url,row[2])
            empty = False
            
        self.c.execute("select * from quickdata where type='bookmark_folder' and path=?",(folder,))
        for row in self.c:
            subm = gtk.Menu()
            menuitem = gtk.ImageMenuItem(row[1])
            menuitem.get_child().set_ellipsize(pango.ELLIPSIZE_END)
            menuitem.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("qgn_list_fldr_mybookmarks_cls",64,0)))
            menuitem.set_submenu(subm)
            menu.append(menuitem)
            menuitem.connect('activate',self.gen_sub,subm,row[3]+row[1]+"/",menuitem)
            empty = False
            
        if empty == True:
            menu.append(gtk.SeparatorMenuItem()) # Otherwise, things look weird
        menu.show_all()
        menu.set_size_request(300,-1)
        hildondesktop.hildon_menu_set_thumb_mode(menu,True)
        parent.set_submenu(menu)
        #parent.connect('activate',None)
        
    def menu_position(self,data=None):
        x = self.button.allocation.x + self.button.allocation.width
        y = self.button.allocation.y
        return (x,y,True)
        
        
def hd_plugin_get_objects():
     plugin = statusbar_applet()
     return [plugin]
#plugin.open_url(None, "http://digg.com")
#plugin = statusbar_applet()
#plugin.open_tear(None)
#plugin.destroy()
