import sqlite3
import gtk
import pygtk
import hildon
import gobject

class TearBookmarks:

    def __init__(self):
        self.admin = TearBookmarksAdmin()
        self.gui = TearBookmarksGUI(self.admin)

class TearBookmarksGUI:

    def __init__(self, admin):
        self.admin = admin
        self._init_list()
        self._init_window()
        self.window_in_fullscreen = False

    def _init_window(self):
	try:
	    import hildon
    	    self.window = hildon.Window()
    	except:
    	    self.window = gtk.Window()
    	self.window.set_title("Bookmarks")
        self.window.connect("destroy", self._destroy)
        self.window.connect("key-press-event", self._on_key_press)
        self.window.connect("window-state-event", self._on_window_state_change)

        self.vbox = gtk.VBox()
        self.hbox = gtk.HBox(False, 10)
        try:
    	    import mokoui
    	    self.scroll_area = mokoui.FingerScroll()
    	    self.scroll_area.set_property('spring-speed', 0)
    	    self.folder_area = mokoui.FingerScroll()
    	    self.folder_area.set_property('spring-speed', 0)
    	except:
    	    self.scroll_area = gtk.ScrolledWindow()
    	    self.scroll_area.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    	    self.folder_area = gtk.ScrolledWindow()
    	    self.folder_area.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.folder_area.set_size_request(120,100)
        self.scroll_area.add(self.treeview)
        self.folder_area.add(self.folder_view)
        sep = gtk.VSeparator()
        self.hbox.pack_start(self.folder_area, expand=False)
        self.hbox.pack_start(sep, expand=False)
        self.hbox.pack_start(self.scroll_area, expand=True)
        self.vbox.pack_start(self.hbox)

        self.button_box = gtk.HBox(True,0)
        self.add_button = gtk.Button("Add")
        self.edit_button = gtk.Button("Edit")
        self.delete_button = gtk.Button("Delete")
        self.visit_button = gtk.Button("Visit")
        self.exit_button = gtk.Button("Exit")

        self.add_button.connect("clicked", self._on_add_button)
        add_image = gtk.Image()
        add_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("add.png", 26, 26))
        self.add_button.set_image(add_image)
        add_image.show()

        self.edit_button.connect("clicked", self._on_edit_button)
        edit_image = gtk.Image()
        edit_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("edit.png", 26, 26))
        self.edit_button.set_image(edit_image)
        edit_image.show()

        self.delete_button.connect("clicked", self._on_delete_button)
        delete_image = gtk.Image()
        delete_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("delete.png", 26, 26))
        self.delete_button.set_image(delete_image)
        delete_image.show()

        self.visit_button.connect("clicked", self._on_visit_button)
        visit_image = gtk.Image()
        visit_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("visit.png", 32, 32))
        self.visit_button.set_image(visit_image)
        visit_image.show()

        self.exit_button.connect("clicked", self._destroy)
        exit_image = gtk.Image()
        exit_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("exit.png", 32, 32))
        self.exit_button.set_image(exit_image)
        exit_image.show()

        self.button_box.pack_start(self.add_button)
        self.button_box.pack_start(self.edit_button)
        self.button_box.pack_start(self.delete_button)
        self.button_box.pack_start(self.visit_button)
        self.button_box.pack_start(self.exit_button)
        self.vbox.pack_start(self.button_box, expand=False)

        self.window.add(self.vbox)
        self.window.show_all()

    def _init_list(self):
        self.model = gtk.ListStore(gtk.gdk.Pixbuf,str, str)
        self.treeview = gtk.TreeView(self.model)
        self.treeview.connect("row-activated", self.list_handler)
        self.favi_column = gtk.TreeViewColumn()
        self.favi_cell = gtk.CellRendererPixbuf()
        self.favi_column.pack_start(self.favi_cell)
        self.favi_column.add_attribute(self.favi_cell, 'pixbuf', 0)
        self.treeview.append_column(self.favi_column)

        self.text_column = gtk.TreeViewColumn()
        self.text_cell = gtk.CellRendererText()
        self.text_column.pack_start(self.text_cell)
        self.text_column.add_attribute(self.text_cell, 'text', 1)
        self.treeview.append_column(self.text_column)

	self.folder_model = gtk.ListStore(gtk.gdk.Pixbuf, str)
	self.folder_view = gtk.TreeView(self.folder_model)
	self.folder_icon_column = gtk.TreeViewColumn()
	self.folder_icon_cell = gtk.CellRendererPixbuf()
	self.folder_icon_column.pack_start(self.folder_icon_cell)
	self.folder_icon_column.add_attribute(self.folder_icon_cell, 'pixbuf', 0)
	self.folder_view.append_column(self.folder_icon_column)
	
	self.folder_column = gtk.TreeViewColumn()
	self.folder_cell = gtk.CellRendererText()
	self.folder_column.pack_start(self.folder_cell)
	self.folder_column.add_attribute(self.folder_cell, 'text', 1)
	self.folder_view.append_column(self.folder_column)
	
	self.folder_model.append([gtk.gdk.pixbuf_new_from_file_at_size("folder.png",32, 32), '/'])

        self._update_list()

    def _update_list(self):
        self.model.clear()
        self.bookmarks = self.admin.get_bookmark_list()
        for bookmark in self.bookmarks:
            self.model.append(bookmark)

    def list_handler(self, widget, *args):
        selected = self.treeview.get_selection()
        (self.model, index) = selected.get_selected()
        if index:
            position = int(selected.get_selected_rows()[1][0][0])
            self._init_popup(self.model[position][2])
            self.menu.popup(None,None,None,0,gtk.get_current_event_time())

    def _init_popup(self, position):
        self.menu = gtk.Menu()

        menu_item = gtk.MenuItem("Visit")
        menu_item.connect('activate',self._on_visit_button)
        self.menu.append(menu_item)

        menu_item = gtk.MenuItem("Edit")
        menu_item.connect('activate',self._on_edit_button)
        self.menu.append(menu_item)

        menu_item = gtk.MenuItem("Delete")
        menu_item.connect('activate',self._on_delete_button)
        self.menu.append(menu_item)

        self.menu.set_name("menu_from_statusbar")
        self.menu.connect("selection-done", self.menu_done)
        self.menu.show_all()

    def do_nothing(self,arg):
        pass

    def menu_done(self, widget, data=None):
        self.menu.destroy()

    def _on_delete_button(self, widget, data=None):
        selected = self.treeview.get_selection()
        (self.model, index) = selected.get_selected()
        if index:
            position = int(selected.get_selected_rows()[1][0][0])
            self.admin.delete_bookmark(str(self.model[position][2]))
            self._update_list()

    def _on_edit_button(self, widget, data=None):
        selected = self.treeview.get_selection()
        (self.model, index) = selected.get_selected()
        if index:
            position = int(selected.get_selected_rows()[1][0][0])
            values = self.model[position][1].split("\n")
            self._show_dialog(str(self.model[position][2]), values[0], values[1])

    def _on_add_button(self, widget, data=None):
        self._show_dialog(None,None,None)

    def _on_visit_button(self, widget, data=None):
        selected = self.treeview.get_selection()
        (self.model, index) = selected.get_selected()
        if index:
            position = int(selected.get_selected_rows()[1][0][0])
            values = self.model[position][1].split("\n")
            (pid,stdin,stdout,stderr) = gobject.spawn_async(["/usr/bin/tear", values[1]])

    def _show_dialog(self, position=None, title=None, url=None):
        self.dialog = gtk.Dialog()

        title_label = gtk.Label("Title:")
        self.title_input = gtk.Entry()
        if position != None:
            self.title_input.set_text(title)
        self.dialog.vbox.pack_start(title_label)
        self.dialog.vbox.pack_start(self.title_input)

        url_label = gtk.Label("URL:")
        self.url_input = gtk.Entry()
        if position != None:
            self.url_input.set_text(url)
        else:
            self.url_input.set_text("http://")
        self.dialog.vbox.pack_start(url_label)
        self.dialog.vbox.pack_start(self.url_input)

        save_button = gtk.Button("Save")
        save_button.connect("clicked", self._on_save_button, position)
        save_image = gtk.Image()
        save_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("save.png", 26, 26))
        save_button.set_image(save_image)
        save_image.show()

        cancel_button = gtk.Button("Cancel")
        cancel_button.connect("clicked", self._destroy_dialog)
        cancel_image = gtk.Image()
        cancel_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("exit.png", 26, 26))
        cancel_button.set_image(cancel_image)
        cancel_image.show()

        button_box = gtk.HBox(True,0)
        button_box.pack_start(save_button)
        button_box.pack_start(cancel_button)

        self.dialog.vbox.pack_start(button_box)
        self.dialog.show_all()

    def _on_save_button(self, widget, position=None):
        if (len(self.title_input.get_text()) != 0) and (len(self.url_input.get_text()) != 0):
            if position != None:
                self.admin.edit_bookmark(position, self.title_input.get_text(), self.url_input.get_text())
            else:
                self.admin.add_bookmark(self.title_input.get_text(), self.url_input.get_text())
            self.dialog.destroy()
            self._update_list()

    def _destroy_dialog(self, widget, data=None):
        self.dialog.destroy()

    def _on_key_press(self, widget, event, *args):
        if event.keyval == gtk.keysyms.F6:
            if self.window_in_fullscreen:
                self.window.unfullscreen()
            else:
                self.window.fullscreen()
        if event.keyval == gtk.keysyms.F4:
            pass
        if event.keyval == gtk.keysyms.F8:
            pass #plus
        if event.keyval == gtk.keysyms.F7:
            pass #minus
        if event.keyval == gtk.keysyms.Escape:
            pass #escape

    def _on_window_state_change(self, widget, event, *args):
        if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
        else:
            self.window_in_fullscreen = False

    def _destroy(self, widget, data=None):
        gtk.main_quit()

class TearBookmarksAdmin:

    def __init__(self):
        self.connection = sqlite3.connect("/home/user/.tear/tear.db")
        self.db = self.connection.cursor()
        self._read_database()

    def get_bookmark_list(self):
        self._read_database()
        return self.bookmark_list

    def add_bookmark(self, title, url):
        values = (title,url)
        self.db.execute('insert into quickdata(name, addr, path, type, access_date) values(?,?,"/","bookmark",datetime("now"))', values)
        self.connection.commit()

    def delete_bookmark(self, position):
        self.db.execute('delete from quickdata where type="bookmark" and idx=?', (position,))
        self.connection.commit()

    def edit_bookmark(self, position, title, url):
        values = (title,url,position)
        self.db.execute('update quickdata set name=?, addr=?, access_date=datetime("now") where idx=?', values)
        self.connection.commit()

    def _read_database(self):
        self.bookmark_list = []
        self.db.execute('select * from quickdata where type="bookmark" and path="/"')
        for bookmark in self.db:
            self.bookmark_list.append([gtk.gdk.pixbuf_new_from_file_at_size("url.png",32, 32),bookmark[1]+'\n'+bookmark[2],str(bookmark[0])])

if __name__ == "__main__":
    tb = TearBookmarks()
    gtk.main()
