import gtk
import hildondesktop
import sqlite3
import gobject
import osso
import dbus
import os

class statusbar_applet(hildondesktop.TaskNavigatorItem):
    def __init__(self):
       hildondesktop.TaskNavigatorItem.__init__(self)
       
       #Set up icon
       self.icon_theme = gtk.icon_theme_get_default()

       #osso
       self.ossoc = osso.Context("tearbookmarks","0.2.5",False)

       #dbus, perhaps?
       self.session_bus = dbus.SessionBus()
       
       self.button = hildondesktop.ToggleButton()
       self.button.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("tear",64,0)))
       self.button.set_name("hildon-navigator-button-tear")
       self.button.set_size_request(64,64)
       self.button.connect("toggled",self.popup_menu)
       self.create_menu()

       self.add(self.button)
       self.show_all()

    def shorten_text(self, variable_holding_text):
        new_variable = variable_holding_text
        if len(variable_holding_text) > 35:
            new_variable = variable_holding_text[0:35] + "..."
        return new_variable
    
    def create_menu(self):
       self.conn = sqlite3.connect("/home/user/.tear/tear.db")
       self.c = self.conn.cursor()
       
       self.menu = gtk.Menu()
       menu_item = gtk.ImageMenuItem("Open New Window")
       menu_item.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("tear",64,0)))
       menu_item.connect('activate',self.open_tear)
       self.menu.append(menu_item)

       menu_item = gtk.SeparatorMenuItem()
       self.menu.append(menu_item)
	
       self.c.execute('select * from quickdata where type="bookmark" and path="/"')
       for row in self.c:
             #And now, to make this way more complicated than it should be.  I suppose I can create another function to build this...
             #      do that later... it only makes the code more readable
             menuitem = hildondesktop.hildon_thumb_menu_item_new_with_labels(self.shorten_text(str(row[1])),self.shorten_text(str(row[1])),self.shorten_text(str(row[2])))
             menuitem.set_image(gtk.image_new_from_pixbuf(self.icon_theme.load_icon("qgn_list_gene_bookmark",64,0)))
             #menuitem.set_size_request(-1,-1) -- Might need this, so keep it in mind!
             self.menu.append(menuitem)
             menuitem.connect('activate',self.open_url,row[2])

       #menu_item = gtk.SeparatorMenuItem()
       #self.menu.append(menu_item)

       self.menu.set_name("menu_from_navigator")
       self.menu.connect('hide',self.menu_off)
       hildondesktop.hildon_menu_set_thumb_mode(self.menu,True)
       self.menu.show_all()

       self.c.close()
       self.conn.close()

    def html_escape(self,text):
       text = text.replace('&', '&amp;')
       text = text.replace('"', '&quot;')
       text = text.replace("'", '&#39;')
       text = text.replace(">", '&gt;')
       text = text.replace("<", '&lt;')
       return text

    def menu_off(self,widget):
        self.button.set_active(False)
        self.menu.popdown()
        
    def popup_menu(self,widget,data=None):
        self.create_menu()
        if(self.button.get_active() == True):
             self.menu.popup(None,None,self.menu_position,0,gtk.get_current_event_time())

    def open_tear(self,widget):
        #mdlg = gtk.MessageDialog(None,0,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,"Opening tear")
        #mdlg.run()
        #mdlg.destroy()
        (pid,stdin,stdout,stderr) = gobject.spawn_async(["/usr/bin/tear"])
        #tearservice = self.session_bus.get_object("com.nokia.tear","/com/nokia/tear")
        #test = tearservice.get_dbus_method('new_window','com.nokia.tear')

    def open_url(self,widget,data):
        (pid,stdin,stdout,stderr) = gobject.spawn_async(["/usr/bin/tear", str(data)])
        #mdlg = gtk.MessageDialog(None,0,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,"Opening %s" % data)
        #mdlg.run()
        #mdlg.destroy()
        
    def menu_position(self,data=None):
        x = self.button.allocation.x + self.button.allocation.width
        y = self.button.allocation.y
        return (x,y,True)
        
        
def hd_plugin_get_objects():
     plugin = statusbar_applet()
     return [plugin]
#plugin.open_url(None, "http://digg.com")
#plugin = statusbar_applet()
#plugin.destroy()
