#!/usr/bin/env python
#All imports we need
import sys, os
import pango
import pygtk
pygtk.require('2.0')
import gtk
from gtk import gdk
import gobject
import hildondesktop
import cairo
from datetime import datetime
import time
import rsvg
import math

    
# set this to False to disable display of seconds and update 
# only once per minute (saves CPU cycles on the tablet)
enable_seconds = True

supports_alpha = False
#svgclock_themes_dir = "/home/user/MyDocs/Themes/default"
svgclock_themes_dir = "/usr/lib/svgclock/themes/default"

class SVGClock(hildondesktop.HomeItem):
#class PyClock(gtk.DrawingArea):
    def __init__(self):
        hildondesktop.HomeItem.__init__(self)
#        super(PyClock, self).__init__()

        self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)
        self.set_size_request(200, 200)

        # Initialize background buffer
        self.buffer = cairo.ImageSurface(cairo.FORMAT_ARGB32, 200, 200)

        # Paint background
        cr = cairo.Context(self.buffer)
        cr.set_operator(cairo.OPERATOR_OVER)

        SVGH_Drop_Shadow = self.load_svg("clock-drop-shadow.svg")
        SVGH_Face = self.load_svg("clock-face.svg")
        SVGH_Face_Shadow = self.load_svg("clock-face-shadow.svg")
        SVGH_Marks = self.load_svg("clock-marks.svg")
        SVGH_Frame = self.load_svg("clock-frame.svg")
        SVGH_Glass = self.load_svg("clock-glass.svg")

        #svg_width, svg_height = map(float, SVGH_Face.get_dimension_data()[:2])
        #cr.scale(height / svg_width, height / svg_height)
        cr.scale(2.0,2.0)

        cr.save()

        # Draw Background
        SVGH_Drop_Shadow.render_cairo(cr)
        SVGH_Face.render_cairo(cr)
        SVGH_Marks.render_cairo(cr)
        
        #Draw the clock glass face with shadow
        SVGH_Face_Shadow.render_cairo(cr)
        SVGH_Glass.render_cairo(cr)
        SVGH_Frame.render_cairo(cr)

        self.connect("expose-event", self.expose)
        self.connect("screen-changed", self.screen_changed)
        self.show_all()

        # set a timeout to update the clock, depending
        # on whether we are in the foreground or background
        self.timer = None
        self.set_timer(self, True)
#        gobject.timeout_add(1000, self.update)

        self.connect ("background", self.set_timer, False)
        self.connect ("foreground", self.set_timer, True)
        self.connect ("unrealize", self.unrealize)
      

    def expose(self, widget, event):

        global supports_alpha

        cr = widget.window.cairo_create()
#        cr = event.window.cairo_create()

        if supports_alpha == True:
            cr.set_source_rgba(0.0, 0.0, 0.0, 0.0) # Transparent
        else:
            cr.set_source_rgb(1.0, 1.0, 1.0) # Opaque white

        cr.set_source_surface( self.buffer, 0, 0 )
        cr.set_operator(cairo.OPERATOR_SOURCE)
        cr.paint()
        # set a clip region for the expose event
        cr.rectangle(event.area.x, event.area.y, event.area.width, event.area.height)
        cr.clip()

        self.DrawClockHands( cr )

        return True

    def DrawClockHands(self, cr):

        SVGH_Hour_Hand = self.load_svg("clock-hour-hand.svg")
        SVGH_Minute_Hand = self.load_svg("clock-minute-hand.svg")
        SVGH_Second_Hand = self.load_svg("clock-second-hand.svg")    

        #Draw the hours/minutes and seconds hands        
        time = datetime.now()
        hour = time.hour
        minutes = time.minute
        seconds = time.second

        cr.scale(2.0,2.0)
        cr.translate( 50, 50 )
        cr.save()

#        cr.set_operator(cairo.OPERATOR_OVER)
        #cr.rotate((360/12) * (hour+9) * (3.141593/180))
        cr.rotate(((360/12) * (hour+9) * (3.141593/180)) + (((360/60) * minutes * (3.141593/180)) / 12))
        SVGH_Hour_Hand.render_cairo(cr)
        cr.restore()
        cr.save()

        cr.rotate((360/60) * (minutes+45) * (3.141593/180))
        SVGH_Minute_Hand.render_cairo(cr)
        cr.restore()
        cr.save()

        # only draw seconds when in foreground
        if enable_seconds: # disable seconds, to much work for little tablets
           cr.rotate((360/60) * (seconds+45) * (3.141593/180))
           SVGH_Second_Hand.render_cairo(cr)
           cr.restore()
          
        return True
           

    def load_svg(self, filed):

        get_svg = lambda name: rsvg.Handle(os.path.join(svgclock_themes_dir, name))
#        get_svg = lambda name: rsvg.Handle(os.path.join("/home/user/MyDocs/Themes/default", name))
        loadval = get_svg(filed)
        return loadval
        

    def screen_changed(self, widget, old_screen=None):
        global supports_alpha
        # print "screen changed"

        # To check if the display supports alpha channels, get the colormap
        screen = self.get_screen()
        colormap = screen.get_rgba_colormap()
        if colormap == None:
            # print 'Your screen does not support alpha channels!'
            colormap = screen.get_rgb_colormap()
            supports_alpha = False
        else:
            # print 'Your screen supports alpha channels!'
            supports_alpha = True

        # Now we have a colormap appropriate for the screen, use it
        self.set_colormap(colormap)

        return True


    def unrealize(self, widget, date=None):
        # cancel timeout
        if self.timer:
            v = gobject.source_remove(self.timer)
            print "canceled svgclock timeout:", v
            self.timer = None

    def set_timer(self, widget, on):
#       when called first time from __init__ widget is None
        if self.timer != None:
#           print "removing old timer"
            gobject.source_remove(self.timer)
        if on:
#           print "creating new timer"
            delay = 1000 if enable_seconds else 60000
            self.timer = gobject.timeout_add(delay, self.update)
#           repaint immediately when coming to the foreground
            self.update()

    def update(self):
        # print "updating svgclock"
        self.queue_draw()
        # alloc = self.get_allocation()
        # self.queue_draw_area(alloc.x, alloc.y, alloc.width, alloc.height)
        return True

def hd_plugin_get_objects():
    plugin = SVGClock()
    return [plugin]

if __name__ == "__main__":
  print SVGClock()