create table account (
  id integer primary key,
  name string,
  parties integer
);

create table currency (
  id integer primary key,
  name string,
  exchange_rate float
);


create table payment (
  id integer primary key,
  timestamp datetime,
  description string,
  amount float,
  currency_id integer,
  account_id integer
);

create table split (
  payment_id integer,
  account_id integer,
  split integer
);

insert into currency (name, exchange_rate) values ('US$', 1.0);
insert into currency (name, exchange_rate) values ('EUR', 1.47);
insert into currency (name, exchange_rate) values ('Rubel', 0,45);

insert into account (name, parties) values('John', 1);
insert into account (name, parties) values('Mary', 1);
insert into account (name, parties) values('The Smiths', 3);

insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-21-09:21', 'Breakfast', 23.7, 1, 1);
insert into split (payment_id, account_id, split) values (1,1,1);
insert into split (payment_id, account_id, split) values (1,2,1);
insert into split (payment_id, account_id, split) values (1,3,3);

insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-21-14:21', 'Cash', 100, 1, 1);
insert into split (payment_id, account_id, split) values (2,2,1);

insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:01', 'Dummy', 123.45, 1, 1);
insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:02', 'Dummy', 123.45, 2, 2);
insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:03', 'Dummy', 123.45, 3, 3);
insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:04', 'Dummy', 123.45, 3, 1);
insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:04', 'Dummy', 123.45, 1, 1);
insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:04', 'Dummy', 123.45, 1, 1);
insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:04', 'Dummy', 123.45, 1, 1);
insert into payment (timestamp, description, amount, currency_id, account_id) values ('2009-09-23-12:04', 'Dummy', 123.45, 1, 1);

.dump
