#import pygtk
#pygtk.require('2.0')

import gtk
import sqlite3

class CurrencyModel:

    def __init__(self):
        self.sql=None
        self.store = gtk.ListStore(int,str,float)

    def initFromDb(self, sql):
	self.store.clear()
        self.sql=sql
	for row in self.sql.execute('select id,name,exchange_rate from currency'):
	    self.store.append([row[0], row[1], row[2]])

    def getNameById(self,id):
        for row in self.store:
            if row[0]==id:
                return row[1]
        return 'None'


    def setSelection(self, iter):
        self.selectedIter=iter


    def isValidChange(self, name, rate):
	c=self.sql.cursor()
        # get database ID
        id=self.store[self.selectedIter][0]
        c.execute('SELECT * FROM currency WHERE name=? AND id<>?', (name,id))
        result=True
        msg=[]
        if c.fetchone()!=None:
            result=False
            msg.append('You must not specify the name of an existing currency')
        try:
            dummy=float(rate)
        except ValueError:
            result=False
            msg.append('The specified exchange rate is not a valid number')
        if not result:
            d=gtk.MessageDialog(None, gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, "\n\n".join(msg))
            d.set_title('Error')
            d.connect('response', lambda dialog, response: dialog.destroy())
            d.show()
            result=False
        return result
        

    def commitChange(self, name, rate):
        iter=self.selectedIter
	id=self.store[iter][0]
	c=self.sql.cursor()
        c.execute('UPDATE currency SET name=?, exchange_rate=? WHERE id=?', (name, rate, id))
        self.sql.commit()
        # update the model
        self.store[iter][1]=name
        self.store[iter][2]=float(rate)
        
    def newUniqueName(self):
        c=self.sql.cursor()
        i=1
        while True:
            name='NoName'+str(i)
            c.execute('SELECT id FROM currency where name=?', (name,))
            if c.fetchone()==None:
                break
            i+=1
        return name

    def addNew(self):
        name=self.newUniqueName()
        rate=1.0
	c=self.sql.cursor()
        c.execute('INSERT INTO currency (name, exchange_rate) values(?,?)', (name, rate))
        id=c.lastrowid
        self.store.append([id,name,rate])
        self.sql.commit()

    def canDelete(self):
        result=True
        c=self.sql.cursor()
        # get database ID
        id=self.store[self.selectedIter][0]
        c.execute('SELECT COUNT(*) FROM payment WHERE currency_id=?', (id,))
        count=c.fetchone()[0]
        if count>0:
            msg='This currency is still used by '+str(count)+' transaction(s)'
            d=gtk.MessageDialog(None, gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, msg)
            d.set_title('Error')
            d.connect('response', lambda dialog, response: dialog.destroy())
            d.show()
            result=False
        return result

    def doDelete(self):
        c=self.sql.cursor()
        # get database ID
        id=self.store[self.selectedIter][0]
        c.execute('DELETE FROM currency WHERE id=?', (id,))
        self.store.remove(self.selectedIter)
        self.selectedIter=None
        self.sql.commit()
