import pygtk
pygtk.require('2.0')
import gtk

class CurrencyEditor:


    def canProceed(self):
        result=True
        if self.changed:
            d=gtk.MessageDialog(self.parent,
                                gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,
                                gtk.MESSAGE_WARNING, gtk.BUTTONS_OK_CANCEL,
                                'Changes were entered but not committed. Is it OK to discard these changes?')
            d.set_title('Warning')
            result=d.run()
            d.destroy()
            if result!=gtk.RESPONSE_OK:
                result=False
        return result


    def selectCb(self, widget):

        selection=self.treeview.get_selection()
        if self.canProceed():
            (model,iter)=selection.get_selected()

            if (iter):
                self.currencyModel.setSelection(iter)
                self.nameEntry.set_text(model[iter][1])
                self.rateEntry.set_text(str(model[iter][2]))
            else:
                self.nameEntry.set_text('')
                self.rateEntry.set_text('')
            self.changed=False
        else:
            # undo the GUI selection change
            selection.select_iter(self.currencyModel.selectedIter)
	return False


    def commitCb(self, widget):
	name=self.nameEntry.get_text()
	rate=self.rateEntry.get_text()
        if self.currencyModel.isValidChange(name,rate):
            self.currencyModel.commitChange(name,rate)
            self.changed=False

    def addCb(self, widget):
        self.currencyModel.addNew()

    def deleteCb(self, widget):
	selection=self.treeview.get_selection()
	(model,iter)=selection.get_selected()
        if self.currencyModel.canDelete():
            self.currencyModel.doDelete()

    def changedCb(self, widget):
        self.changed=True

    def __init__(self, toplevel, currencyModel):
        self.currencyModel=currencyModel
        self.parent=toplevel

        self.dialog=gtk.Dialog(title='Edit Currencies',
                               parent=toplevel,
                               flags=gtk.DIALOG_DESTROY_WITH_PARENT,
                               buttons=(gtk.STOCK_CLOSE, gtk.RESPONSE_ACCEPT))
        #flags=gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,

        vbox=self.dialog.vbox

	hbox=gtk.HBox()
        vbox.pack_start(hbox)
        frame=gtk.Frame()
	hbox.pack_start(frame, expand=True, fill=True)

        vbox=gtk.VBox()
        #hbox.pack_start(vbox, True)
        frame.add(vbox)

	scroll=gtk.ScrolledWindow();
        self.treeview = gtk.TreeView(self.currencyModel.store)
	self.treeview.set_rules_hint(True)
	self.treeview.set_headers_visible(False)
	#treeview.set_property('enable_grid_lines',True)
	#treeview.set_property('fixed_height_mode',True)
	self.treeview.connect("cursor-changed", self.selectCb)

        # create the TreeViewColumn to display the data
        col = gtk.TreeViewColumn('Currency')

        # add tvcolumn to treeview
        self.treeview.append_column(col)

        # create a CellRendererText to render the data
        cell = gtk.CellRendererText()

        # add the cell to the tvcolumn and allow it to expand
        col.pack_start(cell, True)

        # set the cell "text" attribute to column 0 - retrieve text
        # from that column in treestore
        col.add_attribute(cell, 'text', 1)

        # make it searchable
        #treeview.set_search_column(0)

        # Allow sorting on the column
        #self.tvcolumn.set_sort_column_id(0)

        # Allow drag and drop reordering of rows
        #treeview.set_reorderable(True)

        scroll.add(self.treeview)
        #self.window.add(self.scroll)
        vbox.pack_start(scroll)

        hbox2=gtk.HBox()
        vbox.pack_start(hbox2, expand=False, fill=False)
        b=gtk.Button('Add', gtk.STOCK_ADD)
        hbox2.pack_start(b, expand=True, fill=True)
        b.connect("clicked", self.addCb)
        b=gtk.Button('Delete', gtk.STOCK_DELETE)
        hbox2.pack_start(b, expand=True, fill=True)
        b.connect("clicked", self.deleteCb)

        frame=gtk.Frame()
	#hbox.pack_end(frame, expand=False, fill=False)
	hbox.pack_start(frame, expand=True, fill=True)
	vbox=gtk.VBox()
        frame.add(vbox)
	grid=gtk.Table(rows=2, columns=2)
	grid.attach(gtk.Label('Name:'), 0, 1, 0, 1, 0, gtk.FILL)
	self.nameEntry=gtk.Entry()
	grid.attach(self.nameEntry, 1, 2, 0, 1, 0, gtk.FILL)
	grid.attach(gtk.Label('Exchange Rate:'), 0, 1, 1, 2, 0, gtk.FILL)
	self.rateEntry=gtk.Entry()
	grid.attach(self.rateEntry, 1, 2, 1, 2, 0, gtk.FILL)
	vbox.pack_start(grid, expand=False)

        self.nameEntry.connect("changed", self.changedCb)
        self.rateEntry.connect("changed", self.changedCb)
        self.changed=False

	b=gtk.Button('Commit', gtk.STOCK_APPLY)
	vbox.pack_start(b, expand=False, fill=False)
	b.connect("clicked", self.commitCb)

        self.dialog.show_all()

        while True:
            self.dialog.run()
            if self.canProceed():
                break
        self.dialog.destroy()
