#
# This is the user preferences module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

import os
import pickle

class Preferences:

    def filename(self):
        result=os.path.expanduser('~/.SplitTheTab_preferences')
        return result

    def __init__(self):
        fn=self.filename()
        if os.path.isfile(fn):
            fp=open(fn)
            self.param=pickle.load(fp)
            fp.close()
            self.tainted=False;
        else:
            self.param={}
            # force preferences to be saved
            self.tainted=True;
        if not 'lastDbFn' in self.param or not os.path.isfile(self.param['lastDbFn']):
            self.param['lastDbFn']=None
        #self.param['lastDbFn']=os.path.expanduser('splitthetab.db')

    def save(self):
        print "Saving preferences"
        fp=open(self.filename(), 'w')
        pickle.dump(self.param, fp)
        fp.close()
        self.tainted=False

    def set(self, par, val):
        self.tainted=True
        self.param[par]=val

    def get(self, par):
        return self.param[par]

    def have(self, par):
        return par in self.param and self.param[par]!=None


    def setDbFn(self,value):
        if not 'lastDbFn' in self.param or self.param['lastDbFn']!=value:
            self.tainted=True
        self.param['lastDbFn']=value

    def getDbFn(self):
        if 'lastDbFn' in self.param:
            return self.param['lastDbFn']
        return None
    

    def saveIfNeeded(self):
        if self.tainted:
            self.save()
