#
# This is the payment editor module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

import pygtk
pygtk.require('2.0')
import gtk
import sqlite3
import datetime
import re

from Calculator import Calculator
import PropertyEditor

try:
    import hildon
    isHildon=True
except ImportError:
    isHildon=False

# def timestamp():
#     t=time.strftime('%Y-%m-%d_%H:%M')
#     return t

def makeEntry(grid, row,title):
    l=gtk.Label(title+':')
    l.set_alignment(0,0)
    grid.attach(l, 0, 1, row, row+1, gtk.FILL, gtk.FILL)
    e=gtk.Entry()
    grid.attach(e, 1, 2, row, row+1, gtk.FILL, gtk.FILL)
    return e


def makeComboBoxEntry(grid, row,title):
    l=gtk.Label(title+':')
    l.set_alignment(0,0)
    grid.attach(l, 0, 1, row, row+1, gtk.FILL, gtk.FILL)
    e=gtk.combo_box_new_text()
    grid.attach(e, 1, 2, row, row+1, gtk.FILL, gtk.FILL)
    return e



class PaymentEditor:

    def editAmountCb(self, widget,dummy):
        # YUCK:
        sql=self.mainWindow.main.sql
        props=PropertyEditor.getProperties(sql)
        calc=Calculator(self.parent, 'Edit Amount',
                        float(self.amount.get_text()),
                        props['tip1'], props['tip2']
                        )
        result=calc.run()
        if result==gtk.RESPONSE_ACCEPT:
            amount=calc.get_amount()
            self.amount.set_text('%.2f' % amount)
        calc.destroy()


    def keypadCb(self, widget, char):
        w=self.amount
        if char=='CLR':
            w.set_text('')
        else:
            pos=w.get_position()
            w.insert_text(char, pos)
            w.set_position(pos+1)

    def deleteEventCb(self, widget, event):
        widget.destroy()
        self.dialog=None
        return False

    def responseCb(self, widget, response_id):
        #print "responseCb, ID=",response_id
        if response_id == gtk.RESPONSE_ACCEPT:

            # Collect per-account split values
            accounts={}
            for row in self.accountModel.store:
                account_id=row[0]
                b=self.accountSplit[account_id]
                value=b.get_value()
                accounts[account_id]=value

            dv=self.date.get_date()
            tv=self.time.get_time()
            timestamp="%04d-%02d-%02d %02d:%02d" % (dv[0],dv[1],dv[2],tv[0],tv[1])


            # update model and database
            try:
                self.paymentModel.updateOrAdd(self.isEdit,
                                              timestamp,
                                              self.description.get_text(),
                                              self.amount.get_text(),
                                              self.currency.get_active(),
                                              self.payer.get_active(),
                                              accounts)
            except ValueError, error:
                d=gtk.MessageDialog(None, gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, error.message)
                d.set_title('Error')
                d.connect('response', lambda dialog, response: dialog.destroy())
                d.show()
            else:
                # success - dismiss dialog
                self.dialog.hide()
                self.mainWindow.updateSelection()
        else:
            # Cancel - dismiss dialog
            self.dialog.hide()

    def updateFromCurrencyModel (self):
        # clear existing list
        self.currency.get_model().clear()
        for row in self.currencyModel.store:
            self.currency.append_text(row[1])


    def updateFromAccountModel (self):
        # Update the 'Payer' pulldown
        self.payer.get_model().clear()
        for row in self.accountModel.store:
            self.payer.append_text(row[1])
        # Update the table with payees - first clear it
        #for w in self.payer.get_children():
        for w in self.grid.get_children():
            # could use self.payer.remove(w) as well?!?
            #self.payer.remove(w)
            w.destroy()
        i=0
        n=len(self.accountModel.store)
        #print "updateFromAccountModel, n=",n
        if n<1:
            n=1
 	self.grid.resize(rows=n, columns=4)
        self.accountSplit={}
        for row in self.accountModel.store:
            account_id=row[0]
            name=row[1]
            l=gtk.Label(name)
            l.set_alignment(0,0.5)
            self.grid.attach(l, 0, 1, i, i+1, gtk.FILL, gtk.FILL)

            if isHildon:
                b=hildon.NumberEditor(0,99)
            else:
                b=gtk.SpinButton()
                b.set_range(0,99)
                b.set_increments(1,1)
                b.set_numeric(True)
            
            #b=gtk.SpinButton(value=row[2], lower=0, upper=99, step_incr=1)
            self.grid.attach(b, 1, 2, i, i+1, 0, gtk.FILL)

            b1=gtk.Button('x')
            self.grid.attach(b1, 2, 3, i, i+1, 0, 0)
            b1.connect('clicked', lambda self, spin: spin.set_value(0), b)

            # Don't use the "reset" button, it's too confusing
            if False:
                b1=gtk.Button('r')
                self.grid.attach(b1, 3, 4, i, i+1, 0, 0)
                b1.connect('clicked', lambda self, spin, value: spin.set_value(value), b, row[2])

            # remember the widget
            self.accountSplit[account_id]=b
            i+=1
        
        self.payer.show_all()
        # Let the split grid request it's proper size
        self.grid.show_all()
        tuple=self.grid.size_request()
        self.scroller.set_size_request(tuple[0], tuple[1])


    def __init__(self, mainWindow, currencyModel, accountModel, paymentModel):
        self.mainWindow=mainWindow
        self.parent=mainWindow.toplevel
        self.currencyModel=currencyModel
        self.accountModel=accountModel
        self.paymentModel=paymentModel
        self.createGui()

    def display(self):
        if not self.dialog:
            self.createGui()
        self.dialog.show_all()




    def createGui(self):

        #print "in createGui"

        self.dialog=gtk.Dialog(title='Edit Transaction', parent=self.parent, 
                          flags=gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                          buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
                                   gtk.STOCK_APPLY, gtk.RESPONSE_ACCEPT))
        self.dialog.connect("delete_event", self.deleteEventCb)
        self.dialog.connect("response", self.responseCb)
        
        #window=self.dialog.get_content_area()
        window=self.dialog.vbox

        hbox1=gtk.HBox()
        window.pack_start(hbox1, expand=True, fill=True)

        #vbox11=gtk.VBox()
        #hbox1.pack_start(vbox11, expand=False, fill=True)
        

        #a=gtk.Alignment(1,0,0,0)
        #vbox11.pack_start(a, fill=True)
	if isHildon:
            self.date=hildon.DateEditor()
	else:
	    self.date=gtk.Entry()
        hbox1.pack_start(self.date)

        #a=gtk.Alignment(1.0,0.0,0.0,0.0)
        #vbox11.pack_start(a) #, fill=True, expand=True)
	if isHildon:
            self.time=hildon.TimeEditor()
	else:
	    self.time=gtk.Entry()
        hbox1.pack_start(self.time)
        #a.add(self.time)

        #vbox12=gtk.VBox()
        #hbox1.pack_start(vbox12, fill=True, expand=True)
        #self.description=makeEntry(vbox12, 'Description')

        hbox2=gtk.HBox()
        window.pack_start(hbox2, fill=True, expand=True)
        hbox2.set_spacing(10)

        grid=gtk.Table(rows=4, columns=2, homogeneous=False)
        hbox2.pack_start(grid, expand=True, fill=True)

        self.description=makeEntry(grid, 0, 'Title')
        
        # amount
        self.amount=makeEntry(grid,1,'Amount')
        self.amount.connect('button-release-event', self.editAmountCb)

        # currency
        self.currency=makeComboBoxEntry(grid,2,'Currency')

        # payer
        self.payer=makeComboBoxEntry(grid,3,'Payer')

        # timestamp
        #self.timestamp=makeEntry(vbox,'Timestamp')
        # description
        #self.description=makeEntry(vbox,'Description')


        # center column
        self.scroller=gtk.ScrolledWindow()
        self.scroller.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
        hbox2.pack_start(self.scroller, expand=True, fill=True)
        self.grid=gtk.Table()
        #hbox2.pack_start(self.grid, expand=True, fill=True)
        self.scroller.add_with_viewport(self.grid)



    def initFromModel(self):
        self.display()
        self.updateFromCurrencyModel()
        self.updateFromAccountModel()
        self.dialog.show_all()
        self.isEdit=True

        # use fulldate index
        if False:
            self.timestamp.set_text(self.paymentModel.getField(8))
        else:
            str=self.paymentModel.getField(8)
            m=re.match(r"(\d{4})-(\d{2})-(\d{2})[-_ ](\d{2}):(\d{2})",str)
            if m:
                ts=datetime.datetime(
                    int(m.group(1)),
                    int(m.group(2)),
                    int(m.group(3)),
                    int(m.group(4)),
                    int(m.group(5)))
            else:
                print "Could not parse date in $str"
                ts=datetime.datetime.today()
            if isHildon:
                self.date.set_date(ts.year,ts.month,ts.day)
                self.time.set_time(ts.hour,ts.minute,ts.second)
                
        self.description.set_text(self.paymentModel.getField(2))
        self.amount.set_text(self.paymentModel.getField(3))

        currency_name=self.paymentModel.getField(4)
        val=0
        i=0
        for row in self.currencyModel.store:
            if row[1]==currency_name:
                val=i
                break
            i+=1
        self.currency.set_active(val)

        payer_id=self.paymentModel.getField(5)
        val=0
        i=0
        for row in self.accountModel.store:
            if row[0]==payer_id:
                val=i
                break
            i+=1
        self.payer.set_active(val)

        hash=self.paymentModel.getField(6)
        for row in self.accountModel.store:
            account_id=row[0]
            button=self.accountSplit[account_id]
            if account_id in hash:
                val=int(hash[account_id])
            else:
                val=0
            button.set_value(val)
        

    def initWithDefaults(self):
        self.display()
        self.updateFromCurrencyModel()
        self.updateFromAccountModel()
        self.isEdit=False
        if False:
            self.timestamp.set_text(timestamp())
        else:
            ts=datetime.datetime.today()
            self.date.set_date(ts.year,ts.month,ts.day)
            self.time.set_time(ts.hour,ts.minute,ts.second)

            
        self.description.set_text('')
        self.amount.set_text('0')
        self.currency.set_active(0)
        
        #self.split.set_value(accountModel.total)
        self.payer.set_active(0)

        for row in self.accountModel.store:
            account_id=row[0]
            button=self.accountSplit[account_id]
            button.set_value(row[2])


