#
# This is the main window module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

import pygtk
pygtk.require('2.0')
import gtk
import sqlite3
import pango

try:
    import hildon
    isHildon=True
except ImportError:
    isHildon=False

from PaymentEditor import PaymentEditor
from CurrencyEditor import CurrencyEditor
from AccountEditor import AccountEditor
from PropertyEditor import PropertyEditor
import Main


class MainWindow:

    def key_press_cb(self, widget, event, *args):
        # Fullscreen key
        if event.keyval==gtk.keysyms.F6:
            # "Full screen" hardware key
            if self.isFullScreen:
                self.toplevel.unfullscreen()
            else:
                self.toplevel.fullscreen()
                
    def window_state_cb(self, widget, event, *args):
        if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.isFullScreen=True
        else:
            self.isFullScreen=False

    def switchTo(self, widget):
        if self.currentPage:
            self.pageContainer.remove(self.currentPage)
        self.pageContainer.pack_end(widget,expand=True, fill=True)
        self.currentPage=widget

    def noSelection(self):
        self.deleteButton.set_sensitive(False)
        self.editButton.set_sensitive(False)

    def delete_event_cb(self, widget, event, data=None):
        gtk.main_quit()
        return False

    def edit_accounts_cb(self, data):
        dialog=AccountEditor(self.toplevel, self.accountModel)
        self.editor.updateFromAccountModel()

    def edit_currencies_cb(self, data):
        dialog=CurrencyEditor(self.toplevel, self.currencyModel)
        self.editor.updateFromCurrencyModel()

    def edit_properties_cb(self, data):
        dialog=PropertyEditor(self.toplevel, self.main.sql)


    def selectCb(self, widget):
	selection=self.treeview.get_selection()
	(model,iter)=selection.get_selected()
        self.paymentModel.setSelection(iter)

        active=(iter!=None)
        self.editButton.set_sensitive(active)
        self.deleteButton.set_sensitive(active)
	return False

    def doubleCb(self, treeview, iter, path, user_data):
        #print "In doubleCb"
        self.editor.initFromModel()
        #print self.editor.dialog
        #self.editor.dialog.show_all()

    def editCb(self, widget):
        if not self.paymentModel.getSelection():
            Main.errorPopup("You need to select a payment first")
        else:
            self.editor.initFromModel()
            #self.scrollToCurrent()

    def addCb(self, widget):
        if len(self.currencyModel.store)==0 or len(self.accountModel.store)==0:
            Main.errorPopup("Please specify at least one account and at least one currency first", self.toplevel)
        else:
            self.editor.initWithDefaults()
            #self.scrollToCurrent()

    #     def scrollToCurrent(self):
    #             tm=self.paymentModel.store
    #             self.treeview.scroll_to_cell(tm.get_path(tm.selectedIter))

    def updateSelection(self):
        """ Callback from PaymentEditor, make sure selection
            is up to date"""

        tm=self.paymentModel.store
        iter=self.paymentModel.getSelection()
        self.treeview.get_selection().select_iter(iter)
        self.treeview.scroll_to_cell(tm.get_path(iter))
        # ensure button status is updated
        self.selectCb(None)


    def deleteCb(self, widget):
        if not self.paymentModel.getSelection():
            Main.errorPopup("You need to select a payment first")
        else:
            self.paymentModel.deleteCurrent()
            self.noSelection()


    def window(self):
        return self.toplevel

    def setTitle(self, string):
        self.toplevel.set_title(string)


    def createMenubar(self, parent, main):
        main_menu=gtk.Menu()
	if isHildon:
            self.toplevel.set_menu(main_menu)
        else:
            menu_bar=gtk.MenuBar()
            parent.pack_start(menu_bar, fill=True, expand=False)
            menu_bar.show()
            file_item=gtk.MenuItem("File")
            file_item.show()

        # File Menu
        item=gtk.MenuItem("File")
        menu=gtk.Menu()
        item.set_submenu(menu)
        main_menu.append(item)

        item=gtk.MenuItem("New")
        item.connect_object("activate", main.new_cb, None)
        menu.append(item)

        item=gtk.MenuItem("Open")
        item.connect_object("activate", main.open_cb, None)
        menu.append(item)
        
        item=gtk.MenuItem("Compact Database")
        item.connect_object("activate", main.vacuum_cb, None)
        menu.append(item)

        item=gtk.MenuItem("Export to ODS")
        item.connect_object("activate", main.export_cb, None)
        menu.append(item)
        
        # Edit Menu
        item=gtk.MenuItem("Edit")
        menu=gtk.Menu()
        item.set_submenu(menu)
        main_menu.append(item)

        item=gtk.MenuItem("Accounts")
        item.connect_object("activate", self.edit_accounts_cb, None)
        menu.append(item)

        item=gtk.MenuItem("Currencies")
        item.connect_object("activate", self.edit_currencies_cb, None)
        menu.append(item)

        item=gtk.MenuItem("Properties")
        item.connect_object("activate", self.edit_properties_cb, None)
        menu.append(item)

        item=gtk.MenuItem("Purge deleted entries")
        item.connect_object("activate", main.purge_cb, None)
        menu.append(item)


        # Report Menu
        item=gtk.MenuItem("Report")
        menu=gtk.Menu()
        item.set_submenu(menu)
        main_menu.append(item)

        item=gtk.MenuItem("Summary")
        item.connect_object("activate", main.summary_cb, None)
        menu.append(item)

        item=gtk.MenuItem("Detailed")
        item.connect_object("activate", main.report_cb, None)
        menu.append(item)

        item=gtk.MenuItem("About")
        item.connect_object("activate", main.about_cb, None)
        main_menu.append(item)

        exit_item=gtk.MenuItem("Exit")
        exit_item.connect_object("activate", self.delete_event_cb,
                                 "file.exit", None)
        main_menu.append(exit_item)
        #exit_item.show()
        main_menu.show_all()
        
        if not isHildon:
            file_item.set_submenu(main_menu)
            menu_bar.append(file_item)



    def __init__(self, currencyModel, accountModel, paymentModel, main):
        self.currencyModel=currencyModel
        self.accountModel=accountModel
        self.paymentModel=paymentModel
        self.main=main

        gtk.rc_parse_string('''
        style "big-button" {
             GtkButton::inner-border={10,10,10,10}
        }
        widget "top.*.buttons.GtkButton" style "big-button"
        ''')



        if isHildon:
            self.toplevel=hildon.Window()
        else:
            self.toplevel = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.toplevel.set_title("SplitTheTab")
        gtk.set_application_name("SplitTheTab")
        self.toplevel.set_size_request(700, 400)
        self.toplevel.set_name('top')

        self.toplevel.connect("delete_event", self.delete_event_cb, None)

        # create the editor
        self.editor=PaymentEditor(self, currencyModel,
                                  accountModel, paymentModel)

        vbox0=gtk.VBox()
        self.toplevel.add(vbox0)
        vbox0.show()
        self.createMenubar(vbox0, main)
        self.pageContainer=vbox0

        
        vbox=gtk.VBox(spacing=10)
        vbox0.add(vbox)
        self.currentPage=None

        # The Toolbar
        hbox=gtk.HBox()
        vbox.pack_end(hbox, expand=False, fill=True)
        hbox.set_name('buttons')

        b=gtk.Button('Add')
        #b.set_property('inner-border', 10)
        hbox.pack_start(b, expand=False, fill=False, padding=4)
        b.connect("clicked", self.addCb)

        b=gtk.Button('Edit')
        hbox.pack_start(b, expand=False, fill=False, padding=4)
        b.connect("clicked", self.editCb)
        self.editButton=b

        b=gtk.Button('Delete')
        hbox.pack_start(b, expand=False, fill=False, padding=4)
        b.connect("clicked", self.deleteCb)
        self.deleteButton=b

        self.noSelection()

        #b=gtk.Button('Dismiss', gtk.STOCK_CLOSE)
        #hbox.pack_start(b, expand=False, fill=False)
        #b.connect("clicked", self.addCb)

        frame=gtk.Frame()
	vbox.pack_start(frame, expand=True, fill=True)

	scroll=gtk.ScrolledWindow();
        self.treeview = gtk.TreeView(self.paymentModel.store)
	self.treeview.set_rules_hint(True)
	#self.treeview.set_headers_visible(False)
	self.treeview.connect("cursor-changed", self.selectCb)
        self.treeview.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)

        self.treeview.connect("row-activated", self.doubleCb, self)


        # create the TreeViewColumn to display the data
        col = gtk.TreeViewColumn('Date')
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 1)

        col = gtk.TreeViewColumn('Description')
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 2)
        cell.set_property('wrap-width', 200)
        cell.set_property('wrap-mode', pango.WRAP_WORD_CHAR)


        col = gtk.TreeViewColumn('Amount')
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        cell.set_property('xalign', 1.0)
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 3)

        col = gtk.TreeViewColumn('Currency')
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 4)

        col = gtk.TreeViewColumn('Paid By')
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 7)
        cell.set_property('wrap-width', 100)
        cell.set_property('wrap-mode', pango.WRAP_WORD_CHAR)

        col = gtk.TreeViewColumn('Split')
        self.treeview.append_column(col)
        cell = gtk.CellRendererText()
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 9)

        # make it searchable
        #treeview.set_search_column(0)

        # Allow sorting on the column
        #self.tvcolumn.set_sort_column_id(0)

        # Allow drag and drop reordering of rows
        #treeview.set_reorderable(True)

        scroll.add(self.treeview)
        #self.window.add(self.scroll)
        #vbox.pack_start(scroll, expand=True, fill=True)
        frame.add(scroll)
        vbox.show_all()

        self.toplevel.connect("key-press-event", self.key_press_cb)
        self.toplevel.connect("window-state-event", self.window_state_cb)
        self.isFullScreen=False

