#
# This is the editor base class module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

import pygtk
pygtk.require('2.0')
import gtk

try:
    import hildon
    isHildon=True
except ImportError:
    isHildon=False


#
# Child classes must provide the following defs:
#   isModified()
#   initFromModel(iter)
#   initFromScratch()
#   commitCb()
#   addDetails()
# Variables:
#   model
# Must have an entry 'self.nameEntry'
#

class EditorBase(gtk.Dialog):


    def canProceed(self):
        result=True
        if self.isModified():
            d=gtk.MessageDialog(self.parent,
                                gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,
                                gtk.MESSAGE_WARNING, gtk.BUTTONS_OK_CANCEL,
                                'Changes were entered but not committed. Is it OK to discard these changes?')
            d.set_title('Warning')
            result=d.run()
            d.destroy()
            if result!=gtk.RESPONSE_OK:
                result=False
        return result


    def selectCb(self, widget):

        selection=self.treeview.get_selection()
        if self.canProceed():
            (model,iter)=selection.get_selected()

            if (iter):
                self.model.setSelection(iter)
                self.initFromModel(iter)
            else:
                self.initFromScratch()
            self.isModified(False)
            self.nameEntry.grab_focus()
            self.nameEntry.select_region(0,-1)
        else:
            # undo the GUI selection change
            selection.select_iter(self.model.selectedIter)
	return False

    def addCb(self, widget):
        iter=self.model.addNew()
        store=self.model.store
	selection=self.treeview.get_selection()
        selection.unselect_all()
        selection.select_iter(iter)
        self.treeview.scroll_to_cell(store.get_path(iter))
        ###self.nameEntry.grab_focus()
        # force GUI update
        self.selectCb(None)
        

    def deleteCb(self, widget):
	selection=self.treeview.get_selection()
	(model,iter)=selection.get_selected()
        if self.model.canDelete():
            self.model.doDelete()

    # Use this if the widgets have a changed signal
    # (HildonNumberEditor doesn't)
    #def changedCb(self, widget):
    #    self.changed=True

    def __init__(self, title, toplevel, model):
        #self.parent=toplevel
        self.model=model

	gtk.Dialog.__init__(self,
	                    title=title,
			   parent=toplevel,
			   flags=gtk.DIALOG_DESTROY_WITH_PARENT,
			   buttons=(gtk.STOCK_CLOSE, gtk.RESPONSE_ACCEPT))
        #self.set_size_request(600,350)

        self.set_default_size(-1, 250)

        # Top Hbox: contains name list on the left, details on the right
	hbox=gtk.HBox(spacing=6)
        self.vbox.pack_start(hbox)
        frame=gtk.Frame()
	hbox.pack_start(frame, expand=True, fill=True)

        # The vbox containing the name list
        vbox=gtk.VBox()
        #hbox.pack_start(vbox, True)
        frame.add(vbox)

        # the name list
	scroll=gtk.ScrolledWindow();
        self.treeview = gtk.TreeView(self.model.store)
	self.treeview.set_rules_hint(True)
	self.treeview.set_headers_visible(False)
	#treeview.set_property('enable_grid_lines',True)
	#treeview.set_property('fixed_height_mode',True)
	self.treeview.connect("cursor-changed", self.selectCb)

        # create the TreeViewColumn to display the data
        col = gtk.TreeViewColumn('Name')

        # add tvcolumn to treeview
        self.treeview.append_column(col)

        # create a CellRendererText to render the data
        cell = gtk.CellRendererText()

        # add the cell to the tvcolumn and allow it to expand
        col.pack_start(cell, True)

        # set the cell "text" attribute to column 0 - retrieve text
        # from that column in treestore
        col.add_attribute(cell, 'text', 1)

        # make it searchable
        #treeview.set_search_column(0)

        # Allow sorting on the column
        #self.tvcolumn.set_sort_column_id(0)

        # Allow drag and drop reordering of rows
        #treeview.set_reorderable(True)

        scroll.add(self.treeview)
        #self.window.add(self.scroll)
        vbox.pack_start(scroll)

        # Buttons
        hbox2=gtk.HBox()
        vbox.pack_start(hbox2, expand=False, fill=False)
        b=gtk.Button('Add', gtk.STOCK_ADD)
        hbox2.pack_start(b, expand=True, fill=True)
        b.connect("clicked", self.addCb)
        b=gtk.Button('Delete', gtk.STOCK_DELETE)
        hbox2.pack_start(b, expand=True, fill=True)
        b.connect("clicked", self.deleteCb)

	# Details
        frame=gtk.Frame()
	#hbox.pack_end(frame, expand=False, fill=False)
	hbox.pack_start(frame, expand=True, fill=True)
	vbox=gtk.VBox()
        frame.add(vbox)

        self.addDetails(vbox)

# 	# SPECIFIC
# 	grid=gtk.Table(rows=2, columns=2)
# 	grid.attach(gtk.Label('Name:'), 0, 1, 0, 1, 0, gtk.FILL)
# 	self.nameEntry=gtk.Entry()
# 	grid.attach(self.nameEntry, 1, 2, 0, 1, 0, gtk.FILL)
# 	grid.attach(gtk.Label('Exchange Rate:'), 0, 1, 1, 2, 0, gtk.FILL)
# 	self.rateEntry=gtk.Entry()
# 	grid.attach(self.rateEntry, 1, 2, 1, 2, 0, gtk.FILL)
# 	vbox.pack_start(grid, expand=False)

#         self.nameEntry.connect("changed", self.changedCb)
#         self.rateEntry.connect("changed", self.changedCb)

        #self.changed=False

	# UNSPECIFIC

	b=gtk.Button('Commit', gtk.STOCK_APPLY)
	vbox.pack_start(b, expand=False, fill=False)
	b.connect("clicked", self.commitCb)

        self.show_all()

        while True:
            self.run()
            if self.canProceed():
                break
        self.destroy()
