#
# This is the currency editor module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#


import pygtk
pygtk.require('2.0')
import gtk
from EditorBase import EditorBase

class CurrencyEditor(EditorBase):

    def isModified(self, setValue=None):
        if setValue==None:
            return self.changed
        else:
            self.changed=setValue
    
    def initFromModel(self, iter):
        self.model.setSelection(iter)
        self.nameEntry.set_text(self.model.store[iter][1])
        self.rateEntry.set_text(str(self.model.store[iter][2]))

    def initFromScratch(self, iter):
        self.nameEntry.set_text('')
        self.rateEntry.set_text('')

    def commitCb(self, widget):
	name=self.nameEntry.get_text()
	rate=self.rateEntry.get_text()
        if self.model.isValidChange(name,rate):
            self.model.commitChange(name,rate)
            self.isModified(False)

    def addDetails(self, parent):
	grid=gtk.Table(rows=2, columns=2)
	label=gtk.Label('Name:')
        label.set_alignment(0,0)
	grid.attach(label, 0, 1, 0, 1, gtk.FILL, gtk.FILL)
	self.nameEntry=gtk.Entry()
	grid.attach(self.nameEntry, 1, 2, 0, 1, gtk.FILL, gtk.FILL)
	grid.attach(gtk.Label('Exchange Rate:'), 0, 1, 1, 2, gtk.FILL, gtk.FILL)
	self.rateEntry=gtk.Entry()
	grid.attach(self.rateEntry, 1, 2, 1, 2, gtk.FILL, gtk.FILL)
	parent.pack_start(grid, expand=False)

        self.nameEntry.connect("changed", self.changedCb)
        self.rateEntry.connect("changed", self.changedCb)
        self.changed=False

    def changedCb(self, widget):
        self.isModified(True)
        

    def __init__(self, toplevel, currencyModel):
        EditorBase.__init__(self, 'Edit Currencies',
                            toplevel, currencyModel)
