#
# This is the pop-up calculator module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#


import pygtk
pygtk.require('2.0')
import gtk

# Constants for keypad types
T_CHR=1
T_OPT=2
T_EQU=3
T_BSP=4
T_CLR=5
T_F1=6
T_F2=7


def errorPopup(message, toplevel=None):
    dialog=gtk.MessageDialog(toplevel,
                             gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,
                             gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                             message)
    dialog.set_title('Error')
    dialog.connect('response', lambda dialog, response: dialog.destroy())
    dialog.run()


class Calculator(gtk.Dialog):

    def keypadCb(self, widget, char, type):
        w=self.amount
        if type==T_CHR:
            if self.fresh:
                w.set_text(char)
                w.set_position(1)
                self.fresh=False
            else:
                pos=w.get_position()
                w.insert_text(char, pos)
                w.set_position(pos+1)
        elif type==T_CLR:
            self.set_amount(0)
            self.fresh=True
        elif type==T_BSP:
            p=w.get_position()
            w.delete_text(p-1,p)
        elif type==T_OPT:
            self.evaluate()
            # store current value and operation
            try:
                amount=float(w.get_text())
            except ValueError:
                errorPopup('The value is not a valid number')
            else:
                self.operation=(amount, char)
                self.fresh=True
        elif type==T_EQU:
            self.evaluate()
            self.fresh=True
        elif type==T_F1:
            val=float(w.get_text())
            self.set_amount(val*(1.0+self.tip1/100.0))
            self.fresh=True
        elif type==T_F2:
            val=float(w.get_text())
            self.set_amount(val*(1.0+self.tip2/100.0))
            self.fresh=True
        else:
            print "Not implemented: ", char

    def evaluate(self):
        if (self.operation):
            arg1=self.operation[0]
            op=self.operation[1]

            # store current value and operation
            try:
                arg2=float(self.amount.get_text())
            except ValueError:
                errorPopup('The value is not a valid number')
            else:
                try:
                    if op=='+':
                        result=arg1+arg2
                    elif op=='-':
                        result=arg1-arg2
                    elif op=='*':
                        result=arg1*arg2
                    elif op=='/':
                        result=arg1/arg2
                except ZeroDivisionError:
                    errorPopup('Division by Zero')
                else:
                    self.set_amount(result)
                    self.operation=None
        else:
            # store current value and operation
            try:
                arg=self.get_amount()
            except ValueError:
                errorPopup('The value is not a valid number')
            else:
                self.set_amount(arg)

    def set_amount(self, value):
        str='%.2f' % value
        self.amount.set_text(str)

    def get_amount(self):
        # make sure result is rounded to two digits
        return float('%.2f' % float(self.amount.get_text()))

    def responseCb(self, widget, id):
        if (id==gtk.RESPONSE_ACCEPT):
            # make sure the value is valid
            try:
                self.get_amount()
            except ValueError:
                errorPopup('The value is not a valid number')
                # don't close the popup
                self.emit_stop_by_name('response')
                

    def __init__(self, toplevel, title, value, tip1, tip2):
        #self.parent=toplevel

	gtk.Dialog.__init__(self,
	                    title=title,
			   parent=toplevel,
			   flags=gtk.DIALOG_DESTROY_WITH_PARENT,
			   buttons=(gtk.STOCK_APPLY, gtk.RESPONSE_ACCEPT,
                                    gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))

        #vbox=gtk.VBox()
        #self.add(vbox)
        vbox=self.vbox
        self.amount=gtk.Entry()
        self.amount.set_alignment(1.0)
        vbox.pack_start(self.amount, fill=True, expand=False)
        #self.amount.set_text('0')
        self.set_amount(value)
        self.tip1=tip1
        self.tip2=tip2

        spec=(
            (('7', T_CHR), ('8', T_CHR), ('9', T_CHR), ('*', T_OPT), ('<=', T_BSP)),
            (('4', T_CHR), ('5', T_CHR), ('6', T_CHR), ('/', T_OPT), ('CLR', T_CLR)),
            (('1', T_CHR), ('2', T_CHR), ('3', T_CHR), ('+', T_OPT), (str(tip1)+'%', T_F1)),
            (('0', T_CHR), ('.', T_CHR), ('=', T_EQU), ('-', T_OPT), (str(tip2)+'%', T_F2)),
            )

        grid=gtk.Table(rows=len(spec), columns=len(spec[0]), homogeneous=True)
        
        n=5
        grid.set_row_spacings(n)
        grid.set_col_spacings(n)
        vbox.pack_start(grid, expand=True, fill=True)
        for row in range(len(spec)):
            for col in range(len(spec[0])):
                val=spec[row][col][0]
                type=spec[row][col][1]
                b=gtk.Button(val)
                grid.attach(b, col, col+1, row, row+1, gtk.EXPAND|gtk.FILL, gtk.EXPAND|gtk.FILL)
                b.connect('clicked', self.keypadCb, val, type)


	# UNSPECIFIC
        self.changed=False
        self.fresh=True
        # No pending operation
        self.operation=None

        self.connect('response', self.responseCb)

        self.show_all()



if __name__=='__main__':
    top=gtk.Window(gtk.WINDOW_TOPLEVEL)
    top.connect("delete_event", lambda widget, event: gtk.main_quit())
    top.show()
    calc=Calculator(top, 'Edit Amount', 3.4)
    result=calc.run()
    print "result=",result
    if result==gtk.RESPONSE_ACCEPT:
        print "    amount=",calc.get_amount()
