from const import *
from gtkeasyapp.gis import *

		
##Speedcam struct
class Speedcam():
	##Constructor
	def __init__(self, foxytag):
		#init members
		self.foxytag = foxytag
		self.wgs84 = WGS84Point(self.foxytag.lat, self.foxytag.long)
		self.utm = GISConvert.wgs84ToUtm(self.wgs84)
		self.distanceFromCar = 0
		self.carDirection = False
		
	
	##To string
	def __str__(self):
		return 'zone=%s' % (self.utm.zone)
		

	##Compute and return distance between car and speedcam
	def computeDistanceFromCar(self, utmCarPosition):
		#compute distance
		self.distanceFromCar = int(GISCompute.distanceUtm(utmCarPosition, self.utm))

		
	##Compute and return True if speedcam is in car direction
	def computeCarDirection(self, carAngle):
		#init
		minAngleThreshold = 0
		maxAngleThreshold = 0
	
		#check if speedcam have specified angle
		if self.foxytag.angle!=-1:
			flag = False
		
			#compute min angle threshold
			minAngleThreshold = carAngle - 45
			if minAngleThreshold<0:
				minAngleThreshold += 360
				flag = True
			
			#compute min angle threshold
			maxAngleThreshold = carAngle + 45
			if maxAngleThreshold>360:
				maxAngleThreshold -= 360
				flag = True
				
			#detect if speedcam is in front of the car or in the opposite direction
			if flag:
				if self.foxytag.angle>=minAngleThreshold or self.foxytag.angle<=maxAngleThreshold:
					#speedcam seems to be in car direction
					self.carDirection = True
				else:
					#speedcam seems not to be in car direction
					self.carDirection = False
			else:
				if self.foxytag.angle>=minAngleThreshold and self.foxytag.angle<=maxAngleThreshold:
					#speedcam seems to be in car direction
					self.carDirection = True
				else:
					#speedcam seems not to be in car direction
					self.carDirection = False
		else:
			#no speedcam angle specified
			self.carDirection = True
	
	
		
##CarPositionInfos struct		
class GpsInfos():
	##Constructor
	def __init__(self, gpsData=None):
		self.speed = NAN
		self.angle = NAN
		self.eph = NAN
		self.epd = NAN
		self.eps = NAN
		self.wgs84 = None
		self.utm = None
	
		if gpsData!=None:
			self.speed = int(gpsData.speed * 3.6) #m/s in km/h
			self.angle = int(gpsData.track)
			self.eph = gpsData.eph
			self.epd = gpsData.epd
			self.eps = gpsData.eps
			self.wgs84 = WGS84Point(gpsData.latitude, gpsData.longitude)
			self.utm = GISConvert.wgs84ToUtm(self.wgs84)
	
	
	##Copy content
	def copy(self, other):
		self.speed = other.speed
		self.angle = other.angle
		self.eph = other.eph
		self.epd = other.epd
		self.eps = other.eps
		self.wgs84 = WGS84Point(other.wgs84.latitude, other.wgs84.longitude)
		self.utm = UTMPoint(other.utm.x, other.utm.y, other.utm.zone, other.utm.northHemisphere)
		
		
	