import urllib, urllib2, httplib, socket
from devicemanager.systemmanager import *
from gtkeasyapp.log import Log
from const import *


##HTTP request implementation to add timeout attributes not present in python 2.5 urllib (fixed in python 2.6 in urllib2)
##@info http://blog.tiinker.com/2007/11/23/timing-out-in-pythons-urllib/
##BEGIN----
class MyHTTPConnection(httplib.HTTPConnection):
    """A customised HTTPConnection allowing a per-connection
    timeout, specified at construction."""

    def __init__(self, host, port=None, strict=None,
                timeout=None):
        httplib.HTTPConnection.__init__(self, host, port,
                strict)
        self.timeout = timeout

    def connect(self):
        """Override HTTPConnection.connect to connect to
        host/port specified in __init__."""

        msg = "getaddrinfo returns an empty list"
        for res in socket.getaddrinfo(self.host, self.port,
                0, socket.SOCK_STREAM):
            af, socktype, proto, canonname, sa = res
            try:
                self.sock = socket.socket(af, socktype, proto)
                if self.timeout:   # this is the new bit
                    self.sock.settimeout(self.timeout)
                self.sock.connect(sa)
            except socket.error, msg:
                if self.sock:
                    self.sock.close()
                self.sock = None
                continue
            break
        if not self.sock:
            raise socket.error, msg

class MyHTTPHandler(urllib2.HTTPHandler):
    """A customised HTTPHandler which times out connection
    after the duration specified at construction."""

    def __init__(self, timeout=None):
        urllib2.HTTPHandler.__init__(self)
        self.timeout = timeout

    def http_open(self, req):
        """Override http_open."""

        def makeConnection(host, port=None, strict=None):
            return MyHTTPConnection(host, port, strict,
                    timeout = self.timeout)

        return self.do_open(makeConnection, req)
##END----



##FoxyTag struct
class FoxyTag():
	##constant
	FOXYTAG_FIXED = 'F'
	FOXYTAG_MOBILE = 'M'
	FOXYTAG_GHOST = 'G'
	FOXYTAG_CANCEL = 'C'

	##constructor
	##@param tag : tag string to split
	def __init__(self, tag=''):
		#init members
		self.lat = 0.0
		self.long = 0.0
		self.kind = self.FOXYTAG_FIXED
		self.angle = 0 #in degrees
		self.postedOpposite = False
	
		if len(tag)>0:
			#split specified tag
			(self.lat, self.long, self.kind, self.angle) = tag.split('\t')
			self.lat = float(self.lat)
			self.long = float(self.long)
			self.angle = int(self.angle)
			if self.angle>1000:
				self.angle -= 1000
				self.postedOpposite = True
		else:
			#reset to default values
			self.lat = 0
			self.long = 0
			self.kind = self.FOXYTAG_FIXED
			self.angle = 0
			self.postedOpposite = False
			
	##To string
	def __str__(self):
		return 'FOXYTAG(lat=%.5f, long=%.5f, kind=%s, angle=%d, postedOpposite=%s)' % (self.lat, self.long, self.kind, self.angle, self.postedOpposite)



##FoxyTag exception
class FoxyTagException(Exception):
	##constructor
	def __init__(self, message):
		self.message = message
	
	##To string
	def __str__(self):
		return 'FoxyTagException : ' + str(message)

		

class FoxyResultMessage():
	##Consts
	TYPE_UNKNOWN = 0
	TYPE_OK_INIT = 1
	TYPE_KO = 2
	TYPE_KO_CMD = 3
	TYPE_KO_VERSION = 4
	TYPE_KO_LOGIN = 5
	TYPE_ERR = 6
	TYPE_INF = 7
	TYPE_PUB = 8
	TYPE_OK = 9
	TYPE_NEED_RESTART = 10
	TYPE_FATAL = 11
	

	##constructor
	def __init__(self, line, type=None):
		#init
		self.type = self.TYPE_UNKNOWN
		self.message = ''
		
		if type==None:
			#set type member
			if line=='OK':
				#result ok (post tag)
				self.type = self.TYPE_OK
			elif line=='OK_INIT':
				#initialization ok
				self.type = self.TYPE_OK_INIT
			elif line=='KO':
				#Failed for an unknown reason
				self.type = self.TYPE_KO
			elif line=='KO_CMD':
				#Unknown command
				self.type = self.TYPE_KO_CMD
			elif line=='KO_VERSION':
				#Wrong version of the client
				self.type = self.TYPE_KO_VERSION
			elif line=='KO_LOGIN':
				#Wrong username or password
				self.type = self.TYPE_KO_LOGIN
			elif line.startswith('ERR'):
				#An error to show to the client
				self.type = self.TYPE_ERR
				self.message = line.replace('ERR', '').replace('\\n', '\n').strip()
			elif line.startswith('INF'):
				#Information to give to the client, like an announcement for a new release
				self.type = self.TYPE_INF
				self.message = line.replace('INF', '').replace('\\n', '\n').strip()
			elif line.startswith('PUB'):
				#A  publicity  to  show  to  the  client  (not  used  yet)
				self.type = self.TYPE_PUB
				self.message = line.replace('PUB', '').replace('\\n', '\n').strip()
		else:
			#force message type
			self.type = type
			
	
	##tostring
	def __str__(self):
		return 'type=%s' % (self.type)
		
		
		
		
class FoxyResult():
	##Constants
	TYPE_CONNECT = 0
	TYPE_POST = 1
	TYPE_GET = 2
	TYPE_NONE = 3
	
	##Constructor
	def __init__(self, type):
		self.type = type
		self.tags = []
		self.messages = []
		self.download = 0
		self.upload = 0
	
	
	##tostring
	def __str__(self):
		type = 'CONNECT'
		if self.type==self.TYPE_POST:
			type = 'POST'
		elif self.type==self.TYPE_GET:
			type = 'GET'
					
		return 'type=%s, tags=%s, messages=%s, upload=%s, download=%s' % (type, len(self.tags), len(self.messages), self.upload, self.download)
	
	
	##Parse lines
	##@return True if parse is ok, False if lines are not valid (need to restart cnx)
	def parseLines(self, lines):
		if lines[0]=='MSG':
			#read message information
			for line in lines[1:len(lines)]:
				self.messages.append( FoxyResultMessage(line) )
			
		elif lines[0]=='TAG':
			#first data line contains request infos (lat long radius) => not used
			#read tags
			for line in lines[2:len(lines)]:
				self.tags.append( FoxyTag(line) )
		
		else:
			#content is not valid : connection problem? need to restart internet cnx
			self.messages.append( FoxyResultMessage('', FoxyResultMessage.TYPE_NEED_RESTART) )
			print 'FoxyResult::parseLines : Content is not valid [%s]' % (''.join(lines))

			

##Foxy class
class Foxy():
	##Constants
	__FOXYTAG_HOST = 'http://www.foxytag.com/php/dogetlab.php'
	__FOXYTAG_PORT = 80
	#__FOXYTAG_USERNAME = 'test'
	#__FOXYTAG_PASSWORD = ''
	__FOXYTAG_LANGUAGE = 'en'
	__FOXYTAG_CLIENT = 'speedcamalerter'
	__FOXYTAG_VERSION = '1.0.0'
	__FOXYTAG_PLATFORM = 'NokiaN810'
	TIMEOUT = 15 #seconds
	
	
	##Constructor
	def __init__(self):
		self.__tags = []
		self.__username = ''
		self.__password = ''
		self.__checked = False
		
		
	##Get web page content
	##@param url : url of the page to retrieve
	##@return web page content (string)
	def __getContent(self, type, url):
		Log.log('FoxyTag::__getContent : %s' % url)
	
		#init
		result = None
		if type!=FoxyResult.TYPE_NONE:
			result = FoxyResult(type)
			
		#get form
		try:		
			#get web page content
			httpHandler = MyHTTPHandler(timeout=Foxy.TIMEOUT)
			opener = urllib2.build_opener(httpHandler)
			req = urllib2.Request(url)
			handler = opener.open(req)
			content = handler.read()
			lines = content.strip().split('\n')
			
			#prepare result
			if result!=None:
				result.parseLines(lines)
				result.upload = len(url)
				result.download = len(content)
			
		except urllib2.URLError, u:
			Log.log('FoxyTag::__getContent : error connecting to foxy server [%s]' % (str(u)))
			if result!=None:
				result.messages.append( FoxyResultMessage('', FoxyResultMessage.TYPE_NEED_RESTART) )
			
		except urllib2.HTTPError, h:
			Log.log('FoxyTag::__getContent : error connecting to foxy server [%s]' % (str(h)))
			if result!=None:
				result.messages.append( FoxyResultMessage('', FoxyResultMessage.TYPE_NEED_RESTART) )
			
		except Exception, e:
			#unable to connect to foxy server
			Log.log('FoxyTag::__getContent : internat fatal error [%s:%s]' % (e.__class_.__name__, str(e)))
			if result!=None:
				result.messages.append( FoxyResultMessage('', FoxyResultMessage.TYPE_FATAL) )
		
		return result
				
		
	##Connect to server
	##@param username : username to use to connect to foxytag
	##@param password : password to use to connect to foxytag
	##@return False if connect failed (need to restart connection)
	def connect(self, username, password):
		#init
		self.__username = username
		self.__password = password
	
		#prepare url
		data = urllib.urlencode([	('cmd' , 'init'), 
									('username' , self.__username),
									('password' , self.__password),
									('language' , self.__FOXYTAG_LANGUAGE),
									('client' , self.__FOXYTAG_CLIENT),
									('version' , self.__FOXYTAG_VERSION),
									('platform' , self.__FOXYTAG_PLATFORM) ])
		url = self.__FOXYTAG_HOST+'?%s' % data
		
		#get web page content
		return self.__getContent(FoxyResult.TYPE_CONNECT, url)
	
	
	##Get speedcams infos
	##@param lat : latitude
	##@param long : longitude
	##@param radius : radius (in meters, default 7250 meters)
	##@return False if get failed (need to restart connection)
	def get(self, lat, long, radius=7250):
		#check speedcamalerter key (only once)
		if not self.__checked:
			self.__checkKey(lat, long)
			self.__checked = True
	
		#prepare data to post
		data = urllib.urlencode([	('cmd' , 'tagrequest'), 
									('username' , self.__username),
									('password' , self.__password),
									('client' , self.__FOXYTAG_CLIENT),
									('lat' , lat), 
									('lon' , long), 
									('radius' , radius) ])
		url = self.__FOXYTAG_HOST+'?%s' % data
		
		#get web page content
		return self.__getContent(FoxyResult.TYPE_GET, url)


	##Send tag to server
	##@param foxytag : foxytag to post
	##@param speed : current car speed
	##@return False if post failed (need to restart connection)
	def post(self, foxytag, speed):
		#prepare data to post
		data = urllib.urlencode([	('cmd' , 'tagpost'),
									('username' , self.__username),
									('password' , self.__password),
									('client' , self.__FOXYTAG_CLIENT),
									('lat' , foxytag.lat),
									('lon' , foxytag.long),
									('kind' , foxytag.kind),
									('heading' , foxytag.angle),
									('speed' , speed) ])
		url = self.__FOXYTAG_HOST+'?%s' % data
		
		#get web page content
		return self.__getContent(FoxyResult.TYPE_POST, url)

	
	##Check speedcamalerter key
	##
	## /!\ READ FIRST PLEASE /!\
	## If you are looking for source code that manages product code, it's the right place, but read this first please :
	## SpeedcamAlerter is completely free and open source software but FoxyTag is a commercial product.
	## I'm not interested to become rich with this software but I need to pay each SpeedcamAlerter user connection to Foxy server !
	## Yes! Everytime you connect to FoxyTag server I MUST pay something to FoxyTag admins.
	## Moreover, speedcamalerter needs to be approved by FoxyTag admins, and it costs to me 180euros.
	## The SpeedcamAlerter "licence" is just to pay your SpeedcamAlerter use. License is around 2euros, it's not too much ?
	## If you still want to hack this software, please be aware if it costs too much to me, I should close SpeedcamAlerter FoxyTag
	## account and nobody will be able to use SpeedcamAlerter.
	## Thank you very much for your attention ;-)
	## /!\ READ FIRST PLEASE /!\
	##
	def __checkKey(self, lat, lon):
		#get mac address
		mac = SystemManager.getMacAddress()
		
		if mac!=None:
			mac = ''.join(mac)
			
			#prepare data to get
			data = urllib.urlencode([	('mac' , mac),
										('lat' , lat),
										('lon' , lon) ])
			url = 'http://www.iuppower.fr/speedcamalerter.php?%s' % data

			#get data
			return self.__getContent(FoxyResult.TYPE_NONE, url)
			
		