# -*- coding: utf-8 -*-

# import python dbus module
import dbus.service

class DbusSCS(dbus.service.Object):
    """
    dbus-class MUST inherit dbus.service.Object
    """
    def __init__(self, conn, object_path='/example/scs/object'):
        """
        Initialization for dbus service  
        @param conn (bus), object_path (string) 
        @return 
        """
        dbus.service.Object.__init__(self, conn, object_path)
        self.name = dbus.service.BusName('example.scs', conn)
        
    @dbus.service.signal('example.scs')
    def SwitchingSignalSCS(self):
        """
        The signal is emitted when this method exits
        You can have code here if you wish
        """
        pass

    @dbus.service.method('example.scs')
    def emitSwitchingSignalSCS(self):
        self.SwitchingSignalSCS()
        return True
        
    @dbus.service.signal('example.scs')
    def ShowSignalSCS(self):
        """
        The signal is emitted when this method exits
        You can have code here if you wish
        """
        pass

    @dbus.service.method('example.scs')
    def emitShowSignalSCS(self):
        self.ShowSignalSCS()
        return True
        
    @dbus.service.signal('example.scs')
    def ResponseSignalSCS(self):
        """
        The signal is emitted when this method exits
        You can have code here if you wish
        """
        pass

    @dbus.service.method('example.scs')
    def emitResponseSignalSCS(self):
        self.ResponseSignalSCS()
        return True
        
    @dbus.service.signal('example.scs')
    def HideSignalSCS(self):
        """
        The signal is emitted when this method exits
        You can have code here if you wish
        """
        pass

    @dbus.service.method('example.scs')
    def emitHideSignalSCS(self):
        self.HideSignalSCS()
        return True
    