#!/usr/bin/python
import M2Crypto
import base64
import os
home = os.path.expanduser('~') + "/.sc"
from settings import security_mode



class RSA (object):
    def __init__ (self, bits=1024, padding=M2Crypto.RSA.pkcs1_padding, exp=65537, mode = True):
        self.bits = bits
        self.padding = padding
        self.exp = exp
        self.rsa = None
        self.mode = mode
    
    def generate (self):
        self.rsa = M2Crypto.RSA.gen_key(
            self.bits, self.exp, lambda x: None)
    
    def encrypt (self, s):
        #print s
        if security_mode == True and self.mode == True:
            c = ""
            bytes = self.bits/8-11
            #print bytes
            #print len(s)
            for i in range(0, len(s), bytes):
                c += self.rsa.public_encrypt (s[i:i+bytes], self.padding)
                #print c
            return base64.b64encode(c)
        else :
            return s
    
    def sign (self, s, algo="sha1"):
        dgst = M2Crypto.EVP.MessageDigest (algo)
        dgst.update (s)
        return self.rsa.sign (dgst.digest (), algo)
    
    def verify (self, s, sign, algo="sha1"):
        dgst = M2Crypto.EVP.MessageDigest (algo)
        dgst.update (s)
        try:
            self.rsa.verify (dgst.digest (), sign, algo)
        except:
            return False
        return True
    
    def decrypt (self, c):
        if security_mode == True and self.mode == True:
            try :
                c = base64.b64decode(c)
                s = ""
                bytes = self.bits/8
                for i in range(0, len(c), bytes):
                    s += self.rsa.private_decrypt (c[i:i+bytes], self.padding)
                return s
            except:
                print "error decrypt " , c
                return c
        else:
            return c
    
    def save_key_pair_into_files(self):
        self.rsa.save_key(home + "/private_key.pem",cipher=None)
        self.rsa.save_pub_key(home + "/public_key.pem")
        return
    
    def load_keys_from_file(self):
        self.rsa = M2Crypto.RSA.load_pub_key(home + "/public_key.pem")
        self.rsa = M2Crypto.RSA.load_key(home + "/private_key.pem")

