#ifndef __LX__WINDOW_H
#define __LX__WINDOW_H

#include <X11/Xlib.h>

#include <core/LinkedList.h>

#include "Widget.h"
#include "Display.h"
#include "Orientation.h"

namespace lx
{

    class Image;

    class Window: public Widget
    {
        public:
            Window(Display *display, bool rgba = false);
            ~Window();

            virtual Display* display() const { return _display; }
            ::Window xwindow() const { return _xwindow; }

            static LinkedList<Window*>* windows() { return &_windows; }



            virtual void setVisible(bool visible);

            virtual void setRect(const Rect& rect);



            virtual void processXEvent(XEvent *event);

            virtual ::GC xgc() const;
            virtual ::Drawable xdrawable() const;
            virtual ::Picture xpicture() const;
            virtual bool rgba() const;
            virtual Point absolutePosition() const;
            virtual XftDraw* xftDraw() const;

            virtual void paint(const Rect& rect);

            void blit(const Rect& rect);


            Color backgroundColor() const { return _backgroundColor; }
            void setBackgroundColor(const Color& color);


            Orientation orientation() const { return _orientation; }
            void setOrientation(Orientation orientation);


            Delegate0<bool> onCloseQuery;
            Delegate0<> onClose;


        private:
            static LinkedList<Window*> _windows;


            class RealCanvas: public Canvas
            {
                public:
                    RealCanvas();
                    RealCanvas(Window* window);

                    virtual ::GC xgc() const;
                    virtual ::Drawable xdrawable() const;
                    virtual ::Picture xpicture() const;
                    virtual Display* display() const;

                    virtual bool rgba() const;

                    virtual Point absolutePosition() const;

                    virtual XftDraw* xftDraw() const { return 0; }

                private:
                    Window* _window;
            };


            RealCanvas _realCanvas;


            Display* _display;

            ::Window _xwindow;
            ::GC _xgc;
            ::Picture _xpicture;

            bool _rgba;

            Image* _buffer;

            Widget* _mouseGrabber;


            void recreateBuffer();


            Color _backgroundColor;


            Size _realSize;

            Orientation _orientation;


            Point realToOriented(const Point& point);
            Rect realToOriented(const Rect& rect);
            Point orientedToReal(const Point& point);
            Rect orientedToReal(const Rect& rect);
    };

}

#endif
