#ifndef __LX__SIZE_H
#define __LX__SIZE_H

#include "Point.h"
#include "Orientation.h"

namespace lx
{

class Size
{
    public:
        Size(): w(0), h(0) { }

        Size(int w, int h): w(w), h(h) { }

        int w;
        int h;

        Point toPoint() const { return Point(w, h); }


        bool operator == (const Size& other) const
        {
            return w == other.w && h == other.h;
        }

        bool operator != (const Size& other) const
        {
            return w != other.w || h != other.h;
        }


        Size swapped() const
        {
            return Size(h, w);
        }


        Size rotateTo(Orientation orn) const
        {
            if (orn == CW0 || orn == CW180)
                return *this;

            return Size(h, w);
        }

        // Second method just for readability
        Size rotateFrom(Orientation orn) const
        {
            return rotateTo(orn);
        }




        void print() const
        {
            printf("Size(%d, %d)\n", w, h);
        }
};

}

#endif
