#ifndef __LX__MAINLOOP_H
#define __LX__MAINLOOP_H

#include <sys/time.h>

#include <core/LinkedList.h>
#include <core/Delegate.h>

namespace lx
{

class Timeout;

typedef Delegate2<Timeout*, void*> TimeoutCallback;

class Timeout
{
    public:
        Timeout();
        Timeout(struct timeval absTime, TimeoutCallback callback, void* userData);

        const struct timeval* absTime() const { return &_absTime; }
        TimeoutCallback callback() const { return _callback; }
        void* userData() const { return _userData; }

        void fire();

    private:
        struct timeval _absTime;
        TimeoutCallback _callback;

        void* _userData;
};


class EventSource;

class MainLoop
{
    public:
        MainLoop();
        ~MainLoop();

        static MainLoop* instance() { return _instance; }

        void addSource(EventSource* source);

        Timeout* addTimeout(float seconds, TimeoutCallback callback, void* userData = 0);

        void run();
        void stop();


    private:
        static MainLoop* _instance;

        LinkedList<EventSource*> _sources;
        LinkedList<Timeout*> _timeouts;

        fd_set _fdset_orig;
        int _maxfd;

        bool _stopped;


        static void addToTimeval(float sec, struct timeval *tv);
};

}

#endif
