#ifndef __LX__FONT_H
#define __LX__FONT_H

#include <X11/Xft/Xft.h>

#include <core/String.h>

#include "Size.h"

namespace lx
{

class Display;

class Font
{
    public:
        Font(Display* display, const char* name, int size);
        ~Font();

        XftFont* xftFont() const { return _xftFont; }

        Size extents(const String& string);
        Size extents(const char* utf8);

    private:
        Display* _display;

        mutable XftFont* _xftFont;
};


}

#endif
