#include "Font.h"

#include <X11/Xft/Xft.h>

#include "Display.h"

namespace lx
{


Font::Font(Display* display, const char* name, int size)
    : _display(display)
{
    _xftFont = XftFontOpen(_display->xdisplay(), _display->defaultScreen(),
        XFT_FAMILY, XftTypeString, name,
        XFT_PIXEL_SIZE, XftTypeInteger, size,
        NULL
    );
}


Font::~Font()
{
    XftFontClose(_display->xdisplay(), _xftFont);
}


Size Font::extents(const String& string)
{
    return extents(string.utf8());
}

Size Font::extents(const char* utf8)
{
    XGlyphInfo info;
    XftTextExtentsUtf8(
        _display->xdisplay(), _xftFont,
        (const FcChar8*)utf8, strlen(utf8),
        &info
    );

    return Size(info.width, info.height);
}


}
