#ifndef __LX__DISPLAY_H
#define __LX__DISPLAY_H

#include <X11/Xlib.h>
#include <X11/extensions/Xrender.h>

#include "EventSource.h"
#include "Exception.h"

namespace lx
{

class Display: public EventSource
{
    public:
        Display(const char *name = 0) throw(Exception);
        virtual ~Display();


        ::Display* xdisplay() const;
        ::Window root() const;
        int defaultScreen() const;

        void sync();

        virtual int fd() const;

        virtual void fire();

        Colormap defaultColormap() const;
        Colormap rgbaColormap() const;
        Visual* defaultVisual() const;
        Visual* rgbaVisual() const;

        XRenderPictFormat* rgbaPictFormat() const;
        XRenderPictFormat* rgbPictFormat() const;


        Atom WM_DELETE_WINDOW() const { return _WM_DELETE_WINDOW; }


    private:
        ::Display* _dpy;
        ::Window _root;

        Colormap _defaultColormap;
        Colormap _rgbaColormap;
        Visual* _defaultVisual;
        XVisualInfo _rgbaVisual;

        XRenderPictFormat* _rgbaPictFormat;
        XRenderPictFormat* _rgbPictFormat;


        Atom _WM_DELETE_WINDOW;
};

}

#endif
