#ifndef __LX__COLOR_H
#define __LX__COLOR_H

#include <X11/Xft/Xft.h>

namespace lx
{

// RGB color with premultiplied alpha

class Color
{
    public:
        Color(unsigned char r, unsigned char g, unsigned char b, unsigned char alpha = 255)
        {
            // (X * 257) >> 16 ≈ X / 255
            unsigned int r_pre = (r * alpha * 257) >> 16;
            unsigned int g_pre = (g * alpha * 257) >> 16;
            unsigned int b_pre = (b * alpha * 257) >> 16;

            _uint =
                (alpha << 24) |
                (r_pre << 16) |
                (g_pre <<  8) |
                (b_pre);

            _xftColor.pixel = 0;
            _xftColor.color.red   = (r_pre << 8) | r_pre;
            _xftColor.color.green = (g_pre << 8) | g_pre;
            _xftColor.color.blue  = (b_pre << 8) | b_pre;
            _xftColor.color.alpha = (alpha << 8) | alpha;
        }

        unsigned int uint() const { return _uint; }

        const XftColor* xftColor() const { return &_xftColor; }



        static const Color black;
        static const Color white;
        static const Color red;
        static const Color green;
        static const Color blue;
        static const Color transparent;


    private:
        unsigned int _uint;

        XftColor _xftColor;
};


}

#endif
