from facebook import Facebook

name = 'Facebook'
icon = 'facebook.png'
service = 'fb'
has_settings = True

API_KEY = 'b2c6abfd737f293f12a06ad869742808'
SECRET_KEY = 'e95a21f4d4dfe63ea7c47b6d1aa6718b'

EXT_URL = 'http://www.facebook.com/authorize.php?api_key=b2c6abfd737f293f12a06ad869742808&v=1.0&ext_perm=photo_upload'

def get_initial_tags(filename):
    tags = ['fb', filename, '', '', '', '']
    return tags

def test_upload_needs(settings, all_files):
    return True

def do_upload(image, dbpath, win):
    filename = image[1]
    title = image[2]
    desc = image[3]
    tags = image[4]
    album = image[5]
    myfb = FacebookCL(dbpath, win)
    myupload = myfb.upload(filename, title, desc, tags, album)
    print myupload
    return myupload

def get_allowed_ftypes():
    sf = {
        'jpeg': 'image/jpeg',
        'jpg': 'image/jpeg',
        'png': 'image/png',
        'gif': 'image/gif',
        'psd': 'image/x-photoshop',
        'tiff': 'image/tiff',
        'tif': 'image/tiff',
        'jp2': 'image/jp2',
        'wbmp': 'image/vnd.wap.wbmp',
        'xbm': 'image/x-xbitmap'
        }
    return sf

class Settings:
    def __init__(self, dbpath):
        self.dbpath = dbpath

    def show_ui(self, win):
        import gtk
        dialog = gtk.Dialog(title='Facebook settings', parent=None, flags=0,
                            buttons=("Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_transient_for(win)
        dialog.set_size_request(400, 300)
        button = gtk.Button('Clear Facebook session')
        button.connect("clicked", self.clear_db, dialog)
        dialog.vbox.pack_start(button, True, True, 0)

        dialog.show_all()
        result = dialog.run()

        dialog.destroy()

    def clear_db(self, widget, dialog):
        import sqlite3, hildon
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('drop table Facebook')
        settings_db.commit()
        cursor_sql.close()
        dialog.destroy()
        hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint',
                                                'Facebook settings cleared')


class ADV_TAGS:
    def __create_sets_model(self, setlist):
        import gobject, gtk
        lstore = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
        for item in setlist:
            iter = lstore.append()
            lstore.set(iter, 0, item[0], 1, item[1])
        return lstore

    def _sets_trv_columns(self, treeview):
        import gtk
        column = gtk.TreeViewColumn('Id', gtk.CellRendererText(), text=0)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn("Album", gtk.CellRendererText(), text=1)
        treeview.append_column(column)


    def on_get_fb_albums(self, widget, sets_trv, win):
        import thread
        try:
            import hildon
            HILDON = True
        except:
            HILDON = False

        #FIXME: Desktop compability if not HILDON.
        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', \
                                                    'Getting Facebook albums')
        thread.start_new(self._do_get_fb_albums, (banner, widget, sets_trv, win))

    def _do_get_fb_albums(self, banner, widget, sets_trv, win):
        import os
        try:
            configpath = os.path.expanduser('~')+'/.sharepy/'
            dbpath = configpath + 'settings.db'
            myfb = FacebookCL(dbpath, win)
            setlist = myfb.get_albums_list()
            print 'SETLUIST:', setlist
            banner.destroy()
            if setlist is None:
                setlist = []
        except Exception, e:
            import hildon
            banner.destroy()
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', \
                                                'Error getting Facebook albums')
            setlist = []

        self.sets_model.clear()
        #setlist = [(id, name)]
        print 'setlist here:', setlist
        if setlist != []:
            print 'saving'
            self.save_temp_setlist(setlist)
        self.sets_model = self.__create_sets_model(setlist)
        sets_trv.set_model(self.sets_model)


    def show_ui(self, image, kind, win):
        import gtk
        try:
            import mokoui
            MOKO = True
        except:
            MOKO = False

        dialog = gtk.Dialog(title='Facebook advanced', parent=win, flags=0, buttons=("Select", gtk.RESPONSE_OK, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(600, 300)

        if MOKO:
            swin = mokoui.FingerScroll()
        else:
            swin = gtk.ScrolledWindow()

        sets_trv = gtk.TreeView()
        sets_trv.set_headers_visible(True)

        setlist = self.load_temp_setlist()
        if setlist is not []:
            self.sets_model = self.__create_sets_model(setlist)
        else:
            self.sets_model = self.__create_sets_model('')

        sets_trv.set_model(self.sets_model)
        self._sets_trv_columns(sets_trv)

        swin.add(sets_trv)

        button1 = gtk.Button("Get Albums")
        button1.set_property("can-focus", False)
        button1.set_size_request(-1, 50)
        button1.connect("clicked", self.on_get_fb_albums, sets_trv, win)

        dialog.vbox.pack_start(swin, True, True, 0)
        dialog.vbox.pack_start(button1, False, False, 0)

        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_OK:
            selection = sets_trv.get_selection()
            selmodel, seliter = selection.get_selected()
            if seliter:
                selname = self.sets_model.get_value(seliter, 0)

            #image = ['FB', 'filename', 'title', 'desc', 'tags', 'albumid']
            image[5] = selname

            dialog.hide()
            return image
        else:
            dialog.hide()
            return image

        dialog.hide()

    def save_temp_setlist(self, setlist):
        import tempfile
        tmpdir = tempfile.mkdtemp(prefix='sharepy-fbalbums') + "/"
        tmpfile = tmpdir + 'fb_albumlist'
        print 'Creating tempfile: ', tmpfile
        sets = ''
        for i in range(len(setlist)):
            if i < len(setlist)-1:
                sets = sets + setlist[i][0] + '|@|' + setlist[i][1] + '|||'
            else:
                sets = sets + setlist[i][0] + '|@|' + setlist[i][1]

        tmpalb = open(tmpfile, 'w')
        tmpalb.write(sets)
        tmpalb.close()

    def load_temp_setlist(self):
        import os
        setlist = []
        tmpfile = False
        for i in os.listdir("/var/tmp"):
            if i.find("sharepy-fbalbums") >= 0:
                tmpfile = "/var/tmp/"+i+"/fb_albumlist"
                break

        if tmpfile:
            albfile = open(tmpfile, 'r')
            sets = albfile.read()
            albfile.close()
            for i in sets.split('|||'):
                setlist.append(tuple(i.split('|@|')))

        return setlist

class FacebookCL:
    def __init__(self, dbpath, win):
        self.dbpath = dbpath
        self.win = win

    def create_client(self):
        import thread, gtk
        auth_session = self.get_from_file()[1]
        print auth_session

        if auth_session != '':
            print 'using_client'
            self.facebook = self.use_client()
            return self.facebook

        self.facebook = Facebook(api_key=API_KEY, secret_key=SECRET_KEY)
        tok=self.facebook.auth.createToken()


        # Show login window
        self.facebook.login()

        #FUCKING THREADS
        gtk.gdk.threads_enter()
        self.facebook = self._do_show_authorize_dialog()
        gtk.gdk.threads_leave()

        return self.facebook

    def _do_show_authorize_dialog(self):
        import gtk
        dialog = gtk.Dialog(title='Authorize Facebook', parent=self.win, flags=0, buttons=("OK", gtk.RESPONSE_ACCEPT, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(400, 300)
        label1 = gtk.Label('Press when authorize to Facebook')
        dialog.vbox.pack_start(label1, True, True, 0)

        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            dialog.destroy()
            data = self.facebook.auth.getSession()
            print data['secret'], data['session_key']
            self.save_to_file(data)
            return self._do_show_permiss_dialog()
        else:
            print 'Failed to authorize to Facebook'
            dialog.destroy()
            return None

    def _do_show_permiss_dialog(self):
        import gtk
        dialog = gtk.Dialog(title='Allow extended permissions', parent=self.win, flags=0, buttons=("OK", gtk.RESPONSE_ACCEPT, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(400, 300)
        label1 = gtk.Label("Press OK if you want allow\n SharePy extended permissions.\n\
Then uploaded images will be\n published without approve it\n in Facebook page.")
        dialog.vbox.pack_start(label1, True, True, 0)

        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            #FIXME?: the first upload is in parallel, and go to unapproved photos?
            #For me it worked but could be for others not? Let's go to get feedback!
            import webbrowser
            webbrowser.open(EXT_URL)
            dialog.destroy()
            return self.facebook
        else:
            dialog.destroy()
            return self.facebook


    def use_client(self):
        self.facebook = Facebook(api_key=API_KEY, secret_key=SECRET_KEY)
        a, self.facebook.session_key, self.facebook.secret = self.get_from_file()
        return self.facebook

    def get_albums_list(self):
        client = self.create_client()

        if client is None:
            print 'returning None'
            return None

        albumlist = []
        albums = client.photos.getAlbums()
        for i in albums:
            albumlist.append([i['aid'], i['name']])

        return albumlist

    def upload(self, filename, title, desc, tags, album):
        client = self.create_client()
        if client is None:
            return None

        new_upload = client.photos.upload(filename, caption=title, aid=album)
        print new_upload
        return new_upload
        #TODO: createalbums
        #TODO: video.upload(title, description)
        #TODO: what to do with tags/description in sharepy UI.

    def get_from_file(self):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()
        tables = []
        for table in cursor_sql.execute('select * from sqlite_master'):
            tables.append(table[1])

        if not 'Facebook' in tables:
            print 'creating new'
            cursor_sql.execute('CREATE TABLE Facebook (id INTEGER PRIMARY KEY, \
                            fb_session text, fb_secret text)')
            settings_db.commit()
            cursor_sql.execute('REPLACE INTO Facebook VALUES (?, ?, ?)', \
                            (1, '', ''))
            settings_db.commit()


        settings = []
        for table in settings_db.execute('select * from Facebook'):
            settings.append(table)

        settings_db.close()

        print 'SETTINGS:', settings[0]

        return settings[0]


    def save_to_file(self, data):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('REPLACE INTO Facebook VALUES (?, ?, ?)', \
                            (1, data['session_key'], data['secret']))
        settings_db.commit()
        cursor_sql.close()
