# -*- coding: utf-8 -*-
from pyslideshare import pyslideshare

name = 'SlideShare'
icon = 'slideshare.png'
service = 'slideshare'
has_settings = True

apidict = {'api_key': 'AAqCKKUv', 'secret_key': '1m3g0S0p'}

def get_initial_tags(filename):
    #[filename,title,description,tags,src_public,private,secret_url,embed,share]
    tags = ['slideshare', filename, '', '', '', 'Y', 'N', 'N', 'Y', 'Y']  
    return tags

def test_upload_needs(settings, all_files):
    ind, username, password = settings.get_from_file()
    print username, password
    
    if username == '' or password == '':
        return 'Empty username or password'

    for image in all_files:
        if image[2]=='':
            return "Please, add a title to your slides"

    return True

def do_upload(image, dbpath):
    settings = Settings(dbpath)
    ind, username, password = settings.get_from_file()
    sshare = Slideshare()
    filename = image[1]
    title = image[2]
    desc = image[3]
    tags = image[4]
    src_public = image[5]
    private = image[6]
    secret_url = image[7]
    embed = image[8]
    share = image[9]
    upload = sshare.upload(username, password, filename, title, desc, tags, \
                            src_public, private, secret_url, embed, share)  
    return upload

def get_allowed_ftypes():
    sf = {
        'ppt': 'application/vnd.ms-powerpoint', 
        'pps': 'application/vnd.ms-powerpoint', 
        'pot': 'application/vnd.ms-powerpoint', 
        'pptx': 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        'ppsx': 'application/vnd.openxmlformats-officedocument.presentationml.slideshow', 
        'potx': 'application/vnd.openxmlformats-officedocument.presentationml.template', 
        'odp': 'application/vnd.oasis.opendocument.presentation', 
        'pdf': 'application/pdf', 
        'doc': 'application/msword', 
        'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 
        'sxw': 'application/vnd.sun.xml.writer',
        'rtf': 'application/rtf',
        'xls': 'application/vnd.ms-excel',
        'txt': 'text/plain',
        'ods': 'application/vnd.oasis.opendocument.spreadsheet',
        'odt': 'application/vnd.oasis.opendocument.text',
        'zip': 'application/zip',
        'key': 'application/keynote',
        'pages': 'application/pages',
        'dotx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'
        }    
    return sf

class Settings: 
    def __init__(self, dbpath):
        self.dbpath = dbpath
       
    def show_ui(self, win):
        import gtk       
        dialog = gtk.Dialog(title='Slideshare settings', parent=win, flags=0, buttons=("OK", gtk.RESPONSE_ACCEPT, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(500, 300)
        label1 = gtk.Label('Username')
        label2 = gtk.Label('Password')
        
        ind, username, password = self.get_from_file()
        
        entry1 = gtk.Entry()
        entry1.set_size_request(-1, 38)
        entry1.set_text(username)
        entry2 = gtk.Entry()
        entry2.set_size_request(-1, 38)
        entry2.set_text(password)
        entry2.set_property('hildon-input-mode', 'HILDON_GTK_INPUT_MODE_FULL')
        entry2.set_visibility(False)
        
        dialog.vbox.pack_start(label1, False, False, 10)
        dialog.vbox.pack_start(entry1, False, False, 10)        
        dialog.vbox.pack_start(label2, False, False, 10)        
        dialog.vbox.pack_start(entry2, False, False, 10)
               
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            self.save_to_file(entry1.get_text(), entry2.get_text())
            print entry1.get_text(), entry2.get_text()
        
        dialog.destroy()

    def get_from_file(self):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()        
        tables = []
        for table in cursor_sql.execute('select * from sqlite_master'):
            tables.append(table[1])

        if not 'Slideshare' in tables:
            print 'creating new'
            cursor_sql.execute('CREATE TABLE Slideshare (id INTEGER PRIMARY KEY, \
                            username text, password text)')                
            settings_db.commit()
            cursor_sql.execute('REPLACE INTO Slideshare VALUES (?, ?, ?)', \
                            (1, '', ''))  
            settings_db.commit()

            
        settings = []
        for table in settings_db.execute('select * from Slideshare'):
            settings.append(table)
        
        settings_db.close()
        
        return settings[0]
    
    def save_to_file(self, username, password):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('REPLACE INTO Slideshare VALUES (?, ?, ?)', \
                            (1, username, password))  
        settings_db.commit()
        cursor_sql.close()

class ADV_TAGS:
    def on_private_active(self, widget):
        if not widget.get_active():
            self.do_private_img_widgets_insensitive()
        else:
            self.cbutton1.set_sensitive(True)
            self.cbutton2.set_sensitive(True)
            self.cbutton3.set_sensitive(True)            

    def do_private_img_widgets_insensitive(self):
        self.cbutton1.set_sensitive(False)
        self.cbutton2.set_sensitive(False)
        self.cbutton3.set_sensitive(False)        
        self.cbutton1.set_active(False)
        self.cbutton2.set_active(False)
        self.cbutton3.set_active(False)
        
    def show_ui(self, image, kind, win):
        import gtk
        
        dialog = gtk.Dialog(title='SlideShare advanced', parent=win, flags=0, buttons=("Save", gtk.RESPONSE_OK, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(600, 300)
        
        rbutton1 = gtk.CheckButton("Make source public (allow download it)")
        rbutton2 = gtk.CheckButton("Make slideshow private")
        self.cbutton1 = gtk.CheckButton("Generate secret URL")
        self.cbutton2 = gtk.CheckButton("Allow embed the slideshow")
        self.cbutton3 = gtk.CheckButton("Share with contacts")
    
        if kind == 'simple':
            if image[5] == 'Y':
                rbutton1.set_active(1)
            else:
                rbutton1.set_active(0)                
        else:        
            rbutton1.set_active(1)   

        if kind == 'simple':
            if image[6] == 'Y':
                rbutton2.set_active(1)
            else:
                rbutton2.set_active(0)
                self.do_private_img_widgets_insensitive()              
        else:        
            rbutton2.set_active(0) 
            self.do_private_img_widgets_insensitive()

        if kind == 'simple':
            if image[7] == 'Y':
                self.cbutton1.set_active(1)
            else:
                self.cbutton1.set_active(0)                
        else:        
            self.cbutton1.set_active(0) 

        if kind == 'simple':
            if image[8] == 'Y':
                self.cbutton2.set_active(1)
            else:
                self.cbutton2.set_active(0)                
        else:        
            self.cbutton2.set_active(0)             
            
        if kind == 'simple':
            if image[9] == 'Y':
                self.cbutton3.set_active(1)
            else:
                self.cbutton3.set_active(0)                
        else:        
            self.cbutton3.set_active(0)

        rbutton2.connect('toggled', self.on_private_active)

        dialog.vbox.pack_start(rbutton1, True, True, 0)
        dialog.vbox.pack_start(rbutton2, True, True, 0)
        dialog.vbox.pack_start(self.cbutton1, True, True, 0)        
        dialog.vbox.pack_start(self.cbutton2, True, True, 0) 
        dialog.vbox.pack_start(self.cbutton3, True, True, 0)         
 
        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_OK:
            if kind == 'simple':
                if rbutton1.get_active():
                    image[5] = 'Y'
                else:
                    image[5] = 'N'
                if rbutton2.get_active():
                    image[6] = 'Y'
                else:
                    image[6] = 'N'                
                if self.cbutton1.get_active():
                    image[7] = 'Y'
                else:
                    image[7] = 'N'
                if self.cbutton2.get_active():
                    image[8] = 'Y'
                else:
                    image[8] = 'N'                                   
                if self.cbutton3.get_active():
                    image[9] = 'Y'
                else:
                    image[9] = 'N'
            else:
                rbut1 = rbutton1.get_active()
                rbut2 = rbutton2.get_active()
                cbut1 = self.cbutton1.get_active()
                cbut2 = self.cbutton2.get_active()
                cbut3 = self.cbutton3.get_active()
                
                for i in image:
                    if rbut1:
                        i[5] = 'Y'
                    else:
                        i[5] = 'N'
                    if rbut2:
                        i[6] = 'Y'
                    else:
                        i[6] = 'N'
                    if cbut1:
                        i[7] = 'Y'
                    else:
                        i[7] = 'N'      
                    if cbut2:
                        i[8] = 'Y'
                    else:
                        i[8] = 'N'              
                    if cbut3:
                        i[9] = 'Y'
                    else:
                        i[9] = 'N'

            dialog.hide()
            return image
        else:
            dialog.hide()
            return image
        
        dialog.hide()


class Slideshare:
    def __init__(self):
        pass
        #self.service = pyslideshare.pyslideshare(apidict)

    def upload(self, username, password, filename, title, desc, tags, \
                                src_public, private, secret_url, embed, share):      
    
    
        self.service = pyslideshare.pyslideshare(apidict)    
        print 'doing upload', username, password
        entry = self.service.upload_slideshow(username = str(username), 
                                password = str(password),
                                slideshow_srcfile = filename, 
                                slideshow_title = title, 
                                make_src_public = src_public, 
                                make_slideshow_private = private,
                                generate_secret_url = secret_url, 
                                allow_embeds = embed, 
                                share_with_contacts = share)

        new_entry = entry.SlideShowUploaded.SlideShowID
        return new_entry

