import gdata.photos.service

name = 'Picasa'
icon = 'picasa.png'
service = 'picasa'
has_settings = True

def get_initial_tags(filename):
    #[imgfile, title, summary, tags, album]
    #tags = ['picasa', filename, '', '', '', 'default_album'] 
    tags = ['picasa', filename, '', '', '', '']
    return tags

def test_upload_needs(settings, all_files):
    ind, username, password = settings.get_from_file()
    
    if username == '' or password == '':
        return 'Empty username or password'

    for image in all_files:
        if image[2] == '':
            return "Please, add a title to your images"
        if image[5] == '':
            return "Please, add the images to an existing album"

    return True

def do_upload(image, dbpath):
    #FIXME: improve this, shouldnt login with every image in the list or yes?
    settings = Settings(dbpath)
    ind, username, password = settings.get_from_file()
    picasa = Picasa(username, password)
    filename = image[1]
    title = image[2]
    desc = image[3]
    tags = image[4]
    album = image[5]
    upload = picasa.uploadPhotos(filename, title, desc, tags, album)
    return upload

def get_allowed_ftypes():
    sf = {
        'jpeg': 'image/jpeg',
        'jpg': 'image/jpeg',
        'png': 'image/png',
        'gif': 'image/gif',
        'bmp': 'image/x-ms-bmp',
        'psd': 'image/x-photoshop'
        }    
    return sf

class Settings:
    def __init__(self, dbpath):
        self.dbpath = dbpath
        
    def show_ui(self, win):
        import gtk      
        dialog = gtk.Dialog(title='Picasa settings', parent=win, flags=0, buttons=("OK", gtk.RESPONSE_ACCEPT, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(500, 300)
        label1 = gtk.Label('Username')
        label2 = gtk.Label('Password')
        
        ind, username, password = self.get_from_file()
        
        entry1 = gtk.Entry()
        entry1.set_size_request(-1, 38)
        entry1.set_text(username)
        entry2 = gtk.Entry()
        entry2.set_size_request(-1, 38)
        entry2.set_text(password)
        entry2.set_property('hildon-input-mode', 'HILDON_GTK_INPUT_MODE_FULL')
        entry2.set_visibility(False)
        
        dialog.vbox.pack_start(label1, False, False, 10)
        dialog.vbox.pack_start(entry1, False, False, 10)        
        dialog.vbox.pack_start(label2, False, False, 10)        
        dialog.vbox.pack_start(entry2, False, False, 10) 
                       
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            self.save_to_file(entry1.get_text(), entry2.get_text())
            print entry1.get_text(), entry2.get_text()
        
        dialog.destroy()

    def get_from_file(self):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()        
        tables = []
        for table in cursor_sql.execute('select * from sqlite_master'):
            tables.append(table[1])

        if not 'Picasa' in tables:
            print 'creating new'
            cursor_sql.execute('CREATE TABLE Picasa (id INTEGER PRIMARY KEY, \
                            username text, password text)')                
            settings_db.commit()
            cursor_sql.execute('REPLACE INTO Picasa VALUES (?, ?, ?)', \
                            (1, '', ''))  
            settings_db.commit()

            
        settings = []
        for table in settings_db.execute('select * from Picasa'):
            settings.append(table)
        
        settings_db.close()
        
        return settings[0]
    
    def save_to_file(self, username, password):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('REPLACE INTO Picasa VALUES (?, ?, ?)', \
                            (1, username, password))  
        settings_db.commit()
        cursor_sql.close()

class ADV_TAGS:
    def show_ui(self, image, kind, win):
        import gtk, gobject

        dialog = gtk.Dialog(title='Picasa advanced', parent=win, flags=0, buttons=("Save", gtk.RESPONSE_OK, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(600, 300)
        
        label1 = gtk.Label("Album:")
        
        self.album_list = gtk.ListStore(gobject.TYPE_STRING)

        saved_albums = self.load_temp_album_list()

        self.albumlist_cb = gtk.combo_box_entry_new_text() 
        self.albumlist_cb.set_model(self.album_list) 
        if saved_albums is not []:
            for i in saved_albums:
                self.albumlist_cb.append_text(i)    
               
        self.albumlist_cb.child.set_editable(False)
        self.albumlist_cb.set_text_column(0)
        self.albumlist_cb.set_active(0)
        if kind == 'simple':
            self.albumlist_cb.child.set_text(image[5])
        else:
            self.albumlist_cb.child.set_text('')          
        
                
        button1 = gtk.Button('Get Album list')
        button1.set_property("can-focus", False)
        button1.connect("clicked", self.get_albumlist)

        dialog.vbox.pack_start(label1, True, True, 0)
        dialog.vbox.pack_start(self.albumlist_cb, True, True, 0)        
        dialog.vbox.pack_start(button1, True, True, 0)   
            
        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_OK:
            #image = ['picasa', filename, title, desc, tags, 'default_album'] 
            if kind == 'simple':
                image[5] = self.albumlist_cb.get_active_text()
            else:
                alb=self.albumlist_cb.get_active_text()
                for i in image:
                    i[5] = alb
            dialog.hide()
            return image
        else:
            dialog.hide()
            return image
        
        dialog.hide()

    def get_albumlist(self, widget):
        import hildon
        import thread 
        import os   

        #FIXME: desktop compability
        configpath = os.path.expanduser('~')+'/.sharepy/'
        dbpath = configpath + 'settings.db'
        settings = Settings(dbpath)
        ind, username, password = settings.get_from_file()

        if username == '' or password == '':
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', 
                        'Empty username or password')
            return
    
        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', \
                                                    'Getting album list')
        thread.start_new(self._do_get_albumlist, (banner, widget, username, \
                        password))
    
    def _do_get_albumlist(self, banner, widget, username, password):
        self.album_list.clear()
        try:
            picasa = Picasa(username, password)
            albums, albumlist = picasa.getAlbums()
            
            for item in albumlist:
                self.album_list.append([item])
                
            self.albumlist_cb.set_active(0)
            
            self.save_temp_albumlist(self.album_list)
                     
            banner.destroy()
        except Exception, e:
            import hildon
            banner.destroy()
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', 
                        'Error getting Picasa album list')

    def save_temp_albumlist(self, albumlist):
        import tempfile
        tmpdir = tempfile.mkdtemp(prefix='sharepy-picasa') + "/"
        tmpfile = tmpdir + 'picasa_albumlist'
        print 'Creating tempfile: ',  tmpfile
        picasa_albums = ''
        for i in range(len(albumlist)):
            if i < len(albumlist)-1:
                picasa_albums = picasa_albums + albumlist[i][0] + '|||'
            else:
                picasa_albums = picasa_albums + albumlist[i][0]

        tmpalb = open(tmpfile, 'w')
        tmpalb.write(picasa_albums)
        tmpalb.close()

    def load_temp_album_list(self):
        import os
        picasa_albums = []
        tmpfile = False
        for i in os.listdir("/var/tmp"):
            if i.find("sharepy-picasa") >= 0:
                tmpfile = "/var/tmp/"+i+"/picasa_albumlist"
                break
        
        if tmpfile:
            albfile = open(tmpfile, 'r')
            albums = albfile.read()
            albfile.close()
            for i in albums.split('|||'):
                picasa_albums.append(i)

        return picasa_albums


class Picasa:
    def __init__(self, username, password):
        self.username = username
        self.password = password
        self.service = gdata.photos.service.PhotosService()
        self.service.ClientLogin(self.username, self.password)
        
    def getAlbums(self):
        albums = self.service.GetUserFeed().entry
        
        album_titles = []
        for album in albums:
            album_titles.append(album.title.text)
            
        return albums, album_titles

    def getPhotosInAlbum(self, album_title):
        albums, title_albums = self.getAlbums()
        
        if album_title == '':
            print 'Album not passed'
            return None
        
        for i in range(len(title_albums)):
            if album_title == title_albums[i]:
                album_index = i

        if album_index == '':
            print 'Album not found'
            return None
                
        photos = self.service.GetFeed(albums[album_index].GetPhotosUri()).entry
        
        photolist = []
        for photo in photos:
            for url in range(len(photo.link)):
                if url == 4:
                    one_photo = [photo.title.text, photo.link[url].href, \
                                        photo.width.text, photo.height.text]
                    photolist.append(one_photo)
                    
        return photolist
    
    def uploadPhotos(self, filename, title, summary, tags, album):
        upload = None
        albums = self.service.GetUserFeed().entry
        print album, albums

        for i in albums:
            if i.title.text == album:
                upload = self.service.InsertPhotoSimple(i, title, summary, \
                                                        filename, keywords=tags)
                break

        return upload
