import os
import sys

plugin_dir = os.path.dirname(os.path.realpath(__file__))
sys.path.insert(0, plugin_dir)

def find_plugins():
    plugin_files = [x[:-3] for x in os.listdir(plugin_dir) if x.endswith(".py")]
    plugin_files.sort()
    return plugin_files[2:]

def get_names_and_icons():
    plugins = find_plugins()
    namelist = []
    for i in plugins:
        mod = __import__(i)
        name = mod.name
        icon = mod.icon
        service = mod.service
        has_settings = mod.has_settings
        namelist.append([name, icon, service, has_settings])

    return namelist

def get_initial_tags(service, filename):
    mod = __import__(service)
    tags = mod.get_initial_tags(filename)
    
    return tags
    
def do_upload(service, image, dbpath):
    mod = __import__(service)
    upload = mod.do_upload(image, dbpath)
    
    return upload

def show_adv_tags(service, image, kind, win):
    mod = __import__(service)
    advtags = mod.ADV_TAGS()
    image = advtags.show_ui(image, kind, win)
    return image
    
def show_settings(service, dbpath):
    mod = __import__(service)
    settings = mod.Settings(dbpath)
    settings.show_ui()

def test_upload_needs(service, dbpath, all_files):
    mod = __import__(service)
    settings = mod.Settings(dbpath)
    test=mod.test_upload_needs(settings, all_files)
    return test
    
def get_allowed_ftypes(service):
    mod = __import__(service)
    sf = mod.get_allowed_ftypes()
    return sf


