#!/usr/bin/env python2.5
# -*- coding: UTF8 -*-
# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# SharePy: Share on Ovi uploader for Internet Tablets
# Version 0.3
#

import gtk, gtk.glade
import hildon
import os
import gobject
import sqlite3
import thread
import osso

osso_c = osso.Context("net.yerga.sharepy", "0.3", False)

#See if is running ins scratchbox, and set the directories in consequence
if os.path.exists('/scratchbox/login'):
    scratchbox = True
else:
    scratchbox = False

if scratchbox:
    appdir = ''
    imgdir = 'pixmaps/'
    glade_file = "sharepy.glade"
    homedir = ''
    settings_file = 'settings'
else:
    appdir = '/usr/share/sharepy/'
    imgdir = appdir + 'pixmaps/'
    glade_file = "/usr/share/sharepy/sharepy.glade" 
    homedir = '/home/user/.sharepy/'
    settings_file = '/home/user/.sharepy/settings'

def create_initial_settings():
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('CREATE TABLE General (id INTEGER PRIMARY KEY, \
                        thumbnails text, img_path text)')                
        settings_db.commit()
        cursor_sql.execute('CREATE TABLE Picasa (id INTEGER PRIMARY KEY, \
                        login text, password text, albums text)')                
        settings_db.commit()       
        cursor_sql.execute('CREATE TABLE Ovi (id INTEGER PRIMARY KEY, \
                        login text, password text, channels text)')                
        settings_db.commit()              
        cursor_sql.close()

if os.path.exists(settings_file):
    settings_db = sqlite3.connect(settings_file)
else:
    settings_db = sqlite3.connect(settings_file)
    create_initial_settings() 

all_images = []
gtk.gdk.threads_init()

class SharePy(hildon.Program):

    def __init__(self):
        self.program = hildon.Program()
        self.program.__init__()
        gtk.set_application_name('')

        self.window = hildon.Window()
        self.window.set_title('SharePy')
        self.window.set_default_size(800, 480)
        self.window.connect("destroy", self.on_quit)
        self.window.connect("key-press-event", self.on_key_press)
        self.window.connect("window-state-event", self.on_window_state_change)
        self.window_in_fullscreen = False
        self.program.add_window(self.window)

        self.cancel_upload = False
        self.service = 'ovi'
        
        self.glade=gtk.glade.XML(glade_file)
        gtkwindow = self.glade.get_widget("window1")
        vbox2 =  self.glade.get_widget("vbox1")
        vbox2.reparent(self.window)
        
        ovi_img = self.glade.get_widget("image6")
        ovi_img.set_from_file(imgdir + 'ovi.png')
        flickr_img = self.glade.get_widget("image8")
        flickr_img.set_from_file(imgdir + 'flickr.png')
        picasa_img = self.glade.get_widget("image7")
        picasa_img.set_from_file(imgdir + 'picasa.png')
        youtube_img = self.glade.get_widget("image9")
        youtube_img.set_from_file(imgdir + 'youtube.png')
        
        menu = gtk.Menu()
        self.window.set_menu(menu)
        about_menu = gtk.ImageMenuItem("About")
        about_img = gtk.Image()    
        about_img.set_from_file(imgdir + 'about.png')         
        about_menu.set_image(about_img) 
        about_menu.set_size_request(-1, 55)
        about_menu.connect("activate", self.on_about)
               
        menu.append(about_menu)            
        menu.show_all()

        self.settings = Settings()
        try:
            a, self.thumbnails, self.img_path = self.settings.get_settings()[0]
        except:
            self.thumbnails, self.img_path = 0, '/home/user/MyDocs/.images'
        try:
            a, self.picasa_user, self.picasa_pass, albums = \
                                            self.settings.get_picasa_settings()[0]
            self.picasa_albums = []
            for i in albums.split('|||'):
                self.picasa_albums.append(i)
        except:
            self.picasa_user, self.picasa_pass, self.picasa_albums = '', '', ['']
        try:
            a, self.ovi_user, self.ovi_pass, channels = \
                                                self.settings.get_ovi_settings()[0]
            self.ovi_channels = []
            for i in channels.split('|||'):
                self.ovi_channels.append(i)
        except:
            self.ovi_user, self.ovi_pass, self.ovi_channels = '', '', ['']

        self.main_ntbk = self.glade.get_widget("notebook1")
        self.main_ntbk.connect("switch_page", self.on_main_ntbk_changed)
        self.main_ntbk.set_show_tabs(False)

        self.ovi_btn = self.glade.get_widget("button11")
        self.ovi_btn.connect("clicked", self.show_page_notebook, \
                                                    self.main_ntbk, 1, 'ovi') 
        self.flickr_btn = self.glade.get_widget("button12")
        self.flickr_btn.connect("clicked", self.show_page_notebook, \
                                                    self.main_ntbk, 1, 'flickr') 
        self.picasa_btn = self.glade.get_widget("button13")
        self.picasa_btn.connect("clicked", self.show_page_notebook, \
                                                    self.main_ntbk, 1, 'picasa') 
        self.youtube_btn = self.glade.get_widget("button14")
        self.youtube_btn.connect("clicked", self.show_page_notebook, \
                                                    self.main_ntbk, 1, 'youtube') 

        self.home_btn = self.glade.get_widget("button1")
        self.home_btn.connect("clicked", self.show_page_notebook, \
                                                        self.main_ntbk, 0, 'home')
        
        self.filelist_btn = self.glade.get_widget("button17")
        self.filelist_btn.connect("clicked", self.show_page_notebook, \
                                                        self.main_ntbk, 1, 'home')        
        
        self.settings_btn = self.glade.get_widget("button2")
        self.settings_btn.connect("clicked", self.show_page_notebook, \
                                                        self.main_ntbk, 2, 'settings')        
        self.upload_btn = self.glade.get_widget("button3")
        self.upload_btn.connect("clicked", self.upload_files) 
        
        self.count_label = self.glade.get_widget("label20")
        self.count_label.set_text("0\nfiles")
        
        self.total_img = self.glade.get_widget("label25")
        self.actual_img = self.glade.get_widget("label26")
 
        self.imglist_ntbk = self.glade.get_widget("notebook2")
        self.imglist_ntbk.set_show_tabs(False)   
             
        imglist_sw = self.glade.get_widget("scrolledwindow1")
        hildon.hildon_helper_set_thumb_scrollbar(imglist_sw, True)
        
        self.imglist_tv = self.glade.get_widget("treeview1")
        self.imglist_tv.set_rubber_banding(True)
        selection = self.imglist_tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE) 
        self.imglist_model = self.__create_imglist_model()
        self.imglist_tv.set_model(self.imglist_model)
        self._imglist_tv_columns(self.imglist_tv)        

        add_imagefiles_img = self.glade.get_widget("image1")
        add_imagefiles_img.set_from_file(imgdir + 'add.png')
        
        add_imagefiles_btn = self.glade.get_widget("button4")
        add_imagefiles_btn.connect("clicked", self.add_img_to_list)

        del_imagefiles_img = self.glade.get_widget("image2")
        del_imagefiles_img.set_from_file(imgdir + 'remove.png')

        del_imagefiles_btn = self.glade.get_widget("button5")
        del_imagefiles_btn .connect("clicked", self.delete_img_from_list)

        desc_imagefiles_img = self.glade.get_widget("image3")
        desc_imagefiles_img.set_from_file(imgdir + 'edit.png')

        desc_img_btn = self.glade.get_widget("button6")
        desc_img_btn.connect("clicked", self.show_page_notebook, \
                                                    self.imglist_ntbk, 1, 'desc')

        clear_btn = self.glade.get_widget("button9")
        clear_img = self.glade.get_widget("image4")
        clear_img.set_from_file(imgdir + 'clear.png')
        clear_btn.connect("clicked", self.clear_image_list)

        select_all_btn = self.glade.get_widget("button10")
        select_img = self.glade.get_widget("image5")
        select_img.set_from_file(imgdir + 'selectall.png')
        select_all_btn.connect("clicked", self.select_all_images)

        self.title_entry = self.glade.get_widget("entry5")
        self.tags_entry = self.glade.get_widget("entry4")

        self.channel_label = self.glade.get_widget("label38")

        self.channel_vbox = self.glade.get_widget("vbox14")

        summary_sw = self.glade.get_widget("scrolledwindow3")
        hildon.hildon_helper_set_thumb_scrollbar(summary_sw, True)

        self.channel_list = gtk.ListStore(gobject.TYPE_STRING)        
        self.channel_cb = self.glade.get_widget("comboboxentry1")
        self.channel_cb.set_model(self.channel_list)
        self.channel_cb.child.set_property("editable", False)
        
        if self.ovi_channels == [] or self.ovi_channels == ['']: 
            for item in ['mymedia', 'public']:
                self.channel_list.append([item])
        else:
            for item in self.ovi_channels:
                self.channel_list.append([item])            

        self.channel_cb.set_active(0)
        
        summary_txtview = self.glade.get_widget("textview1")
        self.summary_buffer = summary_txtview.get_buffer()
        
        self.flickr_hbox = self.glade.get_widget("hbox12")
        self.desc_ntbk = self.glade.get_widget("notebook4")
        self.desc_ntbk.set_show_tabs(False)
        
        desc_btn = self.glade.get_widget("button24")
        desc_btn.connect("clicked", self.show_page_notebook, self.desc_ntbk, 0, '')
        privacy_btn = self.glade.get_widget("button25")
        privacy_btn.connect("clicked", self.show_page_notebook, self.desc_ntbk, 1, '')
        sets_btn = self.glade.get_widget("button26")
        sets_btn.connect("clicked", self.show_page_notebook, self.desc_ntbk, 2, '')
        
        save_desc_btn = self.glade.get_widget("button15")
        save_desc_btn.connect("clicked", self.save_img_description)
        cancel_desc_btn = self.glade.get_widget("button16")
        cancel_desc_btn.connect("clicked", self.show_page_notebook, \
                                            self.imglist_ntbk, 0, 'cancel_desc')

        self.batch_label = self.glade.get_widget("label16")


        self.public_img_rb = self.glade.get_widget("radiobutton1")
        self.public_img_rb.set_active(True)
        self.public_img_rb.connect('toggled', self.on_public_img_active)
        self.private_img_rb = self.glade.get_widget("radiobutton2")
        self.private_img_rb.set_group(self.public_img_rb)
        self.friend_img_rb = self.glade.get_widget("checkbutton3")
        self.family_img_rb = self.glade.get_widget("checkbutton2")
        
        self.do_private_img_widgets_insensitive()

        self.get_sets_btn = self.glade.get_widget("button27")
        self.get_sets_btn.connect("clicked", self.on_get_flickr_sets)

        sets_sw = self.glade.get_widget("scrolledwindow2")
        hildon.hildon_helper_set_thumb_scrollbar(sets_sw, True) 
               
        self.sets_tv = self.glade.get_widget("treeview2")
        self.sets_tv.set_headers_visible(True)
        self._sets_tv_columns(self.sets_tv)  
        self.sets_model = self.__create_sets_model('')  
        self.sets_tv.set_model(self.sets_model)

        ## Settings UI ##
        self.settings_ntbk = self.glade.get_widget("notebook3")
        self.settings_ntbk.set_show_tabs(False)        
        
        self.ovi_sett_btn = self.glade.get_widget("button19")
        self.ovi_sett_btn.connect("clicked", self.show_page_notebook, \
                                                    self.settings_ntbk, 1, '')
        self.picasa_sett_btn = self.glade.get_widget("button20")
        self.picasa_sett_btn.connect("clicked", self.show_page_notebook, \
                                                    self.settings_ntbk, 2,'')
        self.auth_flickr_btn = self.glade.get_widget("button21")
        
        ## Share on Ovi settings widgets ##
        self.user_entry = self.glade.get_widget("entry1")
        self.user_entry.set_text(self.ovi_user)
        self.password_entry = self.glade.get_widget("entry2")
        self.password_entry.set_property('hildon-input-mode', \
                                                    'HILDON_GTK_INPUT_MODE_FULL')
        self.password_entry.set_text(self.ovi_pass)
        
        get_ch_btn = self.glade.get_widget("button8")
        get_ch_btn.connect("clicked", self.get_channels)
        
        self.channellist_cb = self.glade.get_widget("comboboxentry2")
        self.channellist_cb.set_model(self.channel_list)        
        self.channellist_cb.child.set_editable(False)
        self.channellist_cb.set_text_column(0)
        self.channellist_cb.set_active(0)

        back1_btn = self.glade.get_widget("button22")
        back1_btn.connect("clicked", self.show_page_notebook, \
                                                    self.settings_ntbk, 0, 'back')
        
        ## Picasa Settings widgets ##
        
        self.picasa_user_entry = self.glade.get_widget("entry3")
        self.picasa_user_entry.set_text(self.picasa_user)
        self.picasa_pass_entry = self.glade.get_widget("entry6")
        self.picasa_pass_entry.set_text(self.picasa_pass)
        self.picasa_pass_entry.set_property('hildon-input-mode', \
                                                'HILDON_GTK_INPUT_MODE_FULL')
        get_albums_picasa_btn = self.glade.get_widget("button18")
        get_albums_picasa_btn.connect("clicked", self.get_picasa_albumlist)
        
        self.album_list = gtk.ListStore(gobject.TYPE_STRING)
        self.picasa_albumlist_cb = self.glade.get_widget("comboboxentry3") #-entry4
        self.picasa_albumlist_cb.set_model(self.album_list)        
        self.picasa_albumlist_cb.child.set_editable(False)
        self.picasa_albumlist_cb.set_text_column(0)
        
        if self.picasa_albums == [] or self.picasa_albums == ['']: 
            self.album_list.append([''])
        else:
            for item in self.picasa_albums:
                self.album_list.append([item])            

        self.picasa_albumlist_cb.set_active(0)
        
        
        back2_btn = self.glade.get_widget("button23")
        back2_btn.connect("clicked", self.show_page_notebook, \
                                                    self.settings_ntbk, 0, 'back')        
        
        self.thumb_cbtn = self.glade.get_widget("checkbutton1")
        self.thumb_cbtn.set_active(int(self.thumbnails))
        
        self.auth_flickr_btn = self.glade.get_widget("button21")
        self.auth_flickr_btn.connect("clicked", self.on_authotize_to_flickr)
        
        ## Upload info UI ##
        self.upinfo_hbox = self.glade.get_widget("hbox5")
        self.upinfo_title = self.glade.get_widget("label9")
        self.upinfo_filename = self.glade.get_widget("label8")
        self.upinfo_pgbar = self.glade.get_widget("progressbar1")
        self.cancel_upinfo_btn = self.glade.get_widget("button7")
        self.cancel_upinfo_btn.connect("clicked", self.on_cancel_upload)
        
        ## destroying the gtk glade window ##
        gtkwindow.destroy()

        self.window.show_all()

    def on_main_ntbk_changed(self, widget, dummy, page):
        if page == 0:
            self.settings_btn.show()
            self.settings_btn.set_sensitive(True) 
            self.home_btn.hide()
            self.upload_btn.hide()
            self.count_label.hide()
            self.filelist_btn.hide()
        elif page == 1:
            self.count_label.show()
            self.settings_btn.show()
            self.settings_btn.set_sensitive(True)
            self.home_btn.set_sensitive(True)
            self.home_btn.show()
            self.upload_btn.show()  
            self.filelist_btn.hide() 
        elif page == 2: 
            self.count_label.hide()
            self.settings_btn.hide()
            self.home_btn.show()
            self.home_btn.set_sensitive(True)
            self.upload_btn.hide()
            self.filelist_btn.hide()
        elif page == 3:
            self.count_label.hide()
            self.settings_btn.show()
            self.settings_btn.set_sensitive(False)           
            self.home_btn.show()
            self.home_btn.set_sensitive(False)
            self.filelist_btn.show()
            self.filelist_btn.set_sensitive(False)
            self.upload_btn.hide()        
            self.upinfo_pgbar.show()
            self.cancel_upinfo_btn.show()

    def show_page_notebook(self, widget, notebook, page, option):
        if option == 'cancel_desc':
            notebook.grab_focus()
        elif option == 'desc':
            selection = self.imglist_tv.get_selection()
            if selection.count_selected_rows() == 0:
                utils.show_info_banner(widget, 'No selected item') 
                return
            # Setting the correct value to the widgets:
            self.set_description_entries()           
            if self.service == 'picasa':
                self.channel_label.set_markup("<b>Album</b>")   
                self.flickr_hbox.hide()
                self.channel_vbox.show()
                self.desc_ntbk.set_current_page(0)
                self.channel_cb.set_model(self.album_list)
                self.channel_cb.child.set_text(self.album_list[0][0])
            elif self.service == 'ovi':
                self.channel_label.set_markup("<b>Channel</b>")
                self.flickr_hbox.hide()
                self.channel_vbox.show()
                self.desc_ntbk.set_current_page(0)
                self.channel_cb.set_model(self.channel_list)
                self.channel_cb.child.set_text(self.channel_list[0][0])
            elif self.service == 'flickr':                
                self.flickr_hbox.show()
                self.channel_vbox.hide()
                self.desc_ntbk.set_current_page(0)
            
            self.set_description_entries()
        elif option == 'home':
            self.main_ntbk.grab_focus()
        elif option == 'ovi':
            self.service = 'ovi'
            for image in all_images:
                if len(image) == 5: 
                    if type(image[4]) is list: #from ovi
                        pass
                    else: #from picasa
                        image[4] = [image[3]]
                        image[3] = self.channellist_cb.get_active_text()
                elif len(image) == 8: #from flickr
                    image.pop()
                    image.pop()
                    image.pop()
                    image[4] = [image[3]]
                    image[3] = self.channellist_cb.get_active_text()
            self.main_ntbk.grab_focus() 
            print all_images           
        elif option == 'flickr':
            self.service = 'flickr'
            for image in all_images:
                if len(image) == 5:
                    if type(image[4]) is list: #from ovi
                        image[3] = image[4][0]
                        image.pop()
                        image.append(1)
                        image.append(0)
                        image.append(0)
                        image.append([])                
                    else: #from picasa
                        image[4] = 1
                        image.append(0)
                        image.append(0)
                        image.append([])
                else:#from flickr
                    pass
            self.main_ntbk.grab_focus() 
            print all_images
        elif option == 'picasa':
            self.service = 'picasa'
            for image in all_images:            
                if len(image) == 8: #from flickr
                    image.pop()
                    image.pop()
                    image.pop()
                    image[4] = self.picasa_albumlist_cb.get_active_text() 
                if len(image) == 5: 
                    if type(image[4]) is list: #from ovi
                        image[3] = image[4][0]
                        image.pop()
                        image.append(self.picasa_albumlist_cb.get_active_text())
                    else:#from picasa
                        pass
            self.main_ntbk.grab_focus()
            print all_images  
        elif option == 'youtube':
            self.service = 'youtube'
            self.main_ntbk.grab_focus()
        elif option == 'back':
            self.main_ntbk.grab_focus()
        elif option == 'settings':            
            self.settings_ntbk.set_current_page(0)
        notebook.set_current_page(page)

    def on_quit(self, widget):
        ovi_user = self.user_entry.get_text()
        ovi_pass = self.password_entry.get_text()
        thumbnails = self.thumb_cbtn.get_active()
        
        picasa_user = self.picasa_user_entry.get_text()
        picasa_pass = self.picasa_pass_entry.get_text()
        
        img_path = self.img_path
        
        channels =  []
        for i in range(len(self.channel_list)):
            channels.append(self.channel_list[i][0])
        df_channel = self.channellist_cb.get_active_text()
        channels.remove(df_channel)
        channels.insert(0, df_channel)
                
        ovi_channels = ''
        for i in range(len(channels)):
            if i < len(channels)-1:
                ovi_channels = ovi_channels + channels[i] + '|||'
            else:
                ovi_channels = ovi_channels + channels[i]
        
        albums = []
        for i in range(len(self.album_list)):
            albums.append(self.album_list[i][0])
        df_album = self.picasa_albumlist_cb.get_active_text()
        albums.remove(df_album)
        albums.insert(0, df_album)        
        
        picasa_albums = ''
        for i in range(len(albums)):
            if i < len(albums)-1:
                picasa_albums = picasa_albums + albums[i] + '|||'
            else:
                picasa_albums = picasa_albums + albums[i]

        self.settings.save_settings(thumbnails, img_path, picasa_user, picasa_pass,\
                             picasa_albums, ovi_user, ovi_pass, ovi_channels)
        gtk.main_quit()

    #Functions for fullscreen
    def on_window_state_change(self, widget, event, *args):           
        if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
        else:
            self.window_in_fullscreen = False

    #F6 fullscreen, F7 bigger font, F8 smaller font
    def on_key_press(self, widget, event, *args):  
        if event.keyval == gtk.keysyms.F6:
            if self.window_in_fullscreen:
                self.window.unfullscreen ()
            else:
                self.window.fullscreen () 

    def __create_imglist_model(self):
        lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING, gobject.TYPE_STRING)
        return lstore
        
    def _imglist_tv_columns(self, treeview):       
        renderer = gtk.CellRendererPixbuf()
        column = gtk.TreeViewColumn('', renderer, pixbuf=0)
        treeview.append_column(column)  
        
        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=1)
        treeview.append_column(column)
        
        column = gtk.TreeViewColumn('Filename', gtk.CellRendererText(), text=2)
        column.set_visible(False)
        treeview.append_column(column)
        
    def add_img_to_list(self, widget):
        imgfiles = utils.file_browser(self.window, gtk.FILE_CHOOSER_ACTION_OPEN, \
                            "Select File", self.img_path, "", "")                            
        if not imgfiles:
            return

        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', \
                                            'Adding files, be patient please.')
        thread.start_new_thread(self._do_add_img_to_list, (imgfiles, banner))

    def _do_add_img_to_list(self, imgfiles, banner):
        self.img_path = os.path.dirname(imgfiles[len(imgfiles)-1])
        from mod_sharepy import share_on_ovi
        sf = share_on_ovi.supported_formats    

        thumbnails_off = self.thumb_cbtn.get_active()
        
        imgfiles = self.detect_folders(imgfiles)
        
        default_album = self.picasa_albumlist_cb.get_active_text()
        df_channel = self.channellist_cb.get_active_text()
        
        for filename in imgfiles:
            extension = os.path.splitext(filename)
            
            if sf.has_key(extension[1][1:len(extension[1])].lower()):
                #print 'supported format'
                filetype = sf[extension[1][1:len(extension[1])].lower()].split('/')[0]
            else:
                #print extension, extension[1][1:len(extension[1])]
                filetype = None
                #utils.show_info_banner(widget, 'Unsupported format')
                #return

            if filetype == 'image':
                if thumbnails_off:
                    pixbuf = utils.file_to_pixbuf(imgdir + 'image.png')
                else:
                    pixbuf = utils.file_to_pixbuf(filename)
                    if pixbuf is None:
                        pixbuf = utils.file_to_pixbuf(imgdir + 'image.png')
            elif filetype == 'video':
                pixbuf = utils.file_to_pixbuf(imgdir + 'video.png')
            elif filetype == 'audio':
                pixbuf = utils.file_to_pixbuf(imgdir + 'audio.png')
            elif filetype == 'text':  
                pixbuf = utils.file_to_pixbuf(imgdir + 'other.png')     
            else:       
                print 'some unsupported format'
                filename = None
                
                #utils.show_info_banner(widget, 'Unsupported format')
                #return
            if filename is not None:
                niter = self.imglist_model.append()            
                self.imglist_model.set(niter, 0, pixbuf, 1, os.path.basename(filename), 2, filename)
                if self.service == 'flickr':
                    #[imgfile,title,summary,tags,public,friend,family,[sets]]
                    image = [filename, '', '', '', 1, 0, 0, []]
                elif self.service == 'picasa':
                    image = [filename, '', '', '', default_album] 
                    #[imgfile, title, summary, tags, album]
                elif self.service == 'ovi':
                    #[imgfile, title, summary, category, [tags]]
                    image = [filename, '', '', df_channel, ['']]
                elif self.service == 'youtube':
                    pass
                all_images.append(image)

        banner.destroy()
        self.count_images() 

    def detect_folders(self, imgfiles):
        for i in imgfiles:
            if os.path.isdir(i):
                newfiles = os.listdir(i)
                del imgfiles[imgfiles.index(i)]
                for j in range(len(newfiles)):
                    imgfiles.append(i + '/' + newfiles[j])
                for k in imgfiles:
                    if os.path.isdir(k):
                        self.detect_folders(imgfiles)

        return imgfiles

    def delete_img_from_list(self, widget):
        selection = self.imglist_tv.get_selection()
        if selection.count_selected_rows() == 0:
            utils.show_info_banner(widget, 'No selected item') 
            return

        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]   
        
        for i in iters:
            selname = selmodel.get_value(i, 2)
            selmodel.remove(i) 

            for j in range(len(all_images)):
                if all_images[j][0] == selname:          
                    del all_images[j]
                    break 
                    
        self.count_images() 
       
    def set_description_entries(self):
        selection = self.imglist_tv.get_selection()
        
        if self.service == 'ovi':
            if selection.count_selected_rows() > 1: 
                #print 'multiple'
                self.batch_label.set_text('You are tagging a batch of files')
                self.title_entry.set_text('')
                self.tags_entry.set_text('')
                self.summary_buffer.set_text('')
                df_channel = self.channellist_cb.get_active_text()
                for i in range(len(self.channel_list)):
                    if df_channel == self.channel_list[i][0]:
                        active = i            

                self.channel_cb.set_active(active)
                
                return 
            else:
                self.batch_label.set_text('')
                selmodel, selected = selection.get_selected_rows()
                iters = [selmodel.get_iter(path) for path in selected]    
                seliter = iters[0]
                filename = self.imglist_model.get_value(seliter, 2)    
            
                for i in range(len(all_images)):
                    if all_images[i][0] == filename:           
                        image = all_images[i]
                        break 
                        
                #image = [imgfile, title, summary, category, [tags]]                    
                self.title_entry.set_text(image[1])
                self.tags_entry.set_text(image[4][0])
                self.summary_buffer.set_text(image[2])
                
                if image[3] == '':
                    df_channel = self.channellist_cb.get_active_text()
                else:
                    df_channel = image[3]
                
                for i in range(len(self.channel_list)):
                    #print i, self.channel_list[i][0]
                    if df_channel == self.channel_list[i][0]:
                        active = i

                self.channel_cb.set_active(active)

        elif self.service == 'flickr':     
            if selection.count_selected_rows() > 1: 
                #print 'multiple'
                self.batch_label.set_text('You are tagging a batch of files')
                self.title_entry.set_text('')
                self.tags_entry.set_text('')
                self.summary_buffer.set_text('')
                self.public_img_rb.set_active(True)
                self.do_private_img_widgets_insensitive()
                self.friend_img_rb.set_active(False)
                self.family_img_rb.set_active(False)
                for i in range(len(self.sets_model)):
                    self.sets_model[i][0] = False
                
                return         
            else:                        
                self.batch_label.set_text('')
                
                selmodel, selected = selection.get_selected_rows()
                iters = [selmodel.get_iter(path) for path in selected]    
                seliter = iters[0]
                filename = self.imglist_model.get_value(seliter, 2)    
        
                for i in range(len(all_images)):
                    if all_images[i][0] == filename:           
                        image = all_images[i]
                        break 
                
                self.title_entry.set_text(image[1])
                self.tags_entry.set_text(image[3])
                self.summary_buffer.set_text(image[2])
                #image = [filename, title, desc, tags, public, friend, family, sets]
                
                if image[4] == 1:
                    self.public_img_rb.set_active(True)
                    self.do_private_img_widgets_insensitive()
                    self.friend_img_rb.set_active(False)
                    self.family_img_rb.set_active(False)
                else:
                    self.public_img_rb.set_active(False)
                    self.private_img_rb.set_active(True)
                    if image[5] == 1:
                        self.friend_img_rb.set_active(True)
                    else:
                        self.friend_img_rb.set_active(False)            
                    if image[6] == 1:
                        self.family_img_rb.set_active(True)
                    else:
                        self.family_img_rb.set_active(False)       

                try:
                    for j in range(len(self.sets_model)):
                        if self.sets_model[j][1] in image[7]:
                            self.sets_model[j][0] = True
                        else:
                            self.sets_model[j][0] = False
                except:
                    print 'Failed to get the sets.'

        elif self.service == 'picasa':
            if selection.count_selected_rows() > 1: 
                #print 'multiple'
                self.batch_label.set_text('You are tagging a batch of files')
                self.title_entry.set_text('')
                self.tags_entry.set_text('')
                self.summary_buffer.set_text('')
                return         
            else:         
                self.batch_label.set_text('')
                
                selmodel, selected = selection.get_selected_rows()
                iters = [selmodel.get_iter(path) for path in selected]    
                seliter = iters[0]
                filename = self.imglist_model.get_value(seliter, 2)    
        
                for i in range(len(all_images)):
                    if all_images[i][0] == filename:           
                        image = all_images[i]
                        break        
                   
                self.title_entry.set_text(image[1])
                self.tags_entry.set_text(image[3])
                self.summary_buffer.set_text(image[2])
                
                print image[4]
                if image[4] == '':
                    df_channel = self.picasa_albumlist_cb.get_active_text()
                else:
                    df_channel = image[4]
  
                self.channel_cb.child.set_text(df_channel)


    def save_img_description(self, widget):         
        selection = self.imglist_tv.get_selection()
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]
        
        title = self.title_entry.get_text()        
        tags_txt = self.tags_entry.get_text()        
        
        start, end = self.summary_buffer.get_bounds()   
        summary = self.summary_buffer.get_text(start, end) 
        
        if self.service == 'ovi': 
            channel = self.channel_cb.get_active_text()
              
            for seliter in iters:
                filename = self.imglist_model.get_value(seliter, 2)
                image = [filename, title, summary, channel, [tags_txt]]       
                for i in range(len(all_images)):
                    if all_images[i][0] == filename:           
                        all_images[i] = image
                        break       
            
        elif self.service == 'flickr':
            sets = []

            for i in range(len(self.sets_model)):
                if self.sets_model[i][0] == True:        
                    #print self.sets_model[i][1]
                    sets.append(self.sets_model[i][1]) 
                 
            if self.public_img_rb.get_active():
                public = 1
                family = 0
                friend = 0
            elif self.private_img_rb.get_active():
                public = 0
                if self.friend_img_rb.get_active():
                    friend = 1
                else:
                    friend = 0
                if self.family_img_rb.get_active():
                    family = 1
                else:
                    family = 0

            for seliter in iters:         
                filename = self.imglist_model.get_value(seliter, 2)
                image = [filename, title, summary, tags_txt, public, friend, family, sets]
                for i in range(len(all_images)):
                    if all_images[i][0] == filename:           
                        all_images[i] = image
                        break  
            
        elif self.service == 'picasa':    
            album = self.channel_cb.get_active_text()
            for seliter in iters:         
                filename = self.imglist_model.get_value(seliter, 2)
                image = [filename, title, summary, tags_txt, album]
                for i in range(len(all_images)):
                    if all_images[i][0] == filename:           
                        all_images[i] = image
                        break 
   
        self.imglist_ntbk.grab_focus()
        self.imglist_ntbk.set_current_page(0)

        print all_images

    ## Upload files, and progressbar functions ##
    def on_cancel_upload(self, widget):
        self.cancel_upload = True

    def progress_timeout(self):
        self.upinfo_pgbar.pulse()
        return True
        
    def destroy_progress(self):
        if self.timer > 0:
            gobject.source_remove(self.timer)
        self.timer = 0
        
    def upload_files(self, widget):
        if self.service == 'ovi':
            username = self.user_entry.get_text()
            password = self.password_entry.get_text()
        elif self.service == 'picasa':
            username = self.picasa_user_entry.get_text()
            password = self.picasa_pass_entry.get_text()
        else:
            username = None
            password = None
        
        if username == '' or password == '':
            utils.show_info_banner(widget, 'Empty username or password')
            return        
          
        if all_images == []:
            utils.show_info_banner(widget, 'Not images in the list')
            return
    
        if self.service == 'picasa':        
            for image in all_images:
                if image[1] == '':
                    utils.show_info_banner(widget, "Please, add a title a your images")
                    return
    
        self.cancel_upload = False
        self.upinfo_hbox.show()
        self.total_img.set_text(str(len(self.imglist_model)))
        self.actual_img.set_text('1')
        self.upinfo_title.set_markup('<b>Uploading files...</b>')
        self.main_ntbk.set_current_page(3)
        self.timer = gobject.timeout_add (100, self.progress_timeout)
        thread.start_new(self.to_do_upload, (username, password))

    def to_do_upload(self, username, password):
        try:
            if self.service == 'ovi':
                from mod_sharepy import share_on_ovi
                soo = share_on_ovi.ShareOnOvi(username, password)
                sf = share_on_ovi.supported_formats 
            elif self.service == 'flickr':
                from mod_sharepy import flickr
                myflickr = flickr.Flickr('')
            elif self.service == 'picasa':
                from mod_sharepy import picasa
                mypicasa = picasa.Picasa(username, password)
                
            for image in all_images:
                if self.cancel_upload:
                    self.on_upload_complete('Upload canceled')
                    return
                filename = image[0]
                self.upinfo_filename.set_text(os.path.basename(filename))
                title = image[1]
                summary = image[2]
                i = 1  
                i = i + all_images.index(image)
                self.actual_img.set_text(str(i))

                if self.service == 'flickr':
                    tags = image[3]
                    public = image[4]
                    friend = image[5]
                    family = image[6]
                    sets = image[7]                
                    result = myflickr.upload(filename, title, summary, tags, \
                                                    public, friend, family, sets)
                elif self.service == 'picasa':
                    tags = image[3] 
                    album = image[4] 
                    result = mypicasa.uploadPhotos(filename, title, summary, tags, album)
                elif self.service == 'ovi':
                    channel = image[3]
                    tags = image[4][0]
                    extension = os.path.splitext(filename)
                    filetype = sf[extension[1][1:len(extension[1])].lower()]
                    result = soo.upload(filename, title, summary, channel, tags, filetype)
                    if result == 'authentication failed':
                        self.upload_failed('Error uploading files: Authentication failed')
                        return
                    if result == 'ovi unavailable':
                        self.upload_failed('Error uploading files: Share on Ovi unavailable')
                        return                
                
            self.destroy_progress()
            self.on_upload_complete('Upload complete')
        except:
            result = None

        if result is None:
            self.upload_failed('Error uploading files')

    def upload_failed(self, msg):
        self.destroy_progress()
        self.on_upload_complete(msg)        

    def on_upload_complete(self, upinfo):
        self.settings_btn.set_sensitive(True)
        self.home_btn.set_sensitive(True)
        self.filelist_btn.set_sensitive(True)
        self.upinfo_pgbar.hide()
        self.cancel_upinfo_btn.hide()
        self.upinfo_title.set_markup('<b>'+upinfo+'</b>')
        self.upinfo_filename.set_text('')
        self.upinfo_hbox.hide()
        
    ## Get Share on Ovi channel list ##
    def get_channels(self, widget):
        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', 'Getting channel list')
        thread.start_new(self.get_channels_from_ovi, (banner,widget))
              
    def get_channels_from_ovi(self, banner, widget):
        from mod_sharepy import share_on_ovi
        try: 
            username = self.user_entry.get_text()
            password = self.password_entry.get_text()
            soo = share_on_ovi.ShareOnOvi(username, password)    
            channels = soo.getChannels()
            self.channel_list.clear()
            for item in channels:
                self.channel_list.append([item])
            self.channellist_cb.set_active(0)
            banner.destroy()
        except:
            utils.show_thread_error(banner, widget, 'Error getting channels')
            
        #for i in range(len(self.channel_list)):
        #    print 'a: ', self.channel_list[i][0]

    def select_all_images(self, widget):
        selection = self.imglist_tv.get_selection()
        selection.select_all()

    def clear_image_list(self, widget):
        self.imglist_model.clear()
        del all_images[:]
        self.count_images()

    def count_images(self):
        self.count_label.set_text("%i\nfiles" % len(self.imglist_model))

    def on_authotize_to_flickr(self, widget):
        from mod_sharepy import flickr
        try:
            flickr.authorize_on_flickr(utils, self.window)
        except Exception, e:
            print 'Error authorizing to Flickr'

    def on_public_img_active(self, widget):
        if self.public_img_rb.get_active():
            self.do_private_img_widgets_insensitive()
        else:
            self.friend_img_rb.set_sensitive(True)
            self.family_img_rb.set_sensitive(True)

    def do_private_img_widgets_insensitive(self):
        self.friend_img_rb.set_sensitive(False)
        self.family_img_rb.set_sensitive(False)
        self.family_img_rb.set_active(False)
        self.friend_img_rb.set_active(False)
      
    def on_get_flickr_sets(self, widget):
        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', \
                                                    'Getting Flickr sets')
        thread.start_new(self._do_get_flickr_sets, (banner, widget))      
     
    def _do_get_flickr_sets(self, banner, widget):
        from mod_sharepy import flickr
        try:
            myflickr = flickr.Flickr('')
            setlist = myflickr.get_set_list()
            banner.destroy()
        except Exception, e:
            utils.show_thread_error(banner, widget, 'Error getting Flickr sets')
            setlist = []
            
        self.sets_model.clear()
        #setlist = [(id, name)]
        self.sets_model = self.__create_sets_model(setlist)
        self.sets_tv.set_model(self.sets_model)

    def __create_sets_model(self, setlist):
        lstore = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, \
                    gobject.TYPE_STRING)
        for item in setlist:
            iter = lstore.append()
            lstore.set(iter, 0, False, 1, item[0], 2, item[1])

        return lstore     

    def _sets_tv_columns(self, treeview):
        renderer = gtk.CellRendererToggle()
        renderer.connect('toggled', self.sets_toggled)
        column = gtk.TreeViewColumn('', renderer, active=0)
        column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        column.set_fixed_width(50)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('Id', gtk.CellRendererText(), text=1)
        column.set_visible(False)
        treeview.append_column(column)

        column = gtk.TreeViewColumn("Set", gtk.CellRendererText(), text=2)            
        treeview.append_column(column)

    def sets_toggled(self, cell, path):
        seliter = self.sets_model.get_iter((int(path),))
        fixed = self.sets_model.get_value(seliter, 0)

        fixed = not fixed
        self.sets_model.set(seliter, 0, fixed)

    def get_picasa_albumlist(self, widget):
        username = self.picasa_user_entry.get_text()
        password = self.picasa_pass_entry.get_text()
        
        if username == '' or password == '':
            utils.show_info_banner(widget, 'Empty username or password')
            return
    
        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', \
                                                    'Getting album list')
        thread.start_new(self._do_get_picasa_albumlist, (banner, widget, username, \
                        password))      
    
    def _do_get_picasa_albumlist(self, banner, widget, username, password):
        from mod_sharepy import picasa
        self.album_list.clear()
        try:
            mypicasa = picasa.Picasa(username, password)
            albums, albumlist = mypicasa.getAlbums()
            
            for item in albumlist:
                self.album_list.append([item])
                
            self.picasa_albumlist_cb.set_active(0)
            #self.channellist.set_active(0)            
            banner.destroy()
        except Exception, e:
            utils.show_thread_error(banner, widget, 'Error getting Picasa album list')

    def on_about(self, widget):
        dialog = gtk.AboutDialog()
        dialog.set_name("SharePy")
        dialog.set_version("0.3")
        dialog.set_copyright("Copyright © 2008")
        dialog.set_website("http://sharepy.garage.maemo.org")
        dialog.set_authors(["Daniel Martin Yerga <dyerga@gmail.com>\nThanks to Stephen Wing for the SharePy name.\nThanks to gerrymoth for his suggestions and support."])
        logo = gtk.gdk.pixbuf_new_from_file(imgdir + "sharepy.png")
        dialog.set_logo(logo)
        dialog.set_license("This program is released under the GNU\nGeneral Public License. Please visit \nhttp://www.gnu.org/copyleft/gpl.html\nfor details.")
        dialog.set_artists(["Logo from Gorilla iconset.\nIcons from Allblack iconset."])
        dialog.run()
        dialog.destroy()   
    
class Utils:
    def get_selected_from_treeview(self, treeview, model, setting):
        selection = treeview.get_selection()
        selected_model, selected_iter = selection.get_selected()
        if selected_iter:
            selected_name = model.get_value(selected_iter, setting)
        return selected_name, selected_iter, selected_model

    def show_thread_error(self, banner, widget, error_msg):
        banner.destroy()
        gtk.gdk.threads_enter()
        show_info_banner(widget, error_msg)
        gtk.gdk.threads_leave()
        return   
        
    def show_info_dialog(self, window, msg):
        dialog = hildon.hildon_note_new_information(window, msg)
        dialog.show_all()
        dialog.run()
        dialog.destroy() 

    def show_info_banner(self, widget, msg):
        hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)       

    def file_browser(self, window, action, title, folder, filename, file_ext):
        file_dialog = hildon.FileChooserDialog(window, action=action)
        file_dialog.add_button('Add entire folder', gtk.RESPONSE_YES)

        file_dialog.set_title(title)
        file_dialog.set_current_folder(folder)
        file_dialog.set_select_multiple(True)
        file_dialog.set_default_response(gtk.RESPONSE_CANCEL)
            
        result = file_dialog.run()
        if result == gtk.RESPONSE_OK:
            namefiles = file_dialog.get_filenames()
        elif result == gtk.RESPONSE_YES:
            file_dialog.hide()
            folder_dialog = hildon.FileChooserDialog(window, \
                            action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
            folder_dialog.set_title('Select folder')
            folder_dialog.run()
            namefiles = folder_dialog.get_filenames()
            folder_dialog.destroy()
        else:
            namefiles = False
        file_dialog.destroy()

        return namefiles

    def file_to_pixbuf(self, filename):
        try:
            new_pixbuf = gtk.gdk.pixbuf_new_from_file(filename)

            ## Scale pixbuf
            w, h = self.set_thumbnail_size(new_pixbuf)
            image_pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename, int(w), int(h))

            del new_pixbuf    
        except:
            print 'Failed to create a thumbnail.'
            self.show_info_banner(gtk.Window(), 'Failed to create a thumbnail\nPossibly '+os.path.basename(filename)+' is corrupted')
            image_pixbuf = None
            
        return image_pixbuf
        
    def set_thumbnail_size(self, pixbuf):
        pix_width = pixbuf.get_width()
        pix_height = pixbuf.get_height()

        if pix_width > pix_height:
            w = 140
            h = float(pix_height)/float(pix_width) * 140
        elif pix_height > pix_width:
            h = 140
            w = float(pix_width)/float(pix_height) * 140
        elif pix_height == pix_width:
            h = 140
            w = 140
        else:
            print "Pixbuf size can't be calculated."

        return w, h
        
class Settings:
    def save_settings(self, thumbnails, img_path, picasa_user, picasa_pass,\
                             picasa_albums, ovi_user, ovi_pass, ovi_channels):
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('REPLACE INTO General VALUES (?, ?, ?)', \
                            (1, thumbnails, img_path))  
        settings_db.commit()
        cursor_sql.execute('REPLACE INTO Picasa VALUES (?, ?, ?, ?)', \
                            (1, picasa_user, picasa_pass, picasa_albums))  
        settings_db.commit()    
        cursor_sql.execute('REPLACE INTO Ovi VALUES (?, ?, ?, ?)', \
                            (1, ovi_user, ovi_pass, ovi_channels))  
        settings_db.commit()
        cursor_sql.close()

    def get_settings(self):
        settings = []
        for table in settings_db.execute('select * from General'):
            settings.append(table)

        #settings = [thumbnails, img_path]
        return settings
        
    def get_ovi_settings(self):
        settings = []
        for table in settings_db.execute('select * from Ovi'):
            settings.append(table)
        
        #settings = [ovi_user, ovi_pass, ovi_channels]
        return settings    
    
    def get_picasa_settings(self):
        settings = []
        for table in settings_db.execute('select * from Picasa'):
            settings.append(table)
        
        #settings = [picasa_user, picasa_pass, picasa_albums]
        return settings     

if __name__ == "__main__":
    sharepy = SharePy()
    utils = Utils()
    Settings = Settings()
    gtk.gdk.threads_enter()
    gtk.main()
    gtk.gdk.threads_leave()
