import gdata.photos.service
import os

class Picasa:

    def __init__(self, username, password):
    
        self.username = username
        self.password = password
        
        self.service = gdata.photos.service.PhotosService()
        self.service.ClientLogin(self.username, self.password)
        
    def getAlbums(self):
        albums = self.service.GetUserFeed().entry
        
        album_titles = []
        for album in albums:
            album_titles.append(album.title.text)
            
        return albums, album_titles

    def getPhotosInAlbum(self, album_title):
        albums, title_albums = self.getAlbums()
        
        if album_title == '':
            print 'Album not passed'
            return None
        
        for i in range(len(title_albums)):
            if album_title == title_albums[i]:
                album_index = i

        if album_index == '':
            print 'Album not found'
            return None
                
        photos = self.service.GetFeed(albums[album_index].GetPhotosUri()).entry
        
        photolist = []
        for photo in photos:
            for url in range(len(photo.link)):
                if url == 4:
                    one_photo = [photo.title.text, photo.link[url].href, \
                                        photo.width.text, photo.height.text]
                    photolist.append(one_photo)
                    
        return photolist
    
    def uploadPhotos(self, filename, title, summary, tags, album):
        upload = None
        albums = self.service.GetUserFeed().entry
        print album, albums

        for i in albums:
            if i.title.text == album:
                upload = self.service.InsertPhotoSimple(i, title, summary, \
                                                        filename, keywords=tags)
                break

        return upload
        
