/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-12-0/engines/gob/sound/sounddesc.h $
 * $Id: sounddesc.h 31937 2008-05-08 00:47:23Z drmccoy $
 *
 */

#ifndef GOB_SOUND_SOUNDDESC_H
#define GOB_SOUND_SOUNDDESC_H

#include "common/endian.h"

namespace Gob {

enum SoundType {
	SOUND_SND,
	SOUND_ADL
};

enum SoundSource {
	SOUND_FILE,
	SOUND_TOT,
	SOUND_EXT
};

class SoundDesc {
public:
	int16 _repCount;
	int16 _frequency;
	int16 _flag;
	int16 _id;

	byte *getData() { return _dataPtr; }

	uint32    size()         const { return _size;     }
	bool      empty()        const { return !_dataPtr; }
	SoundType getType()      const { return _type;     }

	bool isId(int16 id) const { return _dataPtr && (_id == id); }

	void set(SoundType type, SoundSource src, byte *data, uint32 dSize);
	void load(SoundType type, SoundSource src, byte *data, uint32 dSize);
	void free();
	void convToSigned();

	// Which fade out length to use when the fade starts half-way through?
	int16 calcFadeOutLength(int16 frequency);
	uint32 calcLength(int16 repCount, int16 frequency, bool fade);

	SoundDesc();
	~SoundDesc();

private:
	byte *_data;
	byte *_dataPtr;
	uint32 _size;

	SoundType _type;
	SoundSource _source;

	void loadSND(byte *data, uint32 dSize);
	void loadADL(byte *data, uint32 dSize);
};

} // End of namespace Gob

#endif // GOB_SOUND_SOUNDDESC_H
