/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "ShowMoveDialog.h"

#include <Lum/Base/L10N.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>

#include "CardArea.h"

ShowMoveDialog::ShowMoveDialog(bool playerIsComputer,
                               const Move& move,
                               const std::vector<Lum::Images::ImageRef>& images)
 : playerIsComputer(playerIsComputer),
   move(move),
   images(images)
{
  AttachModel(GetClosedAction());
}

void ShowMoveDialog::PreInit()
{
  Lum::Button       *button;
  Lum::ButtonRow    *row;
  CardArea          *cardArea;
  Lum::Label        *label;
  Lum::Panel        *vert;

  vert=new Lum::VPanel();

  label=new Lum::Label();

  if (move.hasMove) {
    std::vector<Card> tmp;

    tmp.push_back(move.cards[0]);

    cardArea=new CardArea();
    cardArea->SetSize(1,1);
    cardArea->SetImages(images);
    cardArea->SetCards(tmp);

    if (playerIsComputer) {
      label->AddLabel(_(L"SHOW_MOVE_LABEL_COMPUTER_PLAYED",L"Computer played:"),cardArea);
    }
    else {
      label->AddLabel(_(L"SHOW_MOVE_LABEL_HUMAN_PLAYED",L"You played:"),cardArea);
    }
  }

  if (!move.hasMove || move.cards.size()>1) {

    if (move.hasMove) {
      move.cards.erase(move.cards.begin());
    }

    cardArea=new CardArea();
    cardArea->SetSize(move.cards.size(),1);
    cardArea->SetImages(images);
    cardArea->SetCards(move.cards);

    label->AddLabel(_(L"SHOW_MOVE_LABEL_COLLECTED",L"Collected:"),cardArea);
  }

  vert->Add(label);

  vert->Add(new Lum::VSpace());

  row=new Lum::ButtonRow();
  row->SetFlex(true,false);

  button=new Lum::Button(_ld(dlgButtonClose));
  button->SetFlex(true,true);
  button->SetModel(GetClosedAction());
  button->SetType(Lum::Button::typeDefault);

  row->Add(button);

  vert->Add(row);

  SetMain(vert);

  Dialog::PreInit();
}

void ShowMoveDialog::Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
{
  if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }

  Dialog::Resync(model,msg);
}

void ShowMove(Lum::Dialog* parent,
              bool playerIsComputer,
              const Move& move,
              const std::vector<Lum::Images::ImageRef>& images)
{
  ShowMoveDialog *dialog;

  dialog=new ShowMoveDialog(playerIsComputer,move,images);
  dialog->SetParent(parent);

  if (dialog->Open()) {
    dialog->EventLoop();
    dialog->Close();
  }

  delete dialog;
}
