/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "RoundResultDialog.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Grid.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>

RoundResultDialog::RoundResultDialog(const std::vector<Result> result,
                                     const std::vector<size_t>& points,
                                     size_t globalPoints[2])
 : result(result),
   points(points)
{
  this->globalPoints[0]=globalPoints[0];
  this->globalPoints[1]=globalPoints[1];

  AttachModel(GetClosedAction());
}

Lum::Text* RoundResultDialog::GetTableEntry(const std::wstring& string, bool bold)
{
  Lum::Text* text;

  text=new Lum::Text();
  text->SetFlex(true,false);
  if (bold) {
    text->SetText(string,Lum::OS::Font::bold,Lum::Text::centered);
  }
  else {
    text->SetText(string,Lum::OS::Font::normal,Lum::Text::centered);
  }

  return text;
}

void RoundResultDialog::PreInit()
{
  Lum::Button      *button;
  Lum::ButtonRow   *row;
  Lum::Grid        *grid;
  Lum::Panel       *vert;

  vert=new Lum::VPanel();

  grid=new Lum::Grid();
  grid->SetSize(5,8);
  grid->SetSpace(true,true);

  // Heading

  grid->SetObject(1,0,new Lum::Text(_(L"ROUND_RESULT_LABEL_HUMAN",L"You")));
  grid->SetObject(2,0,new Lum::Text(_(L"ROUND_RESULT_LABEL_COMPUTER",L"Other")));
  grid->SetObject(3,0,new Lum::Text(_(L"ROUND_RESULT_LABEL_HUMAN_POINTS",L"Points You")));
  grid->SetObject(4,0,new Lum::Text(_(L"ROUND_RESULT_LABEL_COMPUTER_POINTS",L"Points Other")));

  // Scopas

  grid->SetObject(0,1,new Lum::Text(_(L"ROUND_RESULT_LABEL_SCOPAS",L"Scopas:")));

  if (result[0].GetScopas()>0) {
    grid->SetObject(1,1,GetTableEntry(Lum::Base::NumberToWString(result[0].GetScopas())));
  }

  if (result[1].GetScopas()>0) {
    grid->SetObject(2,1,GetTableEntry(Lum::Base::NumberToWString(result[1].GetScopas())));
  }

  if (result[0].GetScopas()>0) {
    grid->SetObject(3,1,GetTableEntry(Lum::Base::NumberToWString(result[0].GetScopas()),true));
  }

  if (result[1].GetScopas()>0) {
    grid->SetObject(4,1,GetTableEntry(Lum::Base::NumberToWString(result[1].GetScopas()),true));
  }

  // Cards

  grid->SetObject(0,2,new Lum::Text(_(L"ROUND_RESULT_LABEL_CARDS",L"Cards:")));

  grid->SetObject(1,2,GetTableEntry(Lum::Base::NumberToWString(result[0].GetCards())));
  grid->SetObject(2,2,GetTableEntry(Lum::Base::NumberToWString(result[1].GetCards())));

  if (result[0].GetCards()>result[1].GetCards()) {
    grid->SetObject(3,2,GetTableEntry(L"1",true));
  }

  if (result[1].GetCards()>result[0].GetCards()) {
    grid->SetObject(4,2,GetTableEntry(L"1",true));
  }

  // Denares

  grid->SetObject(0,3,new Lum::Text(_(L"ROUND_RESULT_LABEL_DENARES",L"Denares:")));

  grid->SetObject(1,3,GetTableEntry(Lum::Base::NumberToWString(result[0].GetDenares())));
  grid->SetObject(2,3,GetTableEntry(Lum::Base::NumberToWString(result[1].GetDenares())));

  if (result[0].GetDenares()>result[1].GetDenares()) {
    grid->SetObject(3,3,GetTableEntry(L"1",true));
  }

  if (result[1].GetDenares()>result[0].GetDenares()) {
    grid->SetObject(4,3,GetTableEntry(L"1",true));
  }

  // Denare 7

  grid->SetObject(0,4,new Lum::Text(_(L"ROUND_RESULT_LABEL_DENARE7",L"Denare 7:")));

  if (result[0].HasDenare7()) {
    grid->SetObject(1,4,GetTableEntry(_(L"ROUND_RESULT_YES",L"yes")));
  }

  if (result[1].HasDenare7()) {
    grid->SetObject(2,4,GetTableEntry(_(L"ROUND_RESULT_YES",L"yes")));
  }

  if (result[0].HasDenare7()) {
    grid->SetObject(3,4,GetTableEntry(L"1",true));
  }

  if (result[1].HasDenare7()) {
    grid->SetObject(4,4,GetTableEntry(L"1",true));
  }

  // Primiera

  grid->SetObject(0,5,new Lum::Text(_(L"ROUND_RESULT_LABEL_PRIMIERA",L"Primiera:")));

  grid->SetObject(1,5,GetTableEntry(Lum::Base::NumberToWString(result[0].GetPrimieraPoints())));
  grid->SetObject(2,5,GetTableEntry(Lum::Base::NumberToWString(result[1].GetPrimieraPoints())));

  if (result[0].GetPrimieraPoints()>result[1].GetPrimieraPoints()) {
    grid->SetObject(3,5,GetTableEntry(L"1",true));
  }

  if (result[1].GetPrimieraPoints()>result[0].GetPrimieraPoints()) {
    grid->SetObject(4,5,GetTableEntry(L"1",true));
  }

  // Result points for this game

  grid->SetObject(0,6,new Lum::Text(_(L"ROUND_RESULT_LABEL_ROUND_RESULT",L"Round result:")));

  grid->SetObject(3,6,GetTableEntry(Lum::Base::NumberToWString(points[0]),true));
  grid->SetObject(4,6,GetTableEntry(Lum::Base::NumberToWString(points[1]),true));

  // Resulting points over all

  grid->SetObject(0,7,new Lum::Text(_(L"ROUND_RESULT_LABEL_GAME_RESULT",L"Over all:")));

  grid->SetObject(3,7,GetTableEntry(Lum::Base::NumberToWString(globalPoints[0]),true));
  grid->SetObject(4,7,GetTableEntry(Lum::Base::NumberToWString(globalPoints[1]),true));

  vert->Add(grid);

  vert->Add(new Lum::VSpace());

  row=new Lum::ButtonRow();
  row->SetFlex(true,false);

  button=new Lum::Button(_ld(dlgButtonClose));
  button->SetFlex(true,true);
  button->SetModel(GetClosedAction());
  button->SetType(Lum::Button::typeDefault);

  row->Add(button);

  vert->Add(row);

  SetMain(vert);

  Dialog::PreInit();
}

void RoundResultDialog::Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
{
  if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }

  Dialog::Resync(model,msg);
}

void ShowRoundResult(Lum::Dialog* parent, const std::vector<Result> result,
                     const std::vector<size_t>& points,
                     size_t globalPoints[2])
{
  RoundResultDialog *dialog;

  dialog=new RoundResultDialog(result,points,globalPoints);
  dialog->SetParent(parent);

  if (dialog->Open()) {
    dialog->EventLoop();
    dialog->Close();
  }

  delete dialog;
}

