#ifndef SHOWMOVEDIALOG_H
#define SHOWMOVEDIALOG_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <vector>

#include <Lum/Images/Image.h>

#include <Lum/Dialog.h>

#include "Card.h"

class Move
{
public:
  bool              hasMove;
  std::vector<Card> cards;
public:
  Move(const std::vector<Card>& cards, bool hasMove=true)
  : hasMove(hasMove),
    cards(cards)
  {
    // no code
  }

  Move(const Card& card)
  {
    hasMove=true;
    cards.push_back(card);
  }
};

class ShowMoveDialog : public Lum::Dialog
{
private:
  bool                               playerIsComputer;
  Move                               move;
  std::vector<Lum::Images::ImageRef> images;

public:
  ShowMoveDialog(bool playerIsComputer,
                 const Move& move,
                 const std::vector<Lum::Images::ImageRef>& images);
  ~ShowMoveDialog();

  void PreInit();
  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

extern void ShowMove(Lum::Dialog* parent,
                     bool playerIsComputer,
                     const Move& move,
                     const std::vector<Lum::Images::ImageRef>& images);

#endif

