/*
 * Copyright (c) 2003, 2004, 2005 Nokia
 * Author: Timo Savola <tsavola@movial.fi>
 *
 * This program is licensed under GPL (see COPYING for details)
 */

#ifndef MOUNT_H
#define MOUNT_H

#include "config_autoconf.h"
#include "types.h"

#define MOUNTS_FILE "/proc/mounts"

typedef enum {
	/** mount info type: NFS */
	MTYPE_NFS  = 1,

	/** mount info type: path should be bound to a mount point */
	MTYPE_BIND = 2,

	/** mount info type: SSH */
	MTYPE_SSH  = 3,
} mtype_t;

struct mount_info_s;
struct mount_s;

/** Describes how stuff should be mounted. */
typedef struct mount_info_s {
	/** Mount type. */
	mtype_t type;

	/** Mount point path. */
	char *point;

	/** Path to special file or whatever should be mounted... */
	char *device;

	/** Options for the mount command (-o). */
	char *opts;

	/** Device number of DEVICE (not applicable for MTYPE_BIND). */
	dev_t device_dev;
} mount_info_t;

/** An entry in a doubly linked list of mount points. */
typedef struct mount_s {
	struct mount_s *prev;
	struct mount_s *next;

	/** How many processes are using this mount? */
	unsigned int usage;

	/** When will the mount expire? Relevant when usage is 0. */
	time_t expiration;

	/** Properties of the mount entry. */
	struct mount_info_s info;

	/** Device number of POINT (not applicable for MTYPE_BIND). */
	dev_t point_dev;
} mount_t;

mount_info_t *mntinfo_alloc(void);
void mntinfo_free(mount_info_t *);
int mntinfo_copy(mount_info_t *, mount_info_t *);
mount_info_t *mntinfo_parse(const char *);
int mntinfo_stat_device(mount_info_t *);
void mntinfo_sort_vec(mount_info_t **);

#endif
