#!/usr/bin/python
# -*- coding: utf-8 -*-
from math import *
from urllib import *
try:
    import sqlite3
except:
    from pysqlite2 import dbapi2 as sqlite3
    
from xml.sax import handler, make_parser
import xml
import os
import sys

class Node:
    def __init__(self,id_node=False,lat=0.0,lon=0.0):
        self.id_node=id_node
        self.lat=lat
        self.lon=lon
        self.tags={}

class Way:
    def __init__(self,id_way=False):
        self.id_way=id_way
        self.tags={}
        self.nodes=[]
    
class Relation:
    def __init__(self,id_rel=False):
        self.id_ref=id_rel
        self.tags={}
        self.members=[]

class Relation_Member:
    def __init__(self,type=False,ref=False,role=False):
        self.type=type
        self.ref=ref
        self.role=role


class OsmParser(handler.ContentHandler):
    def __init__(self,filename):
        self.cur_type=False
        self.cur_node_id=False
        self.cur_way_id=False
        self.cur_rel_id=False

        self.NODE_TYPE=1
        self.WAY_TYPE=2
        self.REL_TYPE=3

        self.nodes={}
        self.ways={}
        self.relations={}
        self.loadFile(filename)
        



    def loadFile(self,filename):
        if(not os.path.exists(filename)):
            return
        try:
            parser = make_parser()
            parser.setContentHandler(self)
            parser.parse(filename)
        except xml.sax._exceptions.SAXParseException:
            print "Error loading %s" % filename


    def startElement(self, name, attrs):
        """
            node,way or relations
            
        """
        if name=="node":
            self.cur_type=self.NODE_TYPE
            node_id=int(attrs.get('id'))
            node_lat=float(attrs.get('lat'))
            node_lon=float(attrs.get('lon'))
            cur_node=Node(node_id,node_lat,node_lon)
            self.nodes[node_id]=cur_node
            self.cur_node_id=node_id

        if name=="way":
            self.cur_type=self.WAY_TYPE
            way_id=int(attrs.get('id'))
            cur_way=Way(way_id)
            self.ways[way_id]=cur_way
            self.cur_way_id=way_id

        if name=="relation":
            self.cur_type=self.REL_TYPE
            rel_id=int(attrs.get("id"))
            cur_rel=Relation(rel_id)
            self.relations[rel_id]=cur_rel
            self.cur_rel_id=rel_id

        if name=="tag":
            k=attrs.get("k")
            v=attrs.get("v")

            if self.cur_type==self.NODE_TYPE:
                self.nodes[self.cur_node_id].tags[k]=v
            elif self.cur_type==self.WAY_TYPE:
                self.ways[self.cur_way_id].tags[k]=v
            elif self.cur_type==self.REL_TYPE:
                self.relations[self.cur_rel_id].tags[k]=v


        if name=="nd":
            if self.cur_type==self.WAY_TYPE:
                ref=int(attrs.get("ref"))
                self.ways[self.cur_way_id].nodes.append(ref)

        if name=="member":
            if self.cur_type==self.REL_TYPE:
                type=str(attrs.get("type"))
                ref=str(attrs.get("ref"))
                role=str(attrs.get("role"))
                cur_member=Relation_Member(type,ref,role)
                self.relations[self.cur_rel_id].members.append(cur_member)
                


    def endElement(self,name):
        return

class OsmSqliteFeeder:

    def __init__(self,db_location="./testdatabase.bin",\
                     lat_min=48.81183,\
                     lat_max=48.90388,\
                     lon_min=2.23657,\
                     lon_max=2.42987,\
                     cache="./cache"):

        self.lat_min=lat_min
        self.lat_max=lat_max
        self.lon_min=lon_min
        self.lon_max=lon_max
        self.db_location=db_location
        self.cache=cache
        self.dbConnector=False

        self.ENCLOSE_DEGREE_STEP=0.03

        if not self.database_exist():
            self.create_database()
        
        if not os.path.exists(self.cache):
            os.makedirs(self.cache)

    def database_exist(self):
        if not os.path.isfile(self.db_location):
            return False
        self.dbConnector=sqlite3.connect(self.db_location)
        self.dbCursor=self.dbConnector.cursor()
        
        try:
            self.dbCursor.execute("Select count(*) from nodes")
        except:
            return False

        return True

    def create_database(self):
        print "Creating database",self.db_location
        self.dbConnector=sqlite3.connect(self.db_location)
        self.dbCursor=self.dbConnector.cursor()

        todo=[]
        todo.append("create table nodes (id_node int,lat real,lon real)")
        todo.append("create table nodes_tags (id_node int, key text,value text)")
        todo.append("create table ways (id_way int)")
        todo.append("create table ways_tags (id_way int,key text,value text)")
        todo.append("create table ways_nodes (id_way int,id_node int,indice int)")
        todo.append("create table relations (id_rel int)")
        todo.append("create table relations_tags (id_rel int,key text,value text)")
        todo.append("create table members (id_rel int,type text,ref int,role text)")
        todo.append("create table velibs (id_station,lat real,lon real,label text)")

        todo.append("create index nodes_idx on nodes (id_node)")
        todo.append("create index nodes_tags_idx on nodes_tags (id_node)")
        todo.append("create index ways_idx on ways (id_way)")
        todo.append("create index ways_nodes_idx on ways_nodes (id_way,indice)")
        todo.append("create index nodes_ways_idx on ways_nodes (id_node)")
        todo.append("create index ways_tags_idx on ways_tags (id_way)")
        todo.append("create index velibs_latlon_idx on velibs (lat,lon)")
        todo.append("create index velibs_id_idx on velibs (id_station)")

        
        for snt in todo:
            print snt
            self.dbCursor.execute(snt)

        self.dbConnector.commit()

    def get_subboxes_list(self):
        out=[]
        cur_bottom=self.lat_min
        stp=self.ENCLOSE_DEGREE_STEP
        
        print 'bootom_max=',self.lat_max
        print 'left_max=',self.lon_max

        while cur_bottom<self.lat_max:
            cur_left=self.lon_min
            while cur_left<self.lon_max:
                out.append([cur_left,cur_bottom,cur_left+stp,cur_bottom+stp])
                cur_left+=stp
            cur_bottom+=stp
        
        return(out)

    def download_box(self,left,bottom,right,top,name):
        url="http://api.openstreetmap.org/api/0.5/map?bbox=%s,%s,%s,%s"%(left,bottom,right,top)
        print "name",name
        print "Let s download url"
        print url
        filename=self.cache+"/"+name
        urlretrieve(url,filename)

    def download_all_boxes(self):
        cnt=1
        for cur in self.get_subboxes_list():
            print cur
            (left,bottom,right,top)=cur
            self.download_box(left,bottom,right,top,"%s.xml"%cnt)
            cnt+=1

        return cnt

    def parse_file(self,filename):
        print "parsing file '%s'"%filename
        parser=OsmParser(filename)

        for node_id in parser.nodes:
            cur_node=parser.nodes[node_id]
            snt="select count(*) from nodes where id_node=?"
            self.dbCursor.execute(snt,(node_id,))
            res=self.dbCursor.fetchone()[0]
            if not res:
                #print "inserting node"
                snt="insert into nodes (id_node,lat,lon) values (?,?,?)"
                self.dbCursor.execute(snt,(node_id,cur_node.lat,cur_node.lon))
        
                for k in cur_node.tags:
                    snt="insert into nodes_tags (id_node,key,value) values "
                    snt+="(?,?,?)"
                    self.dbCursor.execute(snt,(node_id,k,cur_node.tags[k]))
        
        for way_id in parser.ways:
            cur_way=parser.ways[way_id]
            snt="select count(*) from ways where id_way=?"
            self.dbCursor.execute(snt,(way_id,))
            res=self.dbCursor.fetchone()[0]

            if not res:
                snt="insert into ways (id_way) values (?)"
                self.dbCursor.execute(snt,(way_id,))
                for k in cur_way.tags:
                    snt="insert into ways_tags (id_way,key,value) values "
                    snt+="(?,?,?)"
                    self.dbCursor.execute(snt,(way_id,k,cur_way.tags[k]))

                indice_cnt=0
                for node_id in cur_way.nodes:
                    snt="insert into ways_nodes (id_way,id_node,indice) values (?,?,?)"
                    self.dbCursor.execute(snt,(way_id,node_id,indice_cnt))
                    indice_cnt+=1

        for rel_id in parser.relations:
            cur_rel=parser.relations[rel_id]
            snt="select count(*) from relations where id_rel=?"
            self.dbCursor.execute(snt,(rel_id,))
            res=self.dbCursor.fetchone()[0]

            if not res:            
                snt="insert into relations (id_rel) values (?)"
                self.dbCursor.execute(snt,(rel_id,))

                for k in cur_rel.tags:
                    snt="insert into relations_tags (id_rel,key,value) values "
                    snt+="(?,?,?)"
                    self.dbCursor.execute(snt,(rel_id,k,cur_rel.tags[k]))
                
                for cur_member in cur_rel.members:
                    type=cur_member.type
                    ref=cur_member.ref
                    role=cur_member.role
                    snt="insert into members (id_rel,type,ref,role) values "
                    snt+="(?,?,?,?)"
                    self.dbCursor.execute(snt,(rel_id,type,ref,role))

        self.dbConnector.commit()

                  
                                      

db_path="osm.db"
#feeder=OsmSqliteFeeder(db_location=db_path)
feeder=OsmSqliteFeeder(db_location="./osm.db",\
                     lat_min=48.81183,\
                     lat_max=48.90388,\
                     lon_min=2.23657,\
                     lon_max=2.42987,\
                     cache="./cache")
#cnt=feeder.download_all_boxes()
cnt=28
print "cnt=",cnt
for i in range(0,cnt):
    n=i+1
    feeder.parse_file("./cache/%s.xml"%i)

