#!/usr/bin/python
import sys
import os
sys.path.append("../src")
import tilenames as tn
from urllib import *


tiles_path="/home/melmoth/dev/tiles"
zoom_levels=[17]
lat_min=48.81183
lat_max=48.90388
lon_min=2.23657
lon_max=2.42987

def download_tiles_for_zoom(z):
    print "Zoom %s"%z
    base_dir=tiles_path+"/%s"%z
    if not os.path.isdir(base_dir):
        os.makedirs(base_dir)
    (min_x,max_y)=tn.tileXY(lat_min, lon_min, z)
    (max_x,min_y)=tn.tileXY(lat_max,lon_max,z)
    
    print min_y,max_y

    x=min_x

    while x<=max_x:
        y=min_y
        while y<=max_y:
            url=tn.tileURL(x,y,z,'mapnik')
            if not os.path.isdir(base_dir+"/%s"%x):
                os.makedirs(base_dir+"/%s"%x)

            filename=base_dir+"/%s/%s.png"%(x,y)
            if os.path.isfile(filename):
                print "already got",filename
                y+=1
                continue
            #print "Downloading %s\n  from %s" % (filename, url)
            try:
                urlretrieve(url, filename)
                #print "Done"
            except:
                print "Error downloading " + filename
                os.unlink(filename)






            print url
            y+=1
            
        x+=1
            

                         
for i in zoom_levels:
    download_tiles_for_zoom(i)
