#!/usr/bin/python
# -*- coding: utf-8 -*-
from sayhooGlobals import *
import math
import threading
import sys 

try:
    import sqlite3
except:
    from pysqlite2 import dbapi2 as sqlite3



class Node:
    def __init__(self,id_node=False,lat=False,lon=False):
        self.id_node=id_node
        self.lat=float(lat)
        self.lon=float(lon)
        #self.tags=tags
        #self.ways=ways

    def calculate_nautical_distance(self,another_node):
        lat1=self.lat
        lon1=self.lon
        lat2=another_node.lat
        lon2=another_node.lon
        dlat = lat2 - lat1
        dlon = lon2 - lon1
        slat = math.sin(dlat / 2.0)
        slon = math.sin(dlon / 2.0)
        a = (slat * slat) + (math.cos(lat1) * math.cos(lat2) * slon * slon)
        return ((2.0 * math.atan2(math.sqrt(a), math.sqrt(1.0 - a))) * EARTH_RADIUS)

    def deg2rad(self,deg):
        return deg2rad(deg)

    def rad2deg(self,rad):
        return rad2deg(rad)

    def nauticalmiles2meter(self,d):
        return d*1852.0

    def calculate_metric_distance(self,another_node):
        """
        print "distanc for:"
        self.print_summary()
        print "to"
        """
        nautical=self.calculate_nautical_distance(another_node)
        #print "nautical",nautical
        meters=self.nauticalmiles2meter(nautical)
        #print "meters=",meters
        return meters

    """
     Let's assume the earth is flat to make things easier.
     It's not like Paris is large enough to be curved...
     We just assume lat and lon are regular coordinate.
    """
    def calculate_simple_distance(self,another_node):
        lat1=self.lat
        lon1=self.lon
        lat2=another_node.lat
        lon2=another_node.lon
        dlat=lat1-lat2
        dlon=lon1-lon2
        return(math.sqrt(dlat*dlat + dlon*dlon))

    """
    Calculate the bearing between the current node and 
    another one.
    """
    def calculate_bearing(self,another_node):
        lat1=self.lat
        lon1=self.lon
        lat2=another_node.lat
        lon2=another_node.lon
        dlon = deg2rad(lon2 - lon1)
        lat1 = deg2rad(lat1)
        lat2 = deg2rad(lat2)

        y = math.sin(dlon) * math.cos(lat2)
        x = (math.cos(lat1) * math.sin(lat2)) - \
            (math.sin(lat1) * math.cos(lat2) * math.cos(dlon))
        dlon = rad2deg(math.atan2(y, x))
        if dlon < 0.0:
            dlon += 360.0
        return float(dlon)

    def print_summary(self):
        print "Node id=%s (%s,%s)"%(self.id_node,self.lat,self.lon)
        for k in self.tags:
            print k,self.tags[k].encode("utf8")


class Way:
    #routeTypes = ('cycle','car','train','foot','horse')
    routeTypes = ('cycle','car')

    def __init__(self,id_way=False,nodes=[],tags={}):
        self.id_way=id_way
        self.nodes=nodes
        self.tags={}
        self.access={}
        self.is_reversible=True

        if len(tags.keys()):
            self.set_tags(tags)

    def set_tags(self,tags):
        self.tags=tags
        highway=self.equivalent(self.tags.get('highway', ''))
        railway=self.equivalent(self.tags.get('railway', ''))
        oneway=self.tags.get('oneway', '')

        self.is_reversible=not oneway in('yes','true','1')
        self.access['cycle'] = highway in ('primary','secondary','tertiary','unclassified','minor','cycleway','residential', 'track','service')
        self.access['car'] = highway in ('motorway','trunk','primary','secondary','tertiary','unclassified','minor','residential', 'service')
        self.access['train'] = railway in('rail','light_rail','subway')
        self.access['foot'] = self.access['cycle'] or highway in('footway','steps')
        self.access['horse'] = highway in ('track','unclassified','bridleway')
        

    def equivalent(self,tag):
        """Simplifies a bunch of tags to nearly-equivalent ones"""
        equivalent = { \
            "primary_link":"primary",
            "trunk":"primary",
            "trunk_link":"primary",
            "secondary_link":"secondary",
            "tertiary":"secondary",
            "tertiary_link":"secondary",
            "residential":"unclassified",
            "minor":"unclassified",
            "steps":"footway",
            "driveway":"service",
            "pedestrian":"footway",
            "bridleway":"cycleway",
            "track":"cycleway",
            "arcade":"footway",
            "canal":"river",
            "riverbank":"river",
            "lake":"river",
            "light_rail":"railway"
            }  
        try:
            return(equivalent[tag])
        except KeyError:
            return(tag)

    def print_summary(self):
        print "Way Summary:%s"%self.id_way
        ak=self.tags.keys()
        ak.sort()
        #print "is_reversible",self.is_reversible
        #print "access",self.access
        for k in ak:
            print k+":",self.tags[k].encode('utf8')
        
        print "Nodes:",self.nodes
        print "__"

class MapArea:
    """
    This is supposed to be equivalent to the LoadOsm class in pyroute.
    """
    def __init__(self,center_node,max_distance,nodes={},ways={}):
        self.center=center_node
        self.max_distance=max_distance
        self.nodes=nodes
        self.ways=ways

        #store edges's weight
        self.routing={}
        #store node usable per type of roads
        self.routeableNodes={}
        self.velib_stations=[]

    def print_summary(self):
        print "Map Area: ",self.center.lat,self.center.lon,self.max_distance
        #nearest=Node(self.nearest_node_id,self.db)
        print "________Nodes___________"
        for i in self.nodes.keys():
            self.nodes[i].print_summary()

        
        print "_______Ways_____________"
        for i in self.ways.keys():
            print "**"
            self.ways[i].print_summary()
        

        
        print "_______Routing_________"
        for i in self.routing:
            print "__"
            print i
            print self.routing[i]
        

    def find_nearest_node_for(self,lat,lon):
        min=9999999999999999999999
        out=False
        target=Node(lat=lat,lon=lon)
        for nid in self.nodes:
            cur_node_dic=self.nodes[nid]
            cur_node=Node(id_node=nid,lat=cur_node_dic["lat"],lon=cur_node_dic['lon'])
            dist=cur_node.calculate_metric_distance(target)
            if dist<min:
                #print "New dist",dist
                min=dist
                out=nid
        return out
            
            
class MapAreaCreator:
    def __init__(self,db_location=""):
        self.db_location=db_location
        self.maparea=False
        
    def prepare_area_for(self,lat,lon,max_distance):
        print "we got to prepare_area_for ",lat,lon,max_distance
        print "lat=%s lon=%s"%(lat,lon)
        db=sqlite3.connect(self.db_location)
        cursor=db.cursor()

        real_center=Node(lat=lat,lon=lon)
        self.maparea=MapArea(center_node=real_center,max_distance=max_distance)
        
        """
            Getting the list of nodes in the area.
            We do not store them yet, it s just to get 
            a list of ways in the area (the area will get all the
            nodes of all the ways, even if the node is far away.
        """
        print "getting first list of nodes"
        nodes_id=[]
        snt="select id_node,lat,lon from nodes order by (($LAT-lat)*($LAT-lat)+($LON-lon)*($LON-lon))"
        cursor.execute(snt,(lat,lon))
        for sql_info in cursor.fetchall():
            tmpNode=Node(id_node=sql_info[0],lat=sql_info[1],lon=sql_info[2])

            if max_distance>0:
                if tmpNode.calculate_metric_distance(real_center)<max_distance:
                    nodes_id.append(sql_info[0])
                else:
                    break
            else:
                nodes_id.append(sql_info[0])

        """
             Getting a list of ways based on the nodes in view.
        """
        print "getting list of ways"
        ways_id_list=[]
        for cur_node_id in nodes_id:
            tags={}
            snt="select id_way from ways_nodes where id_node=?"
            cursor.execute(snt,(cur_node_id,))
            for line in cursor.fetchall():
                if line[0] not in ways_id_list:
                    ways_id_list.append(line[0])
                                        
        """
            Now that we have a list of ways in view, lets fill data.
        """
        print "filling ways data"
        for cur_way_id in ways_id_list:
            nodes_in_way=[]
            tags_in_way={}
            snt="select key,value from ways_tags where id_way=? and key in ('highway','name','oneway','foot','bicyle','cycleway','cycycleway')"
            cursor.execute(snt,(cur_way_id,))
            for line in cursor.fetchall():
                key=line[0]
                value=line[1]
                tags_in_way[key]=value
            
            snt="select id_node,indice from ways_nodes where id_way=? order by indice"
            cursor.execute(snt,(cur_way_id,))

            lines=cursor.fetchall()
            for line in lines:
                id_node=line[0]
                nodes_in_way.append(id_node)
                if id_node not in nodes_id:
                    nodes_id.append(id_node)
            
            curWay=Way(id_way=cur_way_id,nodes=nodes_in_way,tags=tags_in_way)
            self.maparea.ways[cur_way_id]=curWay

        print "filling nodes data"
        for id_node in nodes_id:
            snt="select lat,lon from nodes where id_node=?"
            cursor.execute(snt,(id_node,))
            line=cursor.fetchone()
            curNode=Node(id_node=id_node,lat=line[0],lon=line[1])
            tags={}
            """
            snt="select key,value from nodes_tags where id_node=?"
            cursor.execute(snt,(id_node,))
            lines=cursor.fetchall()
            for line in lines:
                tags[line[0]]=line[1]
            """
            
            self.maparea.nodes[id_node]=curNode

        """Computing edges"""
        for routeType in Way.routeTypes:
            self.maparea.routing[routeType]={}
            self.maparea.routeableNodes[routeType]={}

        print "computing edges"
        for cur_way_id in self.maparea.ways:
            w=self.maparea.ways[cur_way_id]
            
            highway=w.equivalent(w.tags.get('highway', ''))
            railway=w.equivalent(w.tags.get('railway', ''))
            last=-1
            for node_id in w.nodes:
                if last != -1:
                    for routeType in Way.routeTypes:
#                        if(w.access[routeType]):
                        if(w.access.get(routeType)):
                            if highway:
                                weight=self.getWeight(routeType,highway)
                            elif railway:
                                weight=self.getWeight(routeType,railway)
                            if not weight:
                                #w.print_summary()
                                print "zut"
                                print w.access
                                print last,node_id,routeType,weight
                                weight=0
                                #sys.exit()
                                
                            self.add_link(last,node_id,routeType,weight)
                            if w.is_reversible or routeType=='foot':
                                self.add_link(node_id,last,routeType,weight)
                last=node_id            


        print "map area is done"
        
        """
        #Adding velib station.
        snt="select id_station,lat,lon from velibs order by (($LAT-lat)*($LAT-lat)+($LON-lon)*($LON-lon))"        
        cursor.execute(snt,(self.maparea.center.lat,self.maparea.center.lat))
        for line in cursor.fetchall():
            vlat=line[0]
            vlon=line[1]
            tmpNode=Node(lat=vlat,lon=vlon)
            if tmpNode.calculate_metric_distance(self.maparea.center)<max_distance:
                self.maparea.velib_stations.append({"lat":vlat,"lon":vlon})
            else:
                break
        """
        #print "end of preapre_area"
        #print self.maparea.nodes

    def getWeight(self,transport,wayType):
        #print "getWeight transport=%s wayType=%s"%(transport,wayType)
        Weightings = { \
            'motorway': {'car':10},
            'trunk':    {'car':10, 'cycle':0.05},
            'primary':  {'cycle': 0.3, 'car':2, 'foot':1, 'horse':0.1},
            'secondary': {'cycle': 1, 'car':1.5, 'foot':1, 'horse':0.2},
            'tertiary': {'cycle': 1, 'car':1, 'foot':1, 'horse':0.3},
            'unclassified': {'cycle': 1, 'car':1, 'foot':1, 'horse':1},
            'minor': {'cycle': 1, 'car':1, 'foot':1, 'horse':1},
            'cycleway': {'cycle': 3, 'foot':0.2},
            'residential': {'cycle': 3, 'car':0.7, 'foot':1, 'horse':1},
            'track': {'cycle': 1, 'car':1, 'foot':1, 'horse':1, 'mtb':3},
            'service': {'cycle': 1, 'car':1, 'foot':1, 'horse':1},
            'bridleway': {'cycle': 0.8, 'foot':1, 'horse':10, 'mtb':3},
            'footway': {'cycle': 0.2, 'foot':1},
            'steps': {'foot':1, 'cycle':0.3},
            'rail':{'train':1},
            'light_rail':{'train':1},
            'subway':{'train':1}
            }

        try:
            return(Weightings[wayType][transport])
        except KeyError:
            # Default: if no weighting is defined, then assume it can't be routed
            return(0)

    def add_link(self,fr,to,routeType,weight=1):
        """Add a routeable edge to the scenario"""
        self.maparea.routeableNodes[routeType][fr]=True
        try:
            if to in self.maparea.routing[routeType][fr].keys():
                return
            self.maparea.routing[routeType][fr][to]= weight
        except KeyError:
            self.maparea.routing[routeType][fr]={to:weight}

        return True



class Router:
    def __init__(self,map_area):
        self.map_area=map_area
        self.search_end=False
        self.queue = []

    def do_route(self,start_id,end_id,transport):
        #self.search_end=Node(end_id,self.map_area.db)
        search_end_dic=self.map_area.nodes[end_id]
        search_end=Node(id_node=end_id,lat=search_end_dic['lat'],lon=search_end_dic['lon'])
        self.search_end=search_end
        print "end is found"
        closed=[start_id]
        self.queue = []

        blankQueueItem = {'end':-1,'distance':0,'nodes':str(start_id)}
        try:
            for i,weight in self.map_area.routing[transport][start_id].items():
                self.add_to_queue(start_id,i, blankQueueItem, weight)
        except KeyError:
            return("no such node",[])

        count=0
        while count<10000:
            count+=1
            try:
                #print "queue=",self.queue
                next_item=self.queue.pop(0)
            except IndexError:
                return("no_route",[])
            #print "next_item",next_item
            x = next_item['end']
            if x in closed:
                continue
            if x == end_id:
                route_nodes=[int(i) for i in next_item['nodes'].split(",")]
                return('success',route_nodes)
            closed.append(x)
            try:
                for i,weight in self.map_area.routing[transport][x].items():
                    if not i in closed:
                        self.add_to_queue(x,i,next_item,weight)
            except KeyError:
                pass
        else:
            return('gave_up',[])

    def add_to_queue(self,start_id,end_id,cur_queue,weight=1):
        for test in self.queue:
            if test['end'] == end_id:
                return
        
        if(weight==0):
            return

        start_node_dic=self.map_area.nodes[start_id]
        end_node_dic=self.map_area.nodes[end_id]

        start_node=Node(id_node=start_id,lat=start_node_dic['lat'],lon=start_node_dic['lon'])
        end_node=Node(id_node=end_id,lat=end_node_dic['lat'],lon=end_node_dic['lon'])

        distance=start_node.calculate_simple_distance(end_node)
        distance=distance/weight

        cur_distance=cur_queue['distance']
        queueItem = { \
            'distance': cur_distance + distance,
            'maxdistance': cur_distance + end_node.calculate_simple_distance(self.search_end),
            'nodes': cur_queue['nodes'] + "," + str(end_id),
            'end': end_id}

        count=0
        for test in self.queue:
            if test['maxdistance']> queueItem['maxdistance']:
                self.queue.insert(count,queueItem)
                break
            count+=1
        else:
            self.queue.append(queueItem)

        

"""
a=MapAreaCreator(db_location)
a.prepare_area_for(lat=48.8407481,lon=2.4024637,max_distance=40000)
router=Router(a.maparea)
#router.do_route(243896275,243896275,"cycle")
print "route",router.do_route(159666147,246650874,'cycle')
"""

class sayhooRouter(threading.Thread):

    def __init__(self,qq_to_router,qq_from_router):
        self.qq_from_controller=qq_to_router
        self.qq_to_controller=qq_from_router
        threading.Thread.__init__(self,name="main routeur thread")
        self.map_creator=False
        self.last_map_area=False
        self.destination_node_id=0
        self.destination_lat=0
        self.destination_lon=0
        self.start_point_node_id=0
        self.start_point_lat=0
        self.start_point_lon=0
        self.last_position=False
        self.transport_type="cycle"

        self.gps_signal=False
        self.running=True
        self.start()

    def pull_request(self):
        out=[]
        while self.qq_from_controller.qsize():
            try:
                curEvent=self.qq_from_controller.get(0)
                #print "sayhooRouter curEvent=",curEvent
            except:
                raise
            out.append(curEvent)

        return out

    def new_start_point_set(self,req):
        #print "new starting point:"
        #print req.args
        lat=float(req.args['lat'])
        lon=float(req.args['lon'])
        self.start_point_lat=lat
        self.start_point_lon=lon


        db=sqlite3.connect(db_location)
        cursor=db.cursor()

        snt="select id_node,lat,lon from nodes order by (($LAT-lat)*($LAT-lat)+($LON-lon)*($LON-lon)) limit 100"
        cursor.execute(snt,(lat,lon))
        db_nodes=[]
        start_id_flag=False
        start_lat=0
        start_lon=0

        for line in cursor.fetchall():
            cur_id=line[0]

            if cur_id in self.map_creator.maparea.routing[self.transport_type]:
                start_id_flag=True
                self.start_point_node_id=cur_id
                self.start_point_lat=line[1]
                self.start_point_lon=line[2]
                break
        db.close()

        if not start_id_flag:
            print "No routable node near the starting point lat=%s,lon=%s"%(lat,lon)
            return 

        backToGui=Node(id_node=self.start_point_node_id,lat=self.start_point_lat,lon=self.start_point_lon)
        event=MapAnswer(args={"type":"new-start-node"},answer=backToGui)
        self.qq_to_controller.put(event)


        if self.destination_node_id:
            print "In sayhoo router, we got a starting point. destination is known: got to make map"
            self.prepare_map_area()
            #self.prepare_locale_view()
        else:
            print "We got a new starting point but there is no destination set: no map making"


            


    def new_destination_set(self,req):
        db=sqlite3.connect(db_location)
        cursor=db.cursor()
        lat=req.args['lat']
        lon=req.args['lon']


        snt="select id_node,lat,lon from nodes order by (($LAT-lat)*($LAT-lat)+($LON-lon)*($LON-lon)) limit 100"
        cursor.execute(snt,(lat,lon))
        db_nodes=[]
        dest_id_flag=False
        for line in cursor.fetchall():
            cur_id=line[0]
            if cur_id in self.map_creator.maparea.routing[self.transport_type]:
                dest_id_flag=True
                self.destination_lat=line[1]
                self.destination_lon=line[2]
                self.destination_node_id=cur_id
                break
        #cursor.close()

        #self.destination_lat=lat
        #self.destination_lon=lon
        #line=cursor.fetchone()
        #self.destination_node_id=line[0]
        #destination_lat=line[1]
        #destination_lon=line[2]
        db.close()
        if dest_id_flag:
            print "New destination is node ID#%s"%self.destination_node_id
            print "select * from ways_tags where id_way in (select id_way from ways_nodes where id_node=%s);"%self.destination_node_id

            backToGui=Node(id_node=self.destination_node_id,lat=self.destination_lat,lon=self.destination_lon)
            event=MapAnswer(args={"type":"new-destination-node"},answer=backToGui)
            self.qq_to_controller.put(event)
        else:
            print "No routeable destination for lat=%s,lon=%s"%(lat,lon)

        if self.start_point_node_id:
            print "In sayhoo router, we got a destination. start point exist: got to make map"
            self.prepare_map_area()
        else:
            print "New destination is set, but no starting point"
            
    def new_gps_event(self,req):
        print "sayhooRouter new gps event receied"
        

    def prepare_map_area(self):
        print "Let's prepare a map area"
        event=MapRequest(args={"type":"map-computing","computing":True})
        self.qq_to_controller.put(event)

        dest=Node(lat=self.destination_lat,lon=self.destination_lon)
        startp=Node(lat=self.start_point_lat,lon=self.start_point_lon)
        #distance=dest.calculate_metric_distance()
        #clat=curpos.lat+(dest.lat-curpos.lat)/2
        #clon=curpos.lon+(dest.lon-curpos.lon)/2


        #range=distance
        #range_step=3
        #while range_step<16:
        #print "Trying to find a route with range_step=%s"%range_step
        #print "distance=",distance
        #range=distance*range_step
        #print "range=",range

        self.last_map_area=self.map_creator.maparea

        known_cur_node_id=self.start_point_node_id
        destination_node_id=self.last_map_area.find_nearest_node_for(dest.lat,dest.lon)

        #print "what shall we do now with this map area ?"
        router=Router(self.last_map_area)
        c=self.last_map_area.nodes[known_cur_node_id]
        d=self.last_map_area.nodes[destination_node_id]
        #print "from"
        #c.print_summary()
        #print "to"
        #d.print_summary()
        print "from %s to %s"%(known_cur_node_id,destination_node_id)
        route=router.do_route(known_cur_node_id,destination_node_id,self.transport_type)
        #print "route=",route
        if route[0]=="success":
            ids=route[1]
            out=[]
            for i in ids:
                a=self.last_map_area.nodes[i]
                out.append(a)
            event=MapAnswer(args={"type":"route-found"},answer=out)
            self.qq_to_controller.put(event)
            return
        else:
            print "no route found:",route[0]

            #range_step+=2
            
        print "DON'T PANIC: you are lost !" 
        
    def run(self):
        import time
        import cPickle
        
        self.map_creator=MapAreaCreator(db_location)

        before=time.time()
        if os.path.isdir(pickle_jar):
            #print "unpickling stuff"
            #pkl_file = open(pickle_jar, 'rb')
            #maparea=cPickle.load(pkl_file)
            #self.map_creator.maparea=maparea
            #pkl_file.close()
            center=Node(lat=0,lon=0)
            maparea=MapArea(center_node=center,max_distance=0)

            print "getting nodes"
            pkl_file = open(pickle_jar+"/nodes.bin", 'rb')
            cur_nodes=cPickle.load(pkl_file)
            pkl_file.close()

            print "getting ways"
            pkl_file = open(pickle_jar+"/ways.bin", 'rb')
            maparea.ways=cPickle.load(pkl_file)
            pkl_file.close()
            
            print "getting routing"
            pkl_file = open(pickle_jar+"/routing.bin", 'rb')
            maparea.routing=cPickle.load(pkl_file)
            pkl_file.close()
            
            print "getting routeablesNodes"
            pkl_file = open(pickle_jar+"/routeableNodes.bin", 'rb')
            maparea.routeableNodes=cPickle.load(pkl_file)
            pkl_file.close()

            
            #for nid in cur_nodes:
            #    cur_node=Node(id_node=nid,lat=cur_nodes[nid]["lat"],lon=cur_nodes[nid]["lon"])
            #    maparea.nodes[nid]=cur_node
            maparea.nodes=cur_nodes    
            self.map_creator.maparea=maparea
            #self.last_map_area=maparea
	    maparea=False
        else:
            print "pickled data not ready: %s!"%pickle_jar
            sys.exit()
            #output = open(pickle_jar, 'wb')
            #self.map_creator.prepare_area_for(lat=start_view_lat,lon=start_view_lon,max_distance=0)
            #map=self.map_creator.maparea
            #print "Done not pickled yet"
            #now=time.time()
            #tmp=now-before
            #print "done in ",tmp
            
            #cPickle.dump(map, output)
            #output.close()
            
        after=time.time()

        spent=after-before
        print "it took %s"%spent

        event=MapRequest(args={"type":"map-computing","computing":False})
        self.qq_to_controller.put(event)
        
        while self.running:
            for req in self.pull_request():
                if isinstance(req,MapRequest):
                    """
                    if req.args["type"]=="new_mapview_dimention":
                        #self.new_mapview_dimention(width=req.args['width'],height=req.args['height'],zoom=req.args['zoom'])
                        print "sayhoorooter has nothing to do with new_mapview_dimention anymore"
                    """ 
                    if req.args["type"]=="new_destination":
                        self.new_destination_set(req)
                    
                    if req.args['type']=='new_start_point':
                        #print "In sayhooMap: got new start point"
                        #print req.args
                        self.new_start_point_set(req)


                if isinstance(req,GpsEvent):
                    self.new_gps_event(req)

                if isinstance(req,StopEvent):
                    self.running=False
                    print "Map says bye bye"
                
            time.sleep(.1)





        

