#!/usr/bin/python2.5
import gtk
import gtk.glade
from sayhooGlobals import _
from sayhooGlobals import *
import sayhooMap
import tilenames as tn
if is_maemo():
    import hildon
    superClass=hildon.Program
else:
    class FakeClass:
        def __init__(self):
            return 

    superClass=FakeClass

import pango
import gobject
import re
import math

class SayhooGui(superClass):
    
    def __init__(self,qq_to_gui,qq_from_gui):
        self.fullScreen=False
        self.qq_from_controller=qq_to_gui
        self.qq_to_controller=qq_from_gui
        
        if is_maemo():
            self.program=hildon.Program()
            self.program.__init__()
            self.hildon_window = hildon.Window()
        else:
            self.hildon_window=gtk.Window()

        gladefile=glade_file_location


        self.hildon_window.connect("destroy",self.end_application)

        self.timeoutHandler=gobject.timeout_add(1000,self.monitor_controller_qq)
        self.hildon_window.connect("key-press-event",self.on_key_press)

        self.velib_stations=[]
        self.route=[]
        self.start_node=False
        self.destination_node=False
        self.start_node_query=False
        self.destination_node_query=False

        self.last_position=False
        self.gps_signal=False


        """
        ####################################################################
                                   Main Window
        ####################################################################
        """
        self.main_xml=gtk.glade.XML(gladefile,"mainWindow")
        self.vbox1=self.main_xml.get_widget("vbox1")
        self.vbox1.reparent(self.hildon_window)
        self.seconds_timer_label=self.main_xml.get_widget("timerLabel")
        self.seconds_timer_label.modify_font(pango.FontDescription("sans 24"))
        self.seconds_timer_label.set_text("0:00")
        self.main_start_stop_button=self.main_xml.get_widget("mainStartStopB")
        self.main_start_stop_button_label=self.main_start_stop_button.\
                                           child
        self.main_start_stop_button_label.set_text(_("Start"))
        self.main_reset_timer_button=self.main_xml.get_widget(\
            "mainResetTimerB")
        self.main_reset_timer_label=self.main_reset_timer_button.child
        self.main_reset_timer_label.set_text(_("Reset timer."))

        self.main_map_status_icon=self.main_xml.get_widget("mapStatus_i")
        print "status_icon=",self.main_map_status_icon
        self.go_icon="/usr/share/sayhoo/data/start.png"
        self.wait_icon="/usr/share/sayhoo/data/stop.png"
        self.waiting_for_map=True
        self.wait_for_map(True)
        

        self.main_xml.get_widget("mainWindow").destroy()
        main_dic = { 
            "on_mainStartStopB_clicked":self.start_b_clicked,
            "on_mainResetTimerB_clicked":self.reset_timer_b_clicked,
            "on_mapview_expose_event":self.mapview_expose_event,
            "on_mapview_size_allocate":self.mapview_size_allocate,
            "on_mapview_button_press_event":self.mapview_button_press_event,
            "on_mapview_button_release_event":self.mapview_button_release_event
               
                     }
        self.main_xml.signal_autoconnect(main_dic)

        self.mapview=self.main_xml.get_widget("mapview")        
        self.mapview.set_events(gtk.gdk.BUTTON_PRESS_MASK
                                |gtk.gdk.BUTTON_RELEASE_MASK    
                                )
        self.mapview_width=0
        self.mapview_height=0
        self.mapview_zoom=15
        self.mapview_center_lat=start_view_lat
        self.mapview_center_lon=start_view_lon
        self.mapview_button_pressed=False
        self.mapview_mouse={"x":0,"y":0}
        

        """
        https://garage.maemo.org/plugins/wiki/index.php?TapAndHold&id=40&type=g
        https://garage.maemo.org/svn/pymaemo/packages/pygtk/trunk/examples/tap/tap_example.py
        """
        self.mapview_m_xml=gtk.glade.XML(gladefile,"mapview_m")
        self.mapview_m=self.mapview_m_xml.get_widget('mapview_m')
        if is_maemo():
            self.mapview.tap_and_hold_setup(menu=self.mapview_m, callback=self.mapview_tap_and_hold)
        else:
            self.hildon_window.resize(600,480)


        self.mapview_m_dic={"on_mapview_m_set_destination_activate":self.mapview_m_set_destination_activate,
                            "on_mapview_m_set_location_activate":self.mapview_m_set_location_activate,
                            "on_mapview_m_set_start_point_activate":self.mapview_m_set_start_point_activate
                            }
        self.mapview_m_xml.signal_autoconnect(self.mapview_m_dic)        

        self.hildon_window.show_all()

        self.mapview_context=self.mapview.window.cairo_create()
        self.route_styles={
            "default":{"w":2,"color":(.8,.8,.8,.5)},
            "train":{"w":1,"color":(.4,.7,.7,.1)},
            "subway":{"w":1,"color":(.4,.7,.7,.1)},
            "footway":{"w":1,"color":(.0,.9,.0,.3)},
            "water":{"w":1,"color":(.0,.0,.9,.2)},
            "route":{"color":(1,0,0,.5)}
            }

        
        #request=GuiRequest(args={"type":"new_velib_destination","id":18})
        #self.qq_to_controller.put(request)
        return


    def start_application(self):
        request=GuiRequest(args={"type":"list_velib_stations"})
        self.qq_to_controller.put(request)

    def end_application(self,widget=False):
        gtk.main_quit()

    def treatAnswer(self,event):
        args=event.args
        answer=event.answer
        if args['type']=='list_velib_stations':
            self.velib_stations=answer
            

    def start_b_clicked(self):
        return

    def reset_timer_b_clicked(self):
        return

    def mapview_expose_event(self,darea,event):
        w=event.area.width
        h=event.area.height
        self.display_tiles(event.area)
        return
    
    def mapview_size_allocate(self,widget,allocation):
        self.mapview_width=allocation.width
        self.mapview_height=allocation.height

    """
    def set_destination(self,id):
        print "We code to code setting destination"

        for i in self.change_dest_data:
            if i[0]==id:
                self.dest_txt.set_label(i[3])

        request=GuiRequest(args={"type":"new_velib_destination","id":id})
        self.qq_to_controller.put(request)
    """

    def mark_dot(self,x,y,r,g,b,a=0,type="square"):
        self.mapview_context.set_source_rgba(r,g,b,a)
        if type=="circle":
            self.mapview_context.arc(x,y,5, 0,2*math.pi)
        else:
            self.mapview_context.rectangle(x-1,y-1,6,6)
        self.mapview_context.fill()


    def latlon2xy_in_tile(self,lat,lon):
        z=self.mapview_zoom
        center_lat=self.mapview_center_lat
        center_lon=self.mapview_center_lon
        #tx,ty are x,y (int) value for the top left corner of the tile containg
        #the point lat,lon
        (tx,ty)=tn.tileXY(center_lat,center_lon,z)
        #cx,cy are x,y, (float) value for the same point within the tile.
        (cx,cy)=tn.latlon2xy(center_lat,center_lon,z)
        x=255*(cx-tx)
        y=255*(cy-ty)
        return (x,y) 


    def globalxy2mapviewxy(self,gx,gy):
        "print not sure about globalxy2mapviewxy"
        (cgx,cgy)=tn.latlon2xy(self.mapview_center_lat,self.mapview_center_lon,self.mapview_zoom)
        diff_x=256*(cgx-gx)
        diff_y=256*(cgy-gy)
        return (self.mapview_width/2-diff_x,self.mapview_height/2-diff_y)

    def mapviewxy2globalsxy(self,mx,my):
        #print "mapview2globalsxy",mx,my
        (center_g_x,center_g_y)=tn.latlon2xy(self.mapview_center_lat, self.mapview_center_lon, self.mapview_zoom)        
        #print "center_g_x,center_g_y",center_g_x,center_g_y
        
        #return (gx,gy)
        
        g_mouse_x_to_mv_c_x=(self.mapview_width/2.0-mx)/256.0
        g_mouse_y_to_mv_c_y=(self.mapview_height/2.0-my)/256.0
        gx=center_g_x-g_mouse_x_to_mv_c_x
        gy=center_g_y-g_mouse_y_to_mv_c_y
        #print "gx,vy=",gx,gy
        return (gx,gy)
        
    def mapview2latlon(self,mx,my):
        (gx,gy)=self.mapviewxy2globalsxy(mx,my)
        (lat,lon)=tn.xy2latlon(gx,gy,self.mapview_zoom)
        #print "lat,lon",lat,lon
        #self.last_position={"lat":lat,"lon":lon,"track":0}
        #self.display_tiles()
        return (lat,lon)

    def display_tiles(self,rectangle=False):
        """
        http://wiki.openstreetmap.org/index.php/Slippy_map_tilenames
        """
        #print self.last_position
        self.mapview_context=self.mapview.window.cairo_create()
        if not rectangle:
            self.mapview_context.rectangle(0,0,self.mapview_width,self.mapview_height)
        else:
            self.mapview_context.rectangle(rectangle.x,rectangle.y,rectangle.width,rectangle.height)

        self.mapview_context.clip()


        #self.mapview_context.rectangle(0,0,self.mapview_width,self.mapview_height)
        #self.mapview_context.clip()

        self.mapview_context.set_source_rgb(0,0,0)
        self.mapview_context.rectangle(0,0,self.mapview_width,self.mapview_height)
        self.mapview_context.fill()
        self.mapview_context.stroke()
        

        #heading=self.last_position["track"]


        
        """

                           offset tile                        
                             oft_x
                          -----------  
                         ._________________________________________
                         |0,0                                     |  |
                         |                                        |  |
                         |                                        |  |  oft_y
                         |                                        |  |
                         |            (ox,oy)                     |  |
                         |           .---------                   | 
                         |           |         |              | lyo 
                         |           |       . | (wc_x,wc_y)  |   |
                         |           |         |                  |
                         |           |         |                  |
                         |            ---------                   |
                         |             lxo                        |
                         |            -------                     |
                         |       local x offset                   |
                         |                                        |
                         |                                        |
                          ________________________________________

                         --------------------
                                  wcx
        

        


          ox+lxo=wc_x
          ox=wc_x-lxo
          
          


        """
        (center_tile_x,center_tile_y)=tn.tileXY(self.mapview_center_lat, self.mapview_center_lon, self.mapview_zoom)        
        wc_x=self.mapview_width/2
        wc_y=self.mapview_height/2

        (lxo,lyo)=self.latlon2xy_in_tile(self.mapview_center_lat,self.mapview_center_lon)
        ox=wc_x-lxo
        oy=wc_y-lyo

        (center_tile_slippy_x,center_tile_slippy_y)=tn.tileXY(self.mapview_center_lat,self.mapview_center_lon,self.mapview_zoom)

        start_tile_wx=ox
        cnt_tile_x=0
        while start_tile_wx>0:
            start_tile_wx-=256
            cnt_tile_x+=1


        start_tile_wy=oy
        cnt_tile_y=0
        while start_tile_wy>0:
            start_tile_wy-=256
            cnt_tile_y+=1
        start_cnt_tile_y=cnt_tile_y
        
        cur_tile_wx=start_tile_wx

        while cur_tile_wx<self.mapview_width:
            cur_slippy_x=center_tile_slippy_x-cnt_tile_x
            cnt_tile_y=start_cnt_tile_y
            cur_tile_wy=start_tile_wy
            
            
            while cur_tile_wy<self.mapview_height:
                cur_slippy_y=center_tile_slippy_y-cnt_tile_y
                filename=tiles_location%(self.mapview_zoom,cur_slippy_x,cur_slippy_y)
                if os.path.isfile(filename):
                    pixa=gtk.gdk.pixbuf_new_from_file(filename)
                    self.mapview_context.set_source_pixbuf(pixa,cur_tile_wx,cur_tile_wy)
                    self.mapview_context.paint()
                    self.mapview_context.stroke()

                cur_tile_wy+=256
                cnt_tile_y-=1
    
            cur_tile_wx+=256
            cnt_tile_x-=1
                

        if len(self.route):
            self.mapview_context.set_source_rgba(1,.843,0,.7)      
            self.mapview_context.set_line_width(10)               
 
            prev_node_dic=self.route[0]
            prev_node=sayhooMap.Node(id_node=prev_node_dic["id_node"],lat=prev_node_dic['lat'],lon=prev_node_dic['lon'])
            for cur_node_dic in self.route[1:]:
                cur_node=sayhooMap.Node(id_node=cur_node_dic["id_node"],lat=cur_node_dic['lat'],lon=cur_node_dic['lon'])
                #print "yo"
                #cur_node.print_summary()
                #self.markLine(prev,cur_node_id,2,2,0)   
                #self.markNode(cur_node_id,3,0,0)        
                (pgx,pgy)=tn.latlon2xy(prev_node.lat,prev_node.lon,self.mapview_zoom)
                (px,py)=self.globalxy2mapviewxy(pgx,pgy)
                (cgx,cgy)=tn.latlon2xy(cur_node.lat,cur_node.lon,self.mapview_zoom)
                (cx,cy)=self.globalxy2mapviewxy(cgx,cgy)
                #print "px,py",px,py
                #print "cx,cy",cx,cy
                self.mapview_context.move_to(px,py)
                self.mapview_context.line_to(cx,cy)
                self.mapview_context.stroke()
                prev_node=cur_node


        for line in self.velib_stations:
            lat=line[1]
            lon=line[2]
            (gx,gy)=tn.latlon2xy(lat,lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0.2,0.2,.2,1)


        #self.mark_dot(wc_x,wc_y,0,1,1,.5)
        if self.destination_node:
            (gx,gy)=tn.latlon2xy(self.destination_node.lat,self.destination_node.lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0,1,0,1)            

        if self.start_node:
            (gx,gy)=tn.latlon2xy(self.start_node.lat,self.start_node.lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0,0,1,1)            
            

        if self.last_position:
            #print "last_poistion=",self.last_position
            lat=self.last_position['lat']
            lon=self.last_position['lon']
            (gx,gy)=tn.latlon2xy(lat,lon,self.mapview_zoom)
            (x,y)=self.globalxy2mapviewxy(gx,gy)
            self.mark_dot(x,y,0,.5,0,1,"circle")            


    def adjust_zoom(self,step):
        if self.mapview_zoom+step<18 and self.mapview_zoom+step>9:
            self.mapview_zoom+=step
            self.display_tiles()


    def on_key_press(self,widget,event):
        if event.keyval ==gtk.keysyms.F6:
            """Full screen key"""
            if self.fullScreen:
                self.hildon_window.unfullscreen()
                self.fullScreen=False
            else:
                self.hildon_window.fullscreen()
                self.fullScreen=True

        zoom_step=1
        if event.keyval == gtk.keysyms.F7:
            self.adjust_zoom(zoom_step)

        if event.keyval ==gtk.keysyms.F8:
            self.adjust_zoom(-zoom_step)

    def mapview_button_press_event(self,widget,event):
        self.mapview_mouse={"x":event.x,"y":event.y}
        if event.button==3:
            self.mapview_m.popup(None,None,None,event.button,event.time)
            



    def mapview_button_release_event(self,widget,event):
        delta_x=(event.x-self.mapview_mouse["x"])/256.0
        delta_y=(event.y-self.mapview_mouse["y"])/256.0
        (cur_x,cur_y)=tn.latlon2xy(self.mapview_center_lat,self.mapview_center_lon,self.mapview_zoom)
        new_x=cur_x-delta_x
        new_y=cur_y-delta_y
        (lat,lon)=tn.xy2latlon(new_x,new_y,self.mapview_zoom)
        self.mapview_center_lat=lat
        self.mapview_center_lon=lon
        self.display_tiles()
        return

    def mapview_tap_and_hold(self,menu,widget):
        req_w, req_h = menu.size_request()        
        top = widget.get_toplevel()

        w_x, w_y = top.window.get_origin()
        point_x, point_y, mods = top.window.get_pointer()
        menu_x = point_x + w_x
        menu_y = point_y + w_y - req_h
        scr_w = widget.get_screen().get_width()

        if (menu_x < w_x):
            menu_x = w_x
        elif (menu_x + req_w) > scr_w:
            menu_x -= ((menu_x + req_w) - scr_w)

        if menu_y < w_y:
                meny_y = w_y

        return menu_x, menu_y, True

    def mapview_m_set_destination_activate(self,menuitem):
        #self.mapview_mouse={"x":event.x,"y":event.y}
        print "destination requested"
        if self.waiting_for_map:
            return
        
        #print "not already waiting for a map"
        #self.destination_node_query=True
        #print "NEw destination_node_queyr",self.destination_node_query
        #if self.start_node_query==True:
        #    print "start node query was true"
        #    self.wait_for_map(True)
        #else:
        #    print "start node query was false", self.start_node_query
            
        mx=self.mapview_mouse['x']
        my=self.mapview_mouse['y']
        (dest_lat,dest_lon)=self.mapview2latlon(mx,my)
        
        request=GuiRequest(args={"type":"new_destination","lat":dest_lat,"lon":dest_lon})
        self.qq_to_controller.put(request)
        print "new dest should be ",dest_lat,dest_lon

    def mapview_m_set_start_point_activate(self,menuitem):
        print "start_ activate"
        if self.waiting_for_map:
            return
        #print "not waiting for map"
        #self.start_node_query=True
        #print "new start_node_query",self.start_node_query
        #if self.destination_node_query==True:
        #    print "we alreadt asked destination"
        #    self.wait_for_map(True)
        #else:
        #    print "we did not alreay asked for destination"

        #print "(sayhoogui) We got a new starting point"
        mx=self.mapview_mouse['x']
        my=self.mapview_mouse['y']
        (lat,lon)=self.mapview2latlon(mx,my)
        arg={"type":"new_start_point","lat":lat,"lon":lon}
        event=GuiRequest(args=arg)
        self.qq_to_controller.put(event)


    def mapview_m_set_location_activate(self,menuitem):
        mx=self.mapview_mouse['x']
        my=self.mapview_mouse['y']
        (lat,lon)=self.mapview2latlon(mx,my)
        print "new location should be",lat,lon
        
        arg={"type":"new_location","lat":lat,"lon":lon,"track":0}
        event=GpsEvent(args=arg)
	print "Putting a new gps event in mapview_m_set_location_activate"
        self.qq_to_controller.put(event)

    def handle_gps_event(self,curEvent):
        print "Gui got new location"
        lat=float(curEvent.args['lat'])
        lon=float(curEvent.args['lon'])
        heading=float(curEvent.args['track'])
        self.last_position={"lat":lat,"lon":lon,"track":heading}
        self.gps_signal=True
        #self.display_tiles()

    def wait_for_map(self,bool):
        self.waiting_for_map=bool
        if bool==True:
            print "icon",self.main_map_status_icon
            self.main_map_status_icon.set_from_file(self.wait_icon)
        else:
            self.main_map_status_icon.set_from_file(self.go_icon)

        
    def monitor_controller_qq(self):
        """gdk-pixbuf-query-loaders | grep gtk20"""
        while self.qq_from_controller.qsize():
            try:
                curEvent=self.qq_from_controller.get(0)
            except:
                raise

            if isinstance(curEvent,StartEvent):
                self.start_application()
                continue
            
            if isinstance(curEvent,GuiAnswer):
                self.treatAnswer(curEvent)
                continue
            
            if isinstance(curEvent,MapAnswer):
                if curEvent.args['type']=="route-found":
                    route=curEvent.answer
                    #print route
                    self.route=route
                    self.display_tiles()
                    #self.start_node_query=False
                    #self.destination_node_query=False
                    #self.start_node=False
                    #self.destination_node=False
                    self.wait_for_map(False)

                if curEvent.args['type']=="new-destination-node":
                    self.destination_node=curEvent.answer


                if curEvent.args['type']=="new-start-node":
                    print "Sayhoogui got a new start node info"
                    print curEvent.answer
                    self.start_node=curEvent.answer


            if isinstance(curEvent,MapRequest):
                if curEvent.args['type']=="map-computing":
                    if curEvent.args['computing']:
                        self.wait_for_map(True)
                    else:
                        self.wait_for_map(False)



            if isinstance(curEvent,GpsEvent):
                if curEvent.args["type"]=="new_location":
                    self.handle_gps_event(curEvent)

        return True
