#!/usr/bin/python2.5
import socket
import threading
from sayhooGlobals import *
import string
import re
"""
http://docs.python.org/lib/socket-example.html
http://www.prasannatech.net/2008/07/socket-programming-tutorial.html
"""

class Console(threading.Thread):
    def __init__(self,qq_to_console,qq_from_console):
        self.qq_from_controller=qq_to_console
        self.qq_to_controller=qq_from_console

        threading.Thread.__init__(self,name="main console thread")
        self.running=True
        #Not using it for a while
        #self.start()



        
        
    def pull_request(self):
        out=[]
        while self.qq_from_controller.qsize():
            try:
                curEvent=self.qq_from_controller.get(0)
            except:
                raise
            out.append(curEvent)
        return out

    def run(self):
        print "tcp running"
        server_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        server_socket.bind(("", 5000))
        server_socket.listen(5)
        self.lat=48.841277
        self.lon=2.400963
        self.heading=0        

        """
        lat=48.84
        lon=2.402
        heading=0
        """
        
        #arg={"type":"new_location","lat":self.lat,"lon":self.lon,"track":self.heading}
        #event=GpsEvent(args=arg)
        #self.qq_to_controller.put(event)





        while(self.running):
            #print "still running"
            requests=self.pull_request()
            #print "requests=",requests
            for ev in requests:
                if isinstance(ev,StopEvent):
                    self.running=False
                    return
            
            import time
            time.sleep(1)
            #print "sayhooConsole not doing anything yet"
            #continue

            client_socket, address = server_socket.accept()
            print "tcp server got a connection from ", address
            client_socket.send("Send a fake gps event: 'lat,lon,heading'.\n")
            client_socket.send("pos 48.8397179,2.4024895,45\n")
            client_socket.send("(or type: n/s/e/w)\n")
            client_socket.send("Send 'Q' or 'q' to quit.\n")
            while True:
                client_socket.send(">")
                data = client_socket.recv(512)
                data=data.rstrip()
                if ( data == 'q' or data == 'Q'):
                    client_socket.close()
                    break;
                print "recieved '%s'"%data
                regPos=re.compile("^pos (\S+),(\S+),(\S+)$")
                regDir=re.compile("^([n|s|e|w])$")
                if regPos.search(data):
                    self.lat=regPos.search(data).group(1)
                    self.lon=regPos.search(data).group(2)
                    heading=regPos.search(data).group(3)
                    client_socket.send("Ok: lat=%s,lon=%s,heading=%s\n"%(self.lat,self.lon,self.heading))
                    arg={"type":"new_location","lat":self.lat,"lon":self.lon,"track":self.heading}
                    event=GpsEvent(args=arg)
                    self.qq_to_controller.put(event)
                elif regDir.search(data):
                    step=.0015
                    dir=regDir.search(data).group(1)
                    print "dir=",dir
                    if dir=="n":
                        self.lat+=step
                    elif dir=="s":
                        self.lat-=step
                    elif dir=="e":
                        self.lon+=step
                    elif dir=="w":
                        self.lon-=step
                    client_socket.send("Ok: lat=%s,lon=%s,heading=%s\n"%(self.lat,self.lon,self.heading))
                    arg={"type":"new_location","lat":self.lat,"lon":self.lon,"track":self.heading}
                    event=GpsEvent(args=arg)
                    self.qq_to_controller.put(event)
                    
                else:
                    client_socket.send("Error. \n")

        print "Not running anymore"
