require 'net/http'
require 'uri'
require 'digest/md5'
require 'rexml/document'
include REXML

class NetServices

	def initialize(rbox)
		@client_id = Digest::MD5.hexdigest(IO.popen("/sbin/ifconfig -a | grep HWaddr | sed 's/  //g' | cut -d' ' -f 4").gets.strip)
		@device_id = 0
		device = IO.popen("uname -n | sed 's/Nokia/Nokia-/g' | sed 's/--/-/g' | cut -d- -f 2").gets
		Process.wait
		if device
			if device.index("770")
				@device_id = 1
			elsif device.downcase.index("n8")
				@device_id = 0
			elsif device.downcase.index("n9")
				@device_id = 2
			else
				@device_id = 3
			end
		end
		@rbox = rbox
	end
	
	def device_id
		return @device_id
	end
	
	def check_for_updates
		data = server_command("check_update")
		if data && data.index("xml")
			doc = Document.new(data)
			version = doc.root.elements["version"].text
			url = doc.root.elements["url"].text
			if version > @rbox.version
				return version, url
			end
			return nil, nil
		end
	end

	def register_nick
		data = server_command("register_nick", {"nick" => @rbox.config["nick"]})
		return data
	end

	def export_game(name, md5, data)
		data = server_command("export_game", {"name" => name, "md5" => md5, "data" => data})
		return data && data.strip.index("OK")
	end

	def import_game(name, executable, filename, md5, dialog = true)
		data = server_command("import_game", {"name" => name, "md5" => md5})
		if !data.index("ERROR")
			names = Array.new
			datas = Array.new
			doc = Document.new(data)
			if doc && doc.root
				doc.root.each_element('//game') do | elem |
				names.push("#{CGI::unescape(elem.elements["name"].text)} (#{CGI::unescape(elem.elements["importer"].text)} for #{CGI::unescape(elem.elements["device"].text)})")
					datas.push(CGI::unescape(elem.elements["data"].text))
				end
				idx = -1
				if names.size > 0
					if dialog
						value, idx = @rbox.dialogs.select_from_list("Select game", "Possible matches. Please select one.", names)
					else
						idx = 0
					end
				else
					return false
				end
				if idx && idx != -1 && idx < datas.size
					config = datas[idx].split("\n")
					if dialog
						if !@rbox.dialogs.confirm("Use imported name?", "Use imported name '#{config[1][1..config[1].length].strip}'?")
							config[1] = "# #{name}"
						end
					end
					config[2] = "##{executable}"
					FileUtils.rm(filename)
					filename = File.join(File.dirname(filename), "#{CGI::escape(config[1][1..config[1].length].strip.downcase.gsub(" ", "_")).gsub("%", "")}.conf")
					f = File.new(filename, "w")
					f.write(config.join("\n"))
					f.close
					if dialog
						@rbox.page(0)
					end
					return true
				end
			end
			return false
		else
			return false
		end
	end

	def download_list(type)
		return server_command("gamelist", "type" => type)	
	end
	
	def statistics
		return server_command("statistics")
	end

	def server_command(command, params = nil)
		query = "&clientid=#{@client_id}&device=#{@device_id}"
		begin
			if params
				params.each_key do | key |
					query += "&#{key}=#{CGI::escape(params[key])}"
				end
			end
			response = fetch("http://#{@rbox.config["address"]}/rbox.php?c=#{command}#{query}")
			return response.body.strip
		rescue Exception => e
			puts e.backtrace.join("\n")
			return nil
		end
	end

	def fetch(uri_str, limit = 10)
		raise ArgumentError, 'HTTP redirect too deep' if limit == 0
		response = Net::HTTP.get_response(URI.parse(uri_str))
		case response
			when Net::HTTPSuccess     then response
			when Net::HTTPRedirection then fetch(response['location'], limit - 1)
		else
			response.error!
		end
	end

end
