require 'hildon'
require 'fileutils'

class Screenshot < Gtk::VBox
	
	def initialize(rbox)
		super
		@rbox = rbox
		@image = Gtk::Image.new
		eb = Gtk::EventBox.new
		eb.modify_bg(Gtk::STATE_NORMAL, Gdk::Color::parse("#000000"))
		eb.add(@image)
		pack_start(eb)
		eb.signal_connect( "button_press_event" ) do | w, e |
			@rbox.page(2)
		end
	end
	
	def load_image(url)
		@image.hide
		Thread.new do
			begin
				anim = Hildon::Banner.show_animation(@rbox, "rbox", "Loading image")
				f = File.new("/tmp/rboxshot", "w+")
				f.write(@rbox.net.fetch(url).body)
				f.close
				pb = Gdk::Pixbuf.new("/tmp/rboxshot", 800, 480)
				@image.pixbuf = pb
				@image.show
				@rbox.page(3)
			rescue Exception => e
				Hildon::Banner.show_information(@rbox, "rbox", "Unable to load the screenshot")
				@rbox.page(2)
			ensure
				anim.hide
				FileUtils.rm("/tmp/rboxshot")
			end
		end
	end
end
