class Dialogs
	
	def initialize(rbox)
		@rbox = rbox
	end

	def select_from_list(title, message, options)
		item = nil
		index = -1
		if options.size > 0
			dialog = Gtk::Dialog.new(title, @rbox, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT, [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT], [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT])
			dialog.vbox.add(Gtk::Label.new(message))
			list = Gtk::ComboBox.new
			options.each do | item |
				list.append_text(item)
			end
			list.set_active(0)
			dialog.vbox.add(list)
			dialog.show_all
			dialog.run do |response|
				case response
				when Gtk::Dialog::RESPONSE_ACCEPT
					item = list.active_text
					index = list.active
				end
				dialog.destroy
			end
		end
		return item, index
	end

	def help(title, helptext)
		dialog = Gtk::Dialog.new(title, @rbox, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT, [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT])
		buffer = Gtk::TextBuffer.new
		helpfile = File.new(helptext)
		buffer.text = helpfile.read
		helpfile.close
		sw = Gtk::ScrolledWindow.new
		helpwidget = Gtk::TextView.new
		helpwidget.set_size_request(500,250)
		helpwidget.editable = false
		helpwidget.cursor_visible = false
		helpwidget.wrap_mode = Gtk::TextTag::WRAP_WORD
		helpwidget.buffer = buffer
		sw.add(helpwidget)
		dialog.vbox.add(sw)
		dialog.show_all
		dialog.run do |response|
			dialog.destroy
		end
	end

	def confirm(title, message)
		b = false
		dialog = Gtk::Dialog.new(title, @rbox, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT, [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT], [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT])
		dialog.vbox.add(Gtk::Label.new(message))
		dialog.show_all
		dialog.run do |response|
		  case response
		    when Gtk::Dialog::RESPONSE_ACCEPT
			b = true
		  end
		  dialog.destroy
		end
		return b
	end

	def prompt(title, message, fields = [""], values = [""])
		result = Hash.new
		entries = Array.new
		dialog = Gtk::Dialog.new(title, @rbox, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT, [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT], [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT])
		dialog.vbox.add(Gtk::Label.new(message))
		table = Gtk::Table.new(fields.size, 2, true)
		fields.each_with_index do | field, i |
			entry = Gtk::Entry.new
			entry.text = values[i] if values && values[i]
			entries.push(entry)
			if field != ""
				table.attach_defaults(Gtk::Label.new(field),0, 1, i, i + 1)
				table.attach_defaults(entries.last,1, 2, i, i + 1)
			else
				table.attach_defaults(entries.last,0, 2, i, i + 1)
			end

			
		end
		dialog.vbox.add(table)
		dialog.show_all
		dialog.run do |response|
			case response
			when Gtk::Dialog::RESPONSE_ACCEPT
				entries.each_with_index do | entry, i |
					fields[i] = 0 if fields[i].length == 0
					result[fields[i]] = entry.text.strip
				end
			end
			dialog.destroy
		end
		return result.size != 0 ? result : nil
	end
end
