require 'hildon'
require 'dialogs'
require 'cgi'

class Settings < Gtk::Frame
	
	def initialize(label, rbox)
		@keyboards = Hash.new
		@basic_settings = {
			"dosbox" => {
				"machine" => ""
			},
			"sblaster" => {
				"sbtype" => ""
			},
			"cpu" => {
				"cycles" => ""
			},
			"sdl" => {
				"sensitivity" => "",
				"fullscreen" => ""
			},
			"render" => {
				"frameskip" => ""
			}
		}
		@rbox = rbox
		super(label)
		table = Gtk::Table.new(15,15)
		table.set_row_spacings(5)
		table.set_column_spacings(5)
		scrollwindow = Gtk::ScrolledWindow.new
		scrollwindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
		scrollwindow.add_with_viewport(table)
		add(scrollwindow)
		game_name = Gtk::Label.new("Name")
		game_name.max_width_chars = 10
		table.attach_defaults(game_name, 0,1,0,1)
		@executable = Gtk::Entry.new
		@game_name = Gtk::Entry.new
		table.attach_defaults(@game_name, 1,15,0,1)
		executable_label = Gtk::Label.new("Executable")
		executable_label.max_width_chars = 10
		table.attach_defaults(executable_label, 0,1,1,2)
		table.attach_defaults(@executable, 1,14,1,2)
		browse_button = Gtk::Button.new("Browse")
		browse_button.signal_connect('clicked') do
			browse
		end
		table.attach_defaults(browse_button, 14,15,1,2)
		@category = Gtk::ComboBox.new
		add_category_button = Gtk::Button.new("Add")
		add_category_button.signal_connect('clicked') do
			add_category
		end
		rename_category_button = Gtk::Button.new("Rename")
		rename_category_button.signal_connect('clicked') do
			rename_category
		end
		remove_category_button = Gtk::Button.new("Remove")
		remove_category_button.signal_connect('clicked') do
			remove_category
		end
		category_label = Gtk::Label.new("Category")
		category_label.max_width_chars = 10
		category_label.justify = Gtk::JUSTIFY_LEFT
		category_label.modify_bg(Gtk::STATE_NORMAL, Gdk::Color::parse("#000000"))
		table.attach_defaults(category_label, 0,1,2,3)
		table.attach_defaults(@category, 1,10,2,3)
		table.attach_defaults(add_category_button, 12,13,2,3)
		table.attach_defaults(rename_category_button, 13,14,2,3)
		table.attach_defaults(remove_category_button, 14,15,2,3)
		keyboard_label = Gtk::Label.new("XKBD Layout")
		keyboard_label.max_width_chars = 10
		keyboard_label.justify = Gtk::JUSTIFY_LEFT
		keyboard_label.modify_bg(Gtk::STATE_NORMAL, Gdk::Color::parse("#000000"))
		table.attach_defaults(keyboard_label, 0,1,3,4)
		@keyboard_element = Gtk::TreeStore.new(TrueClass, String, Gtk::ListStore, Integer, TrueClass, String, String)
		@keyboard_list = Gtk::TreeView.new(@keyboard_element)
		@keyboard_list.headers_visible = true
		@keyboard_list.selection.mode = Gtk::SELECTION_MULTIPLE
		["Enabled", "Layout", "Location", "Path"].each_with_index do | field, i |
			renderer = nil
			col = nil
			if i == 2
				renderer = Gtk::CellRendererCombo.new
				renderer.editable = true
				col = Gtk::TreeViewColumn.new(field, renderer, :model => i, :text_column => i + 1, :has_entry =>  i + 2, :text =>  i + 3)
				@keyboard_list.append_column(col)
				renderer.signal_connect("edited") do |renderer, path, text|
					iter = @keyboard_element.get_iter(path)
					iter[5] = text
				end
			elsif i == 1
				renderer = Gtk::CellRendererText.new
				col = Gtk::TreeViewColumn.new(field, renderer, :text => i)
				renderer.editable = false
				@keyboard_list.append_column(col)
			elsif i == 0
				renderer = Gtk::CellRendererToggle.new
				col = Gtk::TreeViewColumn.new(field, renderer, :active => i)
				renderer.activatable = true
				renderer.signal_connect("toggled") do | widget , path |
					iter = @keyboard_element.get_iter(path)
					iter.set_value(0, !iter.get_value(0))
				end
				@keyboard_list.append_column(col)
			end
		end
		sw = Gtk::ScrolledWindow.new
		sw.add(@keyboard_list)
		sw.set_policy(Gtk::POLICY_NEVER, Gtk::POLICY_AUTOMATIC)
		table.attach_defaults(sw, 1,15,3,4)
		
		@mapper = Gtk::ComboBox.new
		mapper_label = Gtk::Label.new("Mapper")
		mapper_label.max_width_chars = 10
		mapper_label.justify = Gtk::JUSTIFY_LEFT
		mapper_label.modify_bg(Gtk::STATE_NORMAL, Gdk::Color::parse("#000000"))
		table.attach_defaults(mapper_label, 0,1,4,5)
		table.attach_defaults(@mapper, 1,15,4,5)
		@mapper.signal_connect('changed') do | widget |
			change_mapper
		end
		@settings_element = Gtk::TreeStore.new(TrueClass, String, String, String)
		@settings_list = Gtk::TreeView.new(@settings_element)
		@settings_list.headers_visible = true
		@settings_list.selection.mode = Gtk::SELECTION_MULTIPLE
		["Enabled", "Section", "Key", "Value"].each_with_index do | field, i |
			renderer = nil
			col = nil
			if i != 0 && i != 4
				renderer = Gtk::CellRendererText.new
				col = Gtk::TreeViewColumn.new(field, renderer, :text => i)
				if i == 3
					renderer.editable = true
					renderer.signal_connect('edited') do | widget, path, value |
						iter = @settings_element.get_iter(path)
						iter.set_value(3, value)
						apply_settings(iter.get_value(0), iter.get_value(1), iter.get_value(2), iter.get_value(3))
					end
				end
			elsif i == 0
				renderer = Gtk::CellRendererToggle.new
				col = Gtk::TreeViewColumn.new(field, renderer, :active => i)
				renderer.activatable = true
				renderer.active = true
				renderer.signal_connect("toggled") do | widget , path |
					iter = @settings_element.get_iter(path)
					iter.set_value(0, !iter.get_value(0))
					apply_settings(iter.get_value(0), iter.get_value(1), iter.get_value(2), iter.get_value(3))
				end
			end
			@settings_list.append_column(col)
		end
		sw = Gtk::ScrolledWindow.new
		sw.add(@settings_list)
		sw.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
		table.attach_defaults(sw, 0,15,5,14)
		button_container = Gtk::HButtonBox.new
		button_container.layout_style = Gtk::ButtonBox::START
		save_button = Gtk::Button.new("Save")
		save_button.signal_connect( "button_press_event" ) do | w, e |
			save_settings
		end
		cancel_button = Gtk::Button.new("Cancel")
		cancel_button.signal_connect( "button_press_event" ) do | w, e |
			@rbox.page(0)
		end
		@settings_type = Gtk::Button.new("Show basic settings")
		@settings_type.signal_connect('button_press_event') do | w, e |
			show_settings
		end
		button_container.add(@settings_type)
		button_container.add(save_button)
		button_container.add(cancel_button)
		table.attach_defaults(button_container, 0,15,14,15)
		clear_settings
	end
	
	def clear_combo(combo)
		count = 0
		combo.model.each do | model, path, iter |
			count += 1
		end
		count.times do | i |
			combo.remove_text(0)
		end
	end
	
	def list_keyboard_layouts
		@keyboard_element.clear
		#clear_combo(@keyboard_element)
		filelist = Array.new
		[File.join(ENV["HOME"], ".rubybox", ".xkbd_layouts"), "/usr/share/dosbox"].each do | scanned |
			Dir["#{scanned}/*.xkbd"].each do | file |
				filelist.push(file)
			end
		end
		filelist.each do | file |
			row = @keyboard_element.append(nil)
			row[0] = @keyboards.keys.include?(file)
			row[1] = File.basename(file)
			list = Gtk::ListStore.new(String)
			["Top Left", "Top Center", "Top Right", "Middle Left", "Middle Right", "Bottom Left", "Bottom Center", "Bottom Right"].each do | location |
				val = list.append
				val[0] = location
			end 
			row[2] = list
			row[5] = @keyboards[file] if @keyboards[file]
			row[6] = file
		end
	end
	
	def list_mappers(combobox, path, extension, filelist = nil)
		@mappers = Array.new
		clear_combo(combobox)
		combobox.append_text("")
		@mappers.push("")
		combobox.active = 0
		filelist = Array.new if !filelist
		path.each do | dir |
			Dir["#{dir}/*.#{extension}"].each do | file |
				filelist.push(file)
			end
		end
		filelist.each_with_index do | file, i |
			if File.exists?(file)
				@mappers.push(file)
				combobox.append_text(File.basename(file, ".*"))
				combobox.active = @mappers.size - 1 if @advanced_settings && @advanced_settings["sdl"]["mapperfile"] == file
			end
		end
		combobox.active = 0 if combobox.active == -1
	end
	
	def change_mapper
		if !@loading
			@advanced_settings["sdl"]["mapperfile"] = @mappers[@mapper.active]
			@states.delete("0,sdl,mapperfile")
			@states.delete("1,sdl,mapperfile")
			id = "#{@mapper.active != 0 ? "1" : "0"},sdl,mapperfile"
			@states.push(id) if !@states.include?(id)
			if @settings_type.label == "Show basic settings"
				@settings_list.model.each do | model, path, iter |
					if iter[1] == "sdl" && iter[2] == "mapperfile"
						iter[0] = @mapper.active != 0
						iter[3] = @mappers[@mapper.active]
						return
					end
				end
			end
		end
	end
	
	def apply_settings(active, section, key, value)
		prefs = (@settings_type.label == "Show advanced settings" ? @basic_settings : @advanced_settings)
		type = @settings_type.label == "Show advanced settings" ? "0" : "1"
		prefs[section] = Hash.new if !prefs[section] # shouldn't happen
		prefs[section][key] = value
		id = type + "," + section + "," + key
		if active
			@states.push(id) if !@states.include?(id)
		else
			@states.delete(id)
		end
	end
	
	def configfile
		@configfile
	end

	def clear_settings
		@old_category = nil
		@executable.text = ""
		@game_name.text = ""
		["/usr/share/dosbox/dosbox.conf", File.join(ENV["HOME"], "apps", "DOSBox 0.73 Preferences.txt")].each do | file |
			if File.exists?(file)
			@configfile = file
				@advanced_settings = read_config(file, false)
				break
			end
		end
		if !@advanced_settings
			response = @rbox.dialogs.confirm("Error", "Unable to find Dosbox config file.\nPress OK to run Dosbox to generate it or cancel to quit.")
			if response
				IO.popen("/usr/bin/dosbox")
				Process.wait
				sleep(1)
				system("killall -9 dosbox")
				clear_settings
				return
			else
				exit(0)
			end
		end
		@states = Array.new
		@settings_type.label = "Show basic settings"
		update_categories
	end

	def show_settings
		@settings_element.clear
		#clear_combo(@settings_element)
		@settings_type.label = @settings_type.label == "Show advanced settings" ? "Show basic settings" : "Show advanced settings"
		type = @settings_type.label == "Show advanced settings" ? "0" : "1"
		prefs = (@settings_type.label == "Show advanced settings" ? @basic_settings : @advanced_settings)
		prefs.keys.sort.each do | key |
			index = 0
			prefs[key].keys.sort.each do | key2 |				
				row = @settings_element.append(nil)
				row[0] = @states.include?(type + "," + key + "," + key2)
				row[1] = key
				row[2] = key2
				row[3] = prefs[key][key2]
			end
		end
	end

	def update_categories
		#@category.clear
		clear_combo(@category)
		@category.append_text("")
		Dir.entries(@rbox.prefsdir).sort.each do | file |
			if !file.index(".") && File.directory?(File.join(@rbox.prefsdir, file))
				@category.append_text(file.gsub("_", " "))
			end
		end
	end

	def select_category(text)
		text = text.gsub("_", " ")
		index = 0
		@category.model.each do |model,path,iter|
			if iter[0].downcase == text.downcase
				@category.active = index
				return
			end
			index += 1
		end
	end

	def browse
		dialog = Gtk::FileChooserDialog.new("Select the application executable",
			@rbox,
			Gtk::FileChooser::ACTION_OPEN,
			nil,
			[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
			[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_ACCEPT])
		dialog.current_folder = @current_dir || "/media"
		if dialog.run == Gtk::Dialog::RESPONSE_ACCEPT
			@executable.text = dialog.filename
			@current_dir = File.dirname(dialog.filename)
		end
		dialog.destroy
	end

	def read_config(filename, force)
		settings = Hash.new
		if File.exists?(filename)
			section = ""
			File.new(filename).readlines.each do | line |
				line = line.strip
				if line.length > 0 && line[0,1] != "#"
					if line.index("[") && line.index("]")
						section = line[1..line.length - 2]
					elsif line.index("=")
						setting = line.split("=")
						if setting.size == 2
							if force || !@basic_settings[section] || !@basic_settings[section][setting[0]]
								settings[section] = Hash.new if !settings[section]
								settings[section][setting[0]] = setting[1]
							else
								@basic_settings[section][setting[0]] = setting[1]
							end
						end
					end
				end
			end
		end
		return settings
	end

	def new_game
		clear_settings
		list_keyboard_layouts
		list_mappers(@mapper, [File.join(ENV["HOME"], ".rubybox", ".mappers")], "txt", ["/usr/share/dosbox/mapper.txt"])
		show_settings
		@rbox.page(1)
	end

	def load_game(name, executable, filename, keyboards)
		@loading = true
		clear_settings
		@game_name.text = name
		@executable.text = executable
		@current_dir = File.dirname(executable) if File.exists?(File.dirname(executable))
		@keyboards = Hash.new
		if keyboards && keyboards.strip != ""
			keyboards.split("|").each do | keyboard |
				keyboard = keyboard.split("=")
				@keyboards[keyboard[0]] = keyboard[1] || ""
			end
		end
		settings = read_config(filename, true)
		settings.each_key do | key |
			settings[key].each_key do | key2 |
				if @basic_settings[key] && @basic_settings[key][key2]
					@basic_settings[key][key2] = settings[key][key2]
					@states.push("0,#{key},#{key2}")
					
				elsif @advanced_settings[key] && @advanced_settings[key][key2]
					@advanced_settings[key][key2] = settings[key][key2]
					@states.push("1,#{key},#{key2}")
				end
			end
		end
		list_keyboard_layouts
		show_settings
		@old_category = File.basename(File.dirname(filename)) != ".rubybox" ? File.basename(File.dirname(filename)).gsub("_", " ") : nil
		select_category(@old_category) if @old_category
		list_mappers(@mapper, [File.join(ENV["HOME"], ".rubybox", ".mappers")], "txt", ["/usr/share/dosbox/mapper.txt"])
		@rbox.page(1)
		@loading = false
	end

	def add_category
		dir = @rbox.dialogs.prompt("New category", "Name of the category:")
		if dir && dir[0] && dir[0].size > 0
			f = File.join(@rbox.prefsdir, dir[0].gsub(" ", "_"))
			if !File.exists?(f)
				FileUtils.mkdir(f)
				update_categories
				select_category(dir[0])
			end
		end
	end
	
	def rename_category
		if @category.active_text && @category.active_text.length > 0
			dir = @rbox.dialogs.prompt("Rename category", "Name of the category:")
			if dir && dir[0] && dir[0].size > 0
				old_dir = File.join(@rbox.prefsdir, @category.active_text.gsub(" ", "_"))
				new_dir = File.join(@rbox.prefsdir, dir[0].gsub(" ", "_"))
				if File.exists?(old_dir) && !File.exists?(new_dir)
					FileUtils.mv(old_dir, new_dir)
					update_categories
					select_category(dir[0])
					@rbox.update_gamelist
				end
			end
		end
	end

	def remove_category
		if @category.active_text && @category.active_text.length > 0
			if @rbox.dialogs.confirm("Remove category?", "Are you sure you want to remove this category?")
				begin
					f = File.join(@rbox.prefsdir, @category.active_text.gsub(" ", "_"))
					Dir.entries(f).each do | file |
						if !File.directory?(File.join(f, file))
							FileUtils.mv(File.join(f, file), File.join(@rbox.prefsdir, file))
						end
					end
					FileUtils.rmdir(f)
					update_categories
					@rbox.update_gamelist
				rescue Exception => e
					puts e.backtrace.join("\n")
				end
			end
		end
	end

	def save_settings
		if @game_name.text.strip.length == 0
			Hildon::Banner.show_information(@rbox, "rbox", "Please enter the name")
			return
		elsif @executable.text.strip.length == 0
			Hildon::Banner.show_information(@rbox, "rbox", "Please select the executable")
			return
		end
		saved = Hash.new
		@states.each do | line |
			tokens = line.split(",")
			prefs = (tokens[0].to_i == 0 ? @basic_settings : @advanced_settings)
			saved[tokens[1]] = Hash.new if !saved[tokens[1]]
			saved[tokens[1]][tokens[2]] = prefs[tokens[1]][tokens[2]]
		end
		keyboards = Array.new
		@keyboard_list.model.each do | model, path, iter |
			keyboards.push("#{iter[6]}=#{iter[5]}")	if iter[0]
		end
		data = "# DosBox config created by RubyBox\n# #{@game_name.text}\n# #{@executable.text}\n# #{keyboards.join("|")}\n"
		saved.each_key do | section |
			data += "[#{section}]\n"
			saved[section].each_key do | key2 |
				data += "#{key2}=#{saved[section][key2]}\n"
			end
		end
		filename = CGI::escape(@game_name.text.downcase.gsub(" ", "_")).gsub("%", "")
		f = File.new(File.join(@rbox.prefsdir, @category.active_text ? @category.active_text.gsub(" ", "_") : "", "#{filename}.conf"), "w")
		f.write(data)
		f.close
		@rbox.page(0)
		if @old_category != @category.active_text
			begin
				old = File.join(@rbox.prefsdir, @old_category ? @old_category.gsub(" ", "_") : "", "#{filename}.conf")
				FileUtils.rm(old) if File.exists?(old) && old != f.path
			rescue Exception => e
			end
		end
		@rbox.update_gamelist
	end
end
